/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.framework.interactions.core.actions;

import java.util.Arrays;
import java.util.Collections;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.Set;
import org.eclipse.vtp.framework.common.IBrand;
import org.eclipse.vtp.framework.common.IBrandSelection;
import org.eclipse.vtp.framework.common.IDataObject;
import org.eclipse.vtp.framework.common.IDataType;
import org.eclipse.vtp.framework.common.IDataTypeRegistry;
import org.eclipse.vtp.framework.common.IStringObject;
import org.eclipse.vtp.framework.common.IVariableRegistry;
import org.eclipse.vtp.framework.common.actions.AssignmentAction;
import org.eclipse.vtp.framework.common.configurations.AssignmentConfiguration;
import org.eclipse.vtp.framework.common.support.CustomDataField;
import org.eclipse.vtp.framework.common.support.CustomDataType;
import org.eclipse.vtp.framework.core.IActionContext;
import org.eclipse.vtp.framework.core.IActionResult;
import org.eclipse.vtp.framework.interactions.core.conversation.IConversation;
import org.eclipse.vtp.framework.util.Guid;

public class InitialAction
extends AssignmentAction {
    private static final Set INITAL_TYPES = Collections.unmodifiableSet(new HashSet(Arrays.asList("Boolean", "Date", "Decimal", "Number")));
    private final IConversation conversation;
    private final IBrandSelection brand;
    private final IDataTypeRegistry dataTypeRegistry;

    public InitialAction(IActionContext context, IVariableRegistry variableRegistry, IDataTypeRegistry dataTypeRegistry, AssignmentConfiguration[] assignCongigs, IConversation conversation, IBrandSelection brand) {
        super(context, variableRegistry, assignCongigs);
        this.conversation = conversation;
        this.brand = brand;
        this.dataTypeRegistry = dataTypeRegistry;
    }

    public IActionResult execute() {
        String result = this.context.getParameter(this.context.getActionID());
        if ("success.filled".equals(result)) {
            Hashtable<String, String> props = new Hashtable<String, String>();
            ((Dictionary)props).put("event", "initial.after");
            this.context.report(3, "Processing initial variables.", props);
            IDataObject platform = this.variableRegistry.createVariable("Platform");
            String[] fields = platform.getType().getFieldNames();
            int i = 0;
            while (i < fields.length) {
                String value = this.context.getParameter(fields[i]);
                if (value != null) {
                    Hashtable<String, String> props2 = new Hashtable<String, String>();
                    ((Dictionary)props2).put("event", "assignment");
                    ((Dictionary)props2).put("event.key", "Platform." + fields[i]);
                    ((Dictionary)props2).put("event.value", String.valueOf(value));
                    this.context.report(3, "Assigned variable \"Platform." + fields[i] + "\" to \"" + value + "\"", props2);
                    ((IStringObject)platform.getField(fields[i])).setValue((Object)value);
                }
                ++i;
            }
            IBrand b = this.brand.getSelectedBrand();
            if (b != null) {
                ((IStringObject)platform.getField("Brand")).setValue((Object)b.getName());
            }
            this.variableRegistry.setVariable("Platform", platform);
            HashMap<String, String> values = new HashMap<String, String>();
            int i2 = 0;
            while (i2 < this.configurations.length) {
                String value = this.context.getParameter(this.configurations[i2].getName());
                if (value != null && value.length() > 0) {
                    values.put(this.configurations[i2].getName(), value);
                }
                ++i2;
            }
            return this.execute(values);
        }
        try {
            String[] incomingParametersNames = this.context.getParameterNames();
            if (incomingParametersNames.length > 0) {
                CustomDataField[] fields = new CustomDataField[incomingParametersNames.length];
                int i = 0;
                while (i < incomingParametersNames.length) {
                    String parameter = this.context.getParameter(incomingParametersNames[i]);
                    fields[i] = new CustomDataField(incomingParametersNames[i], this.dataTypeRegistry.getDataType("String"), parameter == null ? "" : parameter);
                    ++i;
                }
                CustomDataType cdt = new CustomDataType(Guid.createGUID(), incomingParametersNames[0], fields);
                IDataObject initialParameters = this.variableRegistry.createVariable((IDataType)cdt);
                this.variableRegistry.setVariable("InitialParameters", initialParameters);
            }
            Hashtable<String, String> props = new Hashtable<String, String>();
            ((Dictionary)props).put("event", "initial.before");
            this.context.report(3, "Requesting initial variables.", props);
            LinkedHashMap<String, String> vars = new LinkedHashMap<String, String>();
            if (!"false".equals(this.context.getAttribute("fragment")) && "true".equals(this.context.getProperty("fragment"))) {
                int i = 0;
                while (i < this.configurations.length) {
                    if (INITAL_TYPES.contains(this.configurations[i].getType())) {
                        vars.put(this.configurations[i].getName(), this.configurations[i].getValue());
                    }
                    ++i;
                }
            }
            this.conversation.createInitial(this.context.getActionID(), vars).enqueue();
        }
        catch (NullPointerException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        return this.context.createResult("repeat");
    }
}

