/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.framework.interactions.core.actions;

import java.util.Dictionary;
import java.util.Hashtable;
import org.eclipse.vtp.framework.core.IAction;
import org.eclipse.vtp.framework.core.IActionContext;
import org.eclipse.vtp.framework.core.IActionResult;
import org.eclipse.vtp.framework.interactions.core.configurations.OutputMessageConfiguration;
import org.eclipse.vtp.framework.interactions.core.conversation.IConversation;

public class OutputMessageAction
implements IAction {
    private final IActionContext context;
    private final IConversation conversation;
    private final OutputMessageConfiguration configuration;

    public OutputMessageAction(IActionContext context, IConversation conversation, OutputMessageConfiguration configuration) {
        this.context = context;
        this.conversation = conversation;
        this.configuration = configuration;
    }

    public IActionResult execute() {
        try {
            Hashtable<String, String> props = new Hashtable<String, String>();
            ((Dictionary)props).put("event", "output.message");
            this.context.report(3, "Sending output.", props);
            this.conversation.createOutputMessage(this.configuration).enqueue();
            this.context.info("Output sent.");
            return this.context.createResult("default");
        }
        catch (RuntimeException e) {
            return this.context.createResult("error.output.message", (Throwable)e);
        }
    }
}

