/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.framework.interactions.core.actions;

import java.util.Dictionary;
import java.util.Hashtable;
import org.eclipse.vtp.framework.core.IAction;
import org.eclipse.vtp.framework.core.IActionContext;
import org.eclipse.vtp.framework.core.IActionResult;
import org.eclipse.vtp.framework.interactions.core.configurations.SelectionRequestConfiguration;
import org.eclipse.vtp.framework.interactions.core.conversation.IConversation;

public class SelectionRequestAction
implements IAction {
    private final IActionContext context;
    private final IConversation conversation;
    private final SelectionRequestConfiguration configuration;

    public SelectionRequestAction(IActionContext context, IConversation conversation, SelectionRequestConfiguration configuration) {
        this.context = context;
        this.conversation = conversation;
        this.configuration = configuration;
    }

    public IActionResult execute() {
        try {
            this.context.debug(this.getClass().getName().substring(this.getClass().getName().lastIndexOf(46) + 1));
            String result = this.context.getParameter(this.context.getActionID());
            if ("success.filled".equals(result)) {
                Hashtable<String, String> props = new Hashtable<String, String>();
                ((Dictionary)props).put("event", "selection.request.filled");
                ((Dictionary)props).put("event.key", "selection");
                ((Dictionary)props).put("event.value", this.context.getParameter(this.configuration.getDataName()));
                this.context.report(3, "Got requested selection \"" + this.context.getParameter(this.configuration.getDataName()) + "\"", props);
                return this.context.createResult(this.context.getParameter(this.configuration.getDataName()));
            }
            if ("error.input.noinput".equals(result)) {
                Hashtable<String, String> props = new Hashtable<String, String>();
                ((Dictionary)props).put("event", "selection.request.noinput");
                this.context.report(3, "Got no input for requested selection.", props);
                return this.context.createResult("error.input.noinput");
            }
            if ("error.input.nomatch".equals(result)) {
                Hashtable<String, String> props = new Hashtable<String, String>();
                ((Dictionary)props).put("event", "selection.request.nomatch");
                this.context.report(3, "Got no match for requested selection.", props);
                return this.context.createResult("error.input.nomatch");
            }
            Hashtable<String, String> props = new Hashtable<String, String>();
            ((Dictionary)props).put("event", "selection.request.before");
            this.context.report(3, "Requesting selection \"" + this.configuration.getDataName() + "\".", props);
            this.conversation.createSelectionRequest(this.configuration, this.context.getActionID()).enqueue();
            return this.context.createResult("repeat");
        }
        catch (RuntimeException e) {
            return this.context.createResult("error.selection.request", (Throwable)e);
        }
    }
}

