/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.framework.interactions.core.commands;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.vtp.framework.interactions.core.commands.ConversationCommand;
import org.eclipse.vtp.framework.interactions.core.commands.IConversationCommandVisitor;

public final class DataRequestCommand
extends ConversationCommand {
    private String dataName = null;
    private String resultName = null;
    private String filledResultValue = null;
    private String noInputResultValue = null;
    private final Map properties = new HashMap();
    private final List output = new ArrayList();
    private final Map parameters = new HashMap();

    public String getDataName() {
        return this.dataName;
    }

    public void setDataName(String inputName) {
        this.dataName = inputName;
    }

    public String getResultName() {
        return this.resultName;
    }

    public void setResultName(String resultName) {
        this.resultName = resultName;
    }

    public String getFilledResultValue() {
        return this.filledResultValue;
    }

    public void setFilledResultValue(String filledResultValue) {
        this.filledResultValue = filledResultValue;
    }

    public String getNoInputResultValue() {
        return this.noInputResultValue;
    }

    public void setNoInputResultValue(String noInputResultValue) {
        this.noInputResultValue = noInputResultValue;
    }

    public String[] getPropertyNames() {
        return this.properties.keySet().toArray(new String[this.properties.size()]);
    }

    public String getPropertyValue(String name) {
        if (name == null) {
            return null;
        }
        return (String)this.properties.get(name);
    }

    public void setPropertyValue(String name, String value) {
        if (name == null) {
            return;
        }
        if (value == null) {
            this.properties.remove(name);
        } else {
            this.properties.put(name, value);
        }
    }

    public int getOutputCount() {
        return this.output.size();
    }

    public int getOutputType(int outputIndex) {
        if (outputIndex < 0 || outputIndex >= this.output.size()) {
            return 0;
        }
        return ((ConversationCommand.Output)this.output.get((int)outputIndex)).type;
    }

    public String getOutputValue(int outputIndex) {
        if (outputIndex < 0 || outputIndex >= this.output.size()) {
            return null;
        }
        return ((ConversationCommand.Output)this.output.get((int)outputIndex)).value;
    }

    public void addFileOutput(String path) {
        this.insertFileOutput(this.output.size(), path);
    }

    public void addTextOutput(String text) {
        this.insertTextOutput(this.output.size(), text);
    }

    public void insertFileOutput(int outputIndex, String path) {
        if (path != null && outputIndex >= 0 && outputIndex <= this.output.size()) {
            this.output.add(outputIndex, new ConversationCommand.Output(1, path));
        }
    }

    public void insertTextOutput(int outputIndex, String text) {
        if (text != null && outputIndex >= 0 && outputIndex <= this.output.size()) {
            this.output.add(outputIndex, new ConversationCommand.Output(2, text));
        }
    }

    public void setFileOutput(int outputIndex, String path) {
        if (path != null && outputIndex >= 0 && outputIndex < this.output.size()) {
            this.output.set(outputIndex, new ConversationCommand.Output(1, path));
        }
    }

    public void setTextOutput(int outputIndex, String text) {
        if (text != null && outputIndex >= 0 && outputIndex < this.output.size()) {
            this.output.set(outputIndex, new ConversationCommand.Output(2, text));
        }
    }

    public void removeOutput(int outputIndex) {
        if (outputIndex >= 0 && outputIndex < this.output.size()) {
            this.output.remove(outputIndex);
        }
    }

    public String[] getParameterNames() {
        return this.parameters.keySet().toArray(new String[this.parameters.size()]);
    }

    public String[] getParameterValues(String name) {
        if (name == null) {
            return null;
        }
        List list = (List)this.parameters.get(name);
        if (list == null) {
            return null;
        }
        return list.toArray(new String[list.size()]);
    }

    public void setParameterValues(String name, String[] values) {
        if (name == null) {
            return;
        }
        if (values == null) {
            this.parameters.remove(name);
        } else {
            LinkedList<String> list = (LinkedList<String>)this.parameters.get(name);
            if (list == null) {
                list = new LinkedList<String>();
                this.parameters.put(name, list);
            } else {
                list.clear();
            }
            int i = 0;
            while (i < values.length) {
                if (values[i] != null) {
                    list.add(values[i]);
                }
                ++i;
            }
        }
    }

    Object accept(IConversationCommandVisitor visitor) {
        return visitor.visitDataRequest(this);
    }

    public Object exportContents() {
        ArrayList<String> properties = new ArrayList<String>(this.properties.size() * 2);
        for (Map.Entry entry : this.properties.entrySet()) {
            properties.add((String)entry.getKey());
            properties.add((String)entry.getValue());
        }
        ArrayList<String> output = new ArrayList<String>(this.output.size() * 2);
        for (ConversationCommand.Output entry : this.output) {
            output.add(String.valueOf(entry.type));
            output.add(entry.value);
        }
        ArrayList<String> parameters = new ArrayList<String>(this.parameters.size() * 2);
        for (Map.Entry entry : this.parameters.entrySet()) {
            parameters.add((String)entry.getKey());
            parameters.add((String)entry.getValue());
        }
        return new Object[]{this.dataName, this.resultName, this.filledResultValue, this.noInputResultValue, properties.toArray(new String[properties.size()]), output.toArray(new String[output.size()]), parameters.toArray(new String[parameters.size()])};
    }

    public void importContents(Object contents) {
        Object[] array = (Object[])contents;
        this.dataName = (String)array[0];
        this.resultName = (String)array[1];
        this.filledResultValue = (String)array[2];
        this.noInputResultValue = (String)array[3];
        this.properties.clear();
        String[] properties = (String[])array[4];
        int i = 0;
        while (i < properties.length) {
            this.properties.put(properties[i], properties[i + 1]);
            i += 2;
        }
        this.output.clear();
        String[] output = (String[])array[5];
        int i2 = 0;
        while (i2 < output.length) {
            this.output.add(new ConversationCommand.Output(Integer.parseInt(output[i2]), output[i2 + 1]));
            i2 += 2;
        }
        this.parameters.clear();
        String[] parameters = (String[])array[6];
        int i3 = 0;
        while (i3 < parameters.length) {
            this.parameters.put(parameters[i3], parameters[i3 + 1]);
            i3 += 2;
        }
    }
}

