/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.framework.interactions.core.commands;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.vtp.framework.interactions.core.commands.ConversationCommand;
import org.eclipse.vtp.framework.interactions.core.commands.IConversationCommandVisitor;

public final class SelectionRequestCommand
extends ConversationCommand {
    private String selectionName = null;
    private String resultName = null;
    private String filledResultValue = null;
    private String noInputResultValue = null;
    private String noMatchResultValue = null;
    private final Map properties = new HashMap();
    private final List output = new ArrayList();
    private final List options = new ArrayList();
    private final Map parameters = new HashMap();

    public String getSelectionName() {
        return this.selectionName;
    }

    public void setSelectionName(String inputName) {
        this.selectionName = inputName;
    }

    public String getResultName() {
        return this.resultName;
    }

    public void setResultName(String resultName) {
        this.resultName = resultName;
    }

    public String getFilledResultValue() {
        return this.filledResultValue;
    }

    public void setFilledResultValue(String filledResultValue) {
        this.filledResultValue = filledResultValue;
    }

    public String getNoInputResultValue() {
        return this.noInputResultValue;
    }

    public void setNoInputResultValue(String noInputResultValue) {
        this.noInputResultValue = noInputResultValue;
    }

    public String getNoMatchResultValue() {
        return this.noMatchResultValue;
    }

    public void setNoMatchResultValue(String noMatchResultValue) {
        this.noMatchResultValue = noMatchResultValue;
    }

    public String[] getPropertyNames() {
        return this.properties.keySet().toArray(new String[this.properties.size()]);
    }

    public String getPropertyValue(String name) {
        if (name == null) {
            return null;
        }
        return (String)this.properties.get(name);
    }

    public void setPropertyValue(String name, String value) {
        if (name == null) {
            return;
        }
        if (value == null) {
            this.properties.remove(name);
        } else {
            this.properties.put(name, value);
        }
    }

    public int getOutputCount() {
        return this.output.size();
    }

    public int getOutputType(int outputIndex) {
        if (outputIndex < 0 || outputIndex >= this.output.size()) {
            return 0;
        }
        return ((ConversationCommand.Output)this.output.get((int)outputIndex)).type;
    }

    public String getOutputValue(int outputIndex) {
        if (outputIndex < 0 || outputIndex >= this.output.size()) {
            return null;
        }
        return ((ConversationCommand.Output)this.output.get((int)outputIndex)).value;
    }

    public void addFileOutput(String path) {
        this.insertFileOutput(this.output.size(), path);
    }

    public void addTextOutput(String text) {
        this.insertTextOutput(this.output.size(), text);
    }

    public void insertFileOutput(int outputIndex, String path) {
        if (path != null && outputIndex >= 0 && outputIndex <= this.output.size()) {
            this.output.add(outputIndex, new ConversationCommand.Output(1, path));
        }
    }

    public void insertTextOutput(int outputIndex, String text) {
        if (text != null && outputIndex >= 0 && outputIndex <= this.output.size()) {
            this.output.add(outputIndex, new ConversationCommand.Output(2, text));
        }
    }

    public void setFileOutput(int outputIndex, String path) {
        if (path != null && outputIndex >= 0 && outputIndex < this.output.size()) {
            this.output.set(outputIndex, new ConversationCommand.Output(1, path));
        }
    }

    public void setTextOutput(int outputIndex, String text) {
        if (text != null && outputIndex >= 0 && outputIndex < this.output.size()) {
            this.output.set(outputIndex, new ConversationCommand.Output(2, text));
        }
    }

    public void removeOutput(int outputIndex) {
        if (outputIndex >= 0 && outputIndex < this.output.size()) {
            this.output.remove(outputIndex);
        }
    }

    public int getOptionCount() {
        return this.options.size();
    }

    public String getOption(int optionIndex) {
        if (optionIndex < 0 || optionIndex >= this.options.size()) {
            return null;
        }
        return ((Option)this.options.get((int)optionIndex)).name;
    }

    public void addOption(String optionName) {
        this.insertOption(this.options.size(), optionName);
    }

    public void insertOption(int optionIndex, String optionName) {
        if (optionName != null && optionIndex >= 0 && optionIndex <= this.options.size()) {
            this.options.add(optionIndex, new Option(optionName));
        }
    }

    public void setOption(int optionIndex, String optionName) {
        if (optionName != null && optionIndex >= 0 && optionIndex < this.options.size()) {
            this.options.set(optionIndex, new Option(optionName));
        }
    }

    public void removeOption(int optionIndex) {
        if (optionIndex >= 0 && optionIndex < this.options.size()) {
            this.options.remove(optionIndex);
        }
    }

    public int getOptionOutputCount(int optionIndex) {
        if (optionIndex < 0 || optionIndex >= this.options.size()) {
            return 0;
        }
        return ((Option)this.options.get((int)optionIndex)).output.size();
    }

    public int getOptionOutputType(int optionIndex, int optionOutputIndex) {
        if (optionIndex < 0 || optionIndex >= this.options.size()) {
            return 0;
        }
        Option option = (Option)this.options.get(optionIndex);
        if (optionOutputIndex < 0 || optionOutputIndex >= option.output.size()) {
            return 0;
        }
        return ((ConversationCommand.Output)option.output.get((int)optionOutputIndex)).type;
    }

    public String getOptionOutputValue(int optionIndex, int optionOutputIndex) {
        if (optionIndex < 0 || optionIndex >= this.options.size()) {
            return null;
        }
        Option option = (Option)this.options.get(optionIndex);
        if (optionOutputIndex < 0 || optionOutputIndex >= option.output.size()) {
            return null;
        }
        return ((ConversationCommand.Output)option.output.get((int)optionOutputIndex)).value;
    }

    public void addOptionFileOutput(int optionIndex, String path) {
        if (optionIndex < 0 || optionIndex >= this.options.size()) {
            return;
        }
        Option option = (Option)this.options.get(optionIndex);
        this.insertOptionFileOutput(optionIndex, option.output.size(), path);
    }

    public void addOptionTextOutput(int optionIndex, String text) {
        if (optionIndex < 0 || optionIndex >= this.options.size()) {
            return;
        }
        Option option = (Option)this.options.get(optionIndex);
        this.insertOptionTextOutput(optionIndex, option.output.size(), text);
    }

    public void insertOptionFileOutput(int optionIndex, int optionOutputIndex, String path) {
        if (optionIndex < 0 || optionIndex >= this.options.size()) {
            return;
        }
        Option option = (Option)this.options.get(optionIndex);
        if (path != null && optionOutputIndex >= 0 && optionOutputIndex <= option.output.size()) {
            option.output.add(optionOutputIndex, new ConversationCommand.Output(1, path));
        }
    }

    public void insertOptionTextOutput(int optionIndex, int optionOutputIndex, String text) {
        if (optionIndex < 0 || optionIndex >= this.options.size()) {
            return;
        }
        Option option = (Option)this.options.get(optionIndex);
        if (text != null && optionOutputIndex >= 0 && optionOutputIndex <= option.output.size()) {
            option.output.add(optionOutputIndex, new ConversationCommand.Output(2, text));
        }
    }

    public void setOptionFileOutput(int optionIndex, int optionOutputIndex, String path) {
        if (optionIndex < 0 || optionIndex >= this.options.size()) {
            return;
        }
        Option option = (Option)this.options.get(optionIndex);
        if (path != null && optionOutputIndex >= 0 && optionOutputIndex < option.output.size()) {
            option.output.set(optionOutputIndex, new ConversationCommand.Output(1, path));
        }
    }

    public void setOptionTextOutput(int optionIndex, int optionOutputIndex, String text) {
        if (optionIndex < 0 || optionIndex >= this.options.size()) {
            return;
        }
        Option option = (Option)this.options.get(optionIndex);
        if (text != null && optionOutputIndex >= 0 && optionOutputIndex < option.output.size()) {
            option.output.set(optionOutputIndex, new ConversationCommand.Output(2, text));
        }
    }

    public void removeOptionOutput(int optionIndex, int optionOutputIndex) {
        if (optionIndex < 0 || optionIndex >= this.options.size()) {
            return;
        }
        Option option = (Option)this.options.get(optionIndex);
        if (optionOutputIndex >= 0 && optionOutputIndex < option.output.size()) {
            option.output.remove(optionOutputIndex);
        }
    }

    public String getOptionProperty(int optionIndex, String key) {
        if (optionIndex < 0 || optionIndex >= this.options.size()) {
            return null;
        }
        return (String)((Option)this.options.get((int)optionIndex)).properties.get(key);
    }

    public void setOptionProperty(int optionIndex, String key, String value) {
        if (optionIndex < 0 || optionIndex >= this.options.size()) {
            return;
        }
        if (value == null) {
            ((Option)this.options.get((int)optionIndex)).properties.remove(key);
        } else {
            ((Option)this.options.get((int)optionIndex)).properties.put(key, value);
        }
    }

    public int getOptionInputType(int optionIndex) {
        if (optionIndex < 0 || optionIndex >= this.options.size()) {
            return 0;
        }
        Option option = (Option)this.options.get(optionIndex);
        if (option.input == null) {
            return 0;
        }
        return option.input.type;
    }

    public String getOptionInputValue(int optionIndex) {
        if (optionIndex < 0 || optionIndex >= this.options.size()) {
            return null;
        }
        Option option = (Option)this.options.get(optionIndex);
        if (option.input == null) {
            return null;
        }
        return option.input.value;
    }

    public void setOptionFileInput(int optionIndex, String path) {
        if (optionIndex < 0 || optionIndex >= this.options.size()) {
            return;
        }
        ((Option)this.options.get((int)optionIndex)).input = new ConversationCommand.Input(1, path);
    }

    public void setOptionCustomInput(int optionIndex, String customData) {
        if (optionIndex < 0 || optionIndex >= this.options.size()) {
            return;
        }
        ((Option)this.options.get((int)optionIndex)).input = new ConversationCommand.Input(Integer.MAX_VALUE, customData);
    }

    public String[] getParameterNames() {
        return this.parameters.keySet().toArray(new String[this.parameters.size()]);
    }

    public String[] getParameterValues(String name) {
        if (name == null) {
            return null;
        }
        List list = (List)this.parameters.get(name);
        if (list == null) {
            return null;
        }
        return list.toArray(new String[list.size()]);
    }

    public void setParameterValues(String name, String[] values) {
        if (name == null) {
            return;
        }
        if (values == null) {
            this.parameters.remove(name);
        } else {
            LinkedList<String> list = (LinkedList<String>)this.parameters.get(name);
            if (list == null) {
                list = new LinkedList<String>();
                this.parameters.put(name, list);
            } else {
                list.clear();
            }
            int i = 0;
            while (i < values.length) {
                if (values[i] != null) {
                    list.add(values[i]);
                }
                ++i;
            }
        }
    }

    Object accept(IConversationCommandVisitor visitor) {
        return visitor.visitSelectionRequest(this);
    }

    public Object exportContents() {
        ArrayList<String> properties = new ArrayList<String>(this.properties.size() * 2);
        for (Map.Entry entry : this.properties.entrySet()) {
            properties.add((String)entry.getKey());
            properties.add((String)entry.getValue());
        }
        ArrayList<String> output = new ArrayList<String>(this.output.size() * 2);
        for (ConversationCommand.Output entry : this.output) {
            output.add(String.valueOf(entry.type));
            output.add(entry.value);
        }
        ArrayList<Object> options = new ArrayList<Object>(this.options.size());
        for (Option entry : this.options) {
            options.add(entry.exportContents());
        }
        ArrayList<String> parameters = new ArrayList<String>(this.parameters.size() * 2);
        for (Map.Entry entry : this.parameters.entrySet()) {
            parameters.add((String)entry.getKey());
            parameters.add((String)entry.getValue());
        }
        return new Object[]{this.selectionName, this.resultName, this.filledResultValue, this.noInputResultValue, this.noMatchResultValue, properties.toArray(new String[properties.size()]), output.toArray(new String[output.size()]), options.toArray(), parameters.toArray(new String[parameters.size()])};
    }

    public void importContents(Object contents) {
        Object[] array = (Object[])contents;
        this.selectionName = (String)array[0];
        this.resultName = (String)array[1];
        this.filledResultValue = (String)array[2];
        this.noInputResultValue = (String)array[3];
        this.noMatchResultValue = (String)array[4];
        this.properties.clear();
        String[] properties = (String[])array[5];
        int i = 0;
        while (i < properties.length) {
            this.properties.put(properties[i], properties[i + 1]);
            i += 2;
        }
        this.output.clear();
        String[] output = (String[])array[6];
        int i2 = 0;
        while (i2 < output.length) {
            this.output.add(new ConversationCommand.Output(Integer.parseInt(output[i2]), output[i2 + 1]));
            i2 += 2;
        }
        this.parameters.clear();
        Object[] options = (Object[])array[7];
        int i3 = 0;
        while (i3 < options.length) {
            Option option = new Option();
            option.importContents(options[i3]);
            this.options.add(option);
            ++i3;
        }
        String[] parameters = (String[])array[8];
        int i4 = 0;
        while (i4 < parameters.length) {
            this.parameters.put(parameters[i4], parameters[i4 + 1]);
            i4 += 2;
        }
    }

    private static final class Option {
        String name;
        final List output = new ArrayList();
        final Map properties = new HashMap();
        ConversationCommand.Input input = null;

        Option() {
            this.name = null;
        }

        Option(String name) {
            this.name = name;
        }

        Object exportContents() {
            String[] stringArray;
            ArrayList<String> output = new ArrayList<String>(this.output.size() * 2);
            for (ConversationCommand.Output entry : this.output) {
                output.add(String.valueOf(entry.type));
                output.add(entry.value);
            }
            ArrayList<String> properties = new ArrayList<String>(this.properties.size() * 2);
            for (Map.Entry entry : this.properties.entrySet()) {
                properties.add((String)entry.getKey());
                properties.add((String)entry.getValue());
            }
            Object[] objectArray = new Object[4];
            objectArray[0] = this.name;
            objectArray[1] = output.toArray(new String[output.size()]);
            objectArray[2] = properties.toArray(new String[properties.size()]);
            if (this.input == null) {
                stringArray = null;
            } else {
                String[] stringArray2 = new String[2];
                stringArray2[0] = String.valueOf(this.input.type);
                stringArray = stringArray2;
                stringArray2[1] = this.input.value;
            }
            objectArray[3] = stringArray;
            return objectArray;
        }

        void importContents(Object contents) {
            Object[] array = (Object[])contents;
            this.name = (String)array[0];
            this.output.clear();
            String[] output = (String[])array[1];
            int i = 0;
            while (i < output.length) {
                this.output.add(new ConversationCommand.Output(Integer.parseInt(output[i]), output[i + 1]));
                i += 2;
            }
            String[] properties = (String[])array[2];
            int i2 = 0;
            while (i2 < properties.length) {
                this.properties.put(properties[i2], properties[i2 + 1]);
                i2 += 2;
            }
            String[] input = (String[])array[3];
            this.input = input == null ? null : new ConversationCommand.Input(Integer.parseInt(input[0]), input[1]);
        }
    }
}

