/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.framework.interactions.core.configurations;

import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.vtp.framework.core.IConfiguration;
import org.eclipse.vtp.framework.interactions.core.configurations.InputConfiguration;
import org.eclipse.vtp.framework.interactions.core.configurations.InteractionsConstants;
import org.eclipse.vtp.framework.interactions.core.configurations.OutputConfiguration;
import org.eclipse.vtp.framework.interactions.core.configurations.PropertyConfiguration;
import org.eclipse.vtp.framework.interactions.core.media.IContentFactory;
import org.eclipse.vtp.framework.interactions.core.media.IInputGrammarFactory;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class MediaConfiguration
implements IConfiguration,
InteractionsConstants {
    private final IContentFactory contentFactory;
    private final IInputGrammarFactory inputFactory;
    private final Map outputConfigurations = new LinkedHashMap();
    private final Map inputConfigurations = new LinkedHashMap();
    private final Map propertyConfigurations = new LinkedHashMap();

    public MediaConfiguration(IContentFactory contentFactory, IInputGrammarFactory inputFactory) {
        this.contentFactory = contentFactory;
        this.inputFactory = inputFactory;
    }

    public String[] getOutputConfigurationNames() {
        return this.outputConfigurations.keySet().toArray(new String[this.outputConfigurations.size()]);
    }

    public OutputConfiguration getOutputConfiguration(String name) {
        return (OutputConfiguration)this.outputConfigurations.get(name);
    }

    public void setOutputConfiguration(String name, OutputConfiguration configuration) {
        if (configuration == null) {
            this.outputConfigurations.remove(name);
        } else {
            this.outputConfigurations.put(name, configuration);
        }
    }

    public String[] getInputConfigurationNames() {
        return this.inputConfigurations.keySet().toArray(new String[this.inputConfigurations.size()]);
    }

    public InputConfiguration getInputConfiguration(String name) {
        return (InputConfiguration)this.inputConfigurations.get(name);
    }

    public void setInputConfiguration(String name, InputConfiguration configuration) {
        if (configuration == null) {
            this.inputConfigurations.remove(name);
        } else {
            this.inputConfigurations.put(name, configuration);
        }
    }

    public String[] getPropertyConfigurationNames() {
        return this.propertyConfigurations.keySet().toArray(new String[this.propertyConfigurations.size()]);
    }

    public PropertyConfiguration getPropertyConfiguration(String name) {
        return (PropertyConfiguration)this.propertyConfigurations.get(name);
    }

    public void setPropertyConfiguration(String name, PropertyConfiguration configuration) {
        if (configuration == null) {
            this.propertyConfigurations.remove(name);
        } else {
            this.propertyConfigurations.put(name, configuration);
        }
    }

    public void load(Element configurationElement) {
        InteractionsConstants configuration;
        String name;
        Element element;
        this.outputConfigurations.clear();
        this.inputConfigurations.clear();
        this.propertyConfigurations.clear();
        NodeList elements = configurationElement.getElementsByTagNameNS("http://eclipse.org/vtp/xml/framework/interactions/core/configurations", "output");
        int i = 0;
        while (i < elements.getLength()) {
            element = (Element)elements.item(i);
            name = element.getAttribute("name");
            configuration = new OutputConfiguration(this.contentFactory);
            ((OutputConfiguration)configuration).load(element);
            this.outputConfigurations.put(name, configuration);
            ++i;
        }
        elements = configurationElement.getElementsByTagNameNS("http://eclipse.org/vtp/xml/framework/interactions/core/configurations", "input");
        i = 0;
        while (i < elements.getLength()) {
            element = (Element)elements.item(i);
            name = element.getAttribute("name");
            configuration = new InputConfiguration(this.inputFactory);
            ((InputConfiguration)configuration).load(element);
            this.inputConfigurations.put(name, configuration);
            ++i;
        }
        elements = configurationElement.getElementsByTagNameNS("http://eclipse.org/vtp/xml/framework/interactions/core/configurations", "property");
        i = 0;
        while (i < elements.getLength()) {
            element = (Element)elements.item(i);
            name = element.getAttribute("name");
            configuration = new PropertyConfiguration();
            ((PropertyConfiguration)configuration).load(element);
            this.propertyConfigurations.put(name, configuration);
            ++i;
        }
    }

    public void save(Element configurationElement) {
        Element element;
        String outputName = "output";
        String inputName = "input";
        String propertyName = "property";
        String prefix = configurationElement.getPrefix();
        if (prefix != null && prefix.length() > 0) {
            outputName = String.valueOf(prefix) + ":" + outputName;
            inputName = String.valueOf(prefix) + ":" + inputName;
            propertyName = String.valueOf(prefix) + ":" + propertyName;
        }
        for (Map.Entry entry : this.outputConfigurations.entrySet()) {
            element = configurationElement.getOwnerDocument().createElementNS("http://eclipse.org/vtp/xml/framework/interactions/core/configurations", outputName);
            ((IConfiguration)entry.getValue()).save(element);
            element.setAttribute("name", (String)entry.getKey());
            configurationElement.appendChild(element);
        }
        for (Map.Entry entry : this.inputConfigurations.entrySet()) {
            element = configurationElement.getOwnerDocument().createElementNS("http://eclipse.org/vtp/xml/framework/interactions/core/configurations", inputName);
            ((IConfiguration)entry.getValue()).save(element);
            element.setAttribute("name", (String)entry.getKey());
            configurationElement.appendChild(element);
        }
        for (Map.Entry entry : this.propertyConfigurations.entrySet()) {
            element = configurationElement.getOwnerDocument().createElementNS("http://eclipse.org/vtp/xml/framework/interactions/core/configurations", propertyName);
            ((IConfiguration)entry.getValue()).save(element);
            element.setAttribute("name", (String)entry.getKey());
            configurationElement.appendChild(element);
        }
    }
}

