/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.framework.interactions.core.configurations;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.vtp.framework.core.IConfiguration;
import org.eclipse.vtp.framework.interactions.core.configurations.InteractionsConstants;
import org.eclipse.vtp.framework.interactions.core.configurations.MetaDataItemConfiguration;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class MetaDataConfiguration
implements IConfiguration,
InteractionsConstants {
    private final Map items = new HashMap();

    public MetaDataItemConfiguration[] getItem(String key) {
        return (MetaDataItemConfiguration[])this.items.get(key);
    }

    public void setItem(String key, MetaDataItemConfiguration[] items) {
        if (items == null) {
            this.items.remove(key);
        } else {
            this.items.put(key, items);
        }
    }

    public void load(Element configurationElement) {
        this.items.clear();
        NodeList setElements = configurationElement.getElementsByTagNameNS("http://eclipse.org/vtp/xml/framework/interactions/core/configurations", "meta-data-set");
        int i = 0;
        while (i < setElements.getLength()) {
            Element setElement = (Element)setElements.item(i);
            String key = setElement.getAttribute("key");
            NodeList itemElements = setElement.getElementsByTagNameNS("http://eclipse.org/vtp/xml/framework/interactions/core/configurations", "meta-data-item");
            MetaDataItemConfiguration[] metaData = new MetaDataItemConfiguration[itemElements.getLength()];
            int j = 0;
            while (j < itemElements.getLength()) {
                MetaDataItemConfiguration item = new MetaDataItemConfiguration();
                item.load((Element)itemElements.item(j));
                metaData[j] = item;
                ++j;
            }
            this.items.put(key, metaData);
            ++i;
        }
    }

    public void save(Element configurationElement) {
        String metaDataSetName = "meta-data-set";
        String metaDataItemName = "meta-data-item";
        String prefix = configurationElement.getPrefix();
        if (prefix != null && prefix.length() > 0) {
            metaDataSetName = String.valueOf(prefix) + ":" + metaDataSetName;
            metaDataItemName = String.valueOf(prefix) + ":" + metaDataItemName;
        }
        for (Map.Entry entry : this.items.entrySet()) {
            Element setElement = configurationElement.getOwnerDocument().createElementNS("http://eclipse.org/vtp/xml/framework/interactions/core/configurations", metaDataSetName);
            MetaDataItemConfiguration[] metaData = (MetaDataItemConfiguration[])entry.getValue();
            int j = 0;
            while (j < metaData.length) {
                Element itemElement = configurationElement.getOwnerDocument().createElementNS("http://eclipse.org/vtp/xml/framework/interactions/core/configurations", metaDataItemName);
                metaData[j].save(itemElement);
                setElement.appendChild(itemElement);
                ++j;
            }
            setElement.setAttribute("key", (String)entry.getKey());
            configurationElement.appendChild(setElement);
        }
    }
}

