/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.framework.interactions.core.configurations;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.vtp.framework.core.IConfiguration;
import org.eclipse.vtp.framework.interactions.core.configurations.InteractionsConstants;
import org.eclipse.vtp.framework.interactions.core.media.Content;
import org.eclipse.vtp.framework.interactions.core.media.IContentFactory;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class OutputConfiguration
implements IConfiguration,
InteractionsConstants {
    private final IContentFactory contentFactory;
    private final Map items = new HashMap();

    public OutputConfiguration(IContentFactory contentFactory) {
        this.contentFactory = contentFactory;
    }

    public Content[] getItem(String brandName, String interactionTypeID, String languageID) {
        return (Content[])this.items.get(String.valueOf(brandName) + interactionTypeID + languageID);
    }

    public void setItem(String brandName, String interactionTypeID, String languageID, Content[] item) {
        this.setItem(String.valueOf(brandName) + interactionTypeID + languageID, item);
    }

    public void setItem(String key, Content[] item) {
        if (item == null) {
            this.items.remove(key);
        } else {
            this.items.put(key, item);
        }
    }

    public void load(Element configurationElement) {
        this.items.clear();
        NodeList outputItemElements = configurationElement.getElementsByTagNameNS("http://eclipse.org/vtp/xml/framework/interactions/core/configurations", "output-item");
        int i = 0;
        while (i < outputItemElements.getLength()) {
            Element outputItemElement = (Element)outputItemElements.item(i);
            String key = outputItemElement.getAttribute("key");
            NodeList contentElements = outputItemElement.getChildNodes();
            ArrayList<Content> content = new ArrayList<Content>(contentElements.getLength());
            int j = 0;
            while (j < contentElements.getLength()) {
                if (contentElements.item(j) instanceof Element) {
                    content.add(this.contentFactory.loadContent((Element)contentElements.item(j)));
                }
                ++j;
            }
            this.items.put(key, content.toArray(new Content[content.size()]));
            ++i;
        }
    }

    public void save(Element configurationElement) {
        String outputItemName = "output-item";
        String prefix = configurationElement.getPrefix();
        if (prefix != null && prefix.length() > 0) {
            outputItemName = String.valueOf(prefix) + ":" + outputItemName;
        }
        for (Map.Entry entry : this.items.entrySet()) {
            Element outputItemElement = configurationElement.getOwnerDocument().createElementNS("http://eclipse.org/vtp/xml/framework/interactions/core/configurations", outputItemName);
            Content[] content = (Content[])entry.getValue();
            int j = 0;
            while (j < content.length) {
                content[j].store(outputItemElement);
                ++j;
            }
            outputItemElement.setAttribute("key", (String)entry.getKey());
            configurationElement.appendChild(outputItemElement);
        }
    }
}

