/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.framework.interactions.core.configurations;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.vtp.framework.core.IConfiguration;
import org.eclipse.vtp.framework.interactions.core.configurations.InteractionsConstants;
import org.eclipse.vtp.framework.util.XMLUtilities;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class PropertyConfiguration
implements IConfiguration,
InteractionsConstants {
    private final Map items = new HashMap();

    public String getItem(String brandName, String interactionTypeID) {
        return (String)this.items.get(String.valueOf(brandName) + interactionTypeID);
    }

    public void setItem(String brandName, String interactionTypeID, String item) {
        this.setItem(String.valueOf(brandName) + interactionTypeID, item);
    }

    public void setItem(String key, String item) {
        if (item == null) {
            this.items.remove(key);
        } else {
            this.items.put(key, item);
        }
    }

    public void load(Element configurationElement) {
        this.items.clear();
        NodeList propertyItemElements = configurationElement.getElementsByTagNameNS("http://eclipse.org/vtp/xml/framework/interactions/core/configurations", "property-item");
        int i = 0;
        while (i < propertyItemElements.getLength()) {
            Element propertyItemElement = (Element)propertyItemElements.item(i);
            String key = propertyItemElement.getAttribute("key");
            try {
                this.items.put(key, XMLUtilities.getElementTextData((Element)propertyItemElement, (boolean)true));
            }
            catch (Exception e) {
                throw new IllegalArgumentException(e);
            }
            ++i;
        }
    }

    public void save(Element configurationElement) {
        String propertyItemName = "property-item";
        String prefix = configurationElement.getPrefix();
        if (prefix != null && prefix.length() > 0) {
            propertyItemName = String.valueOf(prefix) + ":" + propertyItemName;
        }
        for (Map.Entry entry : this.items.entrySet()) {
            Element element = configurationElement.getOwnerDocument().createElementNS("http://eclipse.org/vtp/xml/framework/interactions/core/configurations", propertyItemName);
            element.appendChild(configurationElement.getOwnerDocument().createTextNode((String)entry.getValue()));
            element.setAttribute("key", (String)entry.getKey());
            configurationElement.appendChild(element);
        }
    }
}

