/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.framework.interactions.core.configurations;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.eclipse.vtp.framework.core.IConfiguration;
import org.eclipse.vtp.framework.interactions.core.configurations.InteractionsConstants;
import org.eclipse.vtp.framework.interactions.core.configurations.MediaConfiguration;
import org.eclipse.vtp.framework.interactions.core.configurations.SelectionChoiceConfiguration;
import org.eclipse.vtp.framework.interactions.core.media.IContentFactory;
import org.eclipse.vtp.framework.interactions.core.media.IInputGrammarFactory;
import org.eclipse.vtp.framework.util.XMLUtilities;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class SelectionRequestConfiguration
implements IConfiguration,
InteractionsConstants {
    private final IContentFactory contentFactory;
    private final IInputGrammarFactory inputFactory;
    private String outputName = "";
    private String dataName = "";
    private MediaConfiguration mediaConfiguration = null;
    private final Set choices = new HashSet();
    private final Map brandedChoices = new HashMap();

    public SelectionRequestConfiguration(IContentFactory contentFactory, IInputGrammarFactory inputFactory) {
        this.contentFactory = contentFactory;
        this.inputFactory = inputFactory;
    }

    public String getOutputName() {
        return this.outputName;
    }

    public void setOutputName(String outputName) {
        this.outputName = outputName == null ? "" : outputName;
    }

    public String getDataName() {
        return this.dataName;
    }

    public void setDataName(String dataName) {
        this.dataName = dataName == null ? "" : dataName;
    }

    public MediaConfiguration getMediaConfiguration() {
        return this.mediaConfiguration;
    }

    public void setMediaConfiguration(MediaConfiguration mediaConfiguration) {
        this.mediaConfiguration = mediaConfiguration;
    }

    public SelectionChoiceConfiguration[] getChoices() {
        return this.choices.toArray(new SelectionChoiceConfiguration[this.choices.size()]);
    }

    public void addChoice(SelectionChoiceConfiguration choice) {
        if (choice != null) {
            this.choices.add(choice);
        }
    }

    public void removeChoice(SelectionChoiceConfiguration choice) {
        if (choice != null) {
            this.choices.remove(choice);
        }
    }

    public String[] getBrandedChoices(String brandName) {
        return (String[])this.brandedChoices.get(brandName);
    }

    public void setBrandedChoices(String brandName, String[] choiceNames) {
        if (brandName == null) {
            return;
        }
        if (choiceNames == null) {
            this.brandedChoices.remove(brandName);
        } else {
            this.brandedChoices.put(brandName, choiceNames);
        }
    }

    public void load(Element configurationElement) {
        this.outputName = configurationElement.getAttribute("output-name");
        this.dataName = configurationElement.getAttribute("data-name");
        NodeList elements = configurationElement.getElementsByTagNameNS("http://eclipse.org/vtp/xml/framework/interactions/core/configurations", "media");
        if (elements.getLength() == 0) {
            this.mediaConfiguration = null;
        } else {
            this.mediaConfiguration = new MediaConfiguration(this.contentFactory, this.inputFactory);
            this.mediaConfiguration.load((Element)elements.item(0));
        }
        this.choices.clear();
        elements = configurationElement.getElementsByTagNameNS("http://eclipse.org/vtp/xml/framework/interactions/core/configurations", "choice");
        int i = 0;
        while (i < elements.getLength()) {
            SelectionChoiceConfiguration choice = new SelectionChoiceConfiguration(this.contentFactory, this.inputFactory);
            choice.load((Element)elements.item(i));
            this.choices.add(choice);
            ++i;
        }
        this.brandedChoices.clear();
        ArrayList<String> choiceNames = new ArrayList<String>();
        elements = configurationElement.getElementsByTagNameNS("http://eclipse.org/vtp/xml/framework/interactions/core/configurations", "choices");
        int i2 = 0;
        while (i2 < elements.getLength()) {
            Element element = (Element)elements.item(i2);
            String content = null;
            try {
                content = XMLUtilities.getElementTextData((Element)element, (boolean)true);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (content != null) {
                StringTokenizer st = new StringTokenizer(content, "\r\n");
                while (st.hasMoreTokens()) {
                    choiceNames.add(st.nextToken().trim());
                }
            }
            this.brandedChoices.put(element.getAttribute("key"), choiceNames.toArray(new String[choiceNames.size()]));
            choiceNames.clear();
            ++i2;
        }
    }

    public void save(Element configurationElement) {
        Element element;
        configurationElement.setAttribute("output-name", this.outputName);
        configurationElement.setAttribute("data-name", this.dataName);
        String mediaName = "media";
        String choiceName = "choice";
        String choicesName = "choices";
        String prefix = configurationElement.getPrefix();
        if (prefix != null && prefix.length() > 0) {
            mediaName = String.valueOf(prefix) + ":" + mediaName;
            choiceName = String.valueOf(prefix) + ":" + choiceName;
            choicesName = String.valueOf(prefix) + ":" + choicesName;
        }
        if (this.mediaConfiguration != null) {
            Element element2 = configurationElement.getOwnerDocument().createElementNS("http://eclipse.org/vtp/xml/framework/interactions/core/configurations", mediaName);
            this.mediaConfiguration.save(element2);
            configurationElement.appendChild(element2);
        }
        for (SelectionChoiceConfiguration selectionChoiceConfiguration : this.choices) {
            element = configurationElement.getOwnerDocument().createElementNS("http://eclipse.org/vtp/xml/framework/interactions/core/configurations", choiceName);
            selectionChoiceConfiguration.save(element);
            configurationElement.appendChild(element);
        }
        for (Map.Entry entry : this.brandedChoices.entrySet()) {
            element = configurationElement.getOwnerDocument().createElementNS("http://eclipse.org/vtp/xml/framework/interactions/core/configurations", choicesName);
            element.setAttribute("key", (String)entry.getKey());
            StringBuffer buffer = new StringBuffer();
            String[] choiceNames = (String[])entry.getValue();
            int j = 0;
            while (j < choiceNames.length) {
                if (choiceNames[j] != null) {
                    if (buffer.length() > 0) {
                        buffer.append('\r').append('\n');
                    }
                    buffer.append(choiceNames[j]);
                }
                ++j;
            }
            element.appendChild(configurationElement.getOwnerDocument().createTextNode(buffer.toString()));
            configurationElement.appendChild(element);
        }
    }
}

