/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.framework.interactions.core.configurations;

import org.eclipse.vtp.framework.core.IConfiguration;
import org.eclipse.vtp.framework.interactions.core.configurations.InteractionsConstants;
import org.eclipse.vtp.framework.interactions.core.media.Content;
import org.eclipse.vtp.framework.interactions.core.media.IContentFactory;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class SharedContentConfiguration
implements IConfiguration,
InteractionsConstants {
    private final IContentFactory contentFactory;
    private String name = "";
    private Content content = null;

    public SharedContentConfiguration(IContentFactory contentFactory) {
        this.contentFactory = contentFactory;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name == null ? "" : name;
    }

    public Content getContent() {
        return this.content;
    }

    public void setContent(Content content) {
        this.content = content;
    }

    public void load(Element configurationElement) {
        this.name = configurationElement.getAttribute("name");
        this.content = null;
        NodeList list = configurationElement.getChildNodes();
        int i = 0;
        while (this.content == null && i < list.getLength()) {
            if (list.item(i) instanceof Element) {
                this.content = this.contentFactory.loadContent((Element)list.item(i));
            }
            ++i;
        }
    }

    public void save(Element configurationElement) {
        configurationElement.setAttribute("name", this.name);
        if (this.content != null) {
            this.content.store(configurationElement);
        }
    }
}

