/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.framework.interactions.core.media;

import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.vtp.framework.interactions.core.media.Content;
import org.eclipse.vtp.framework.interactions.core.media.FormattableContent;
import org.eclipse.vtp.framework.interactions.core.media.IFormatter;
import org.eclipse.vtp.framework.interactions.core.media.IMediaProvider;
import org.eclipse.vtp.framework.interactions.core.media.TextContent;
import org.w3c.dom.Element;

public class DateContent
extends FormattableContent {
    public static final String ELEMENT_NAME = "date-content";

    public DateContent() {
    }

    public DateContent(Element element) {
        super(element);
    }

    public String getContentTypeName() {
        return "DATE";
    }

    public List format(IFormatter formatter, IMediaProvider mediaProvider) {
        LinkedList<TextContent> ret = new LinkedList<TextContent>();
        if (this.getValueType() != 2) {
            Date date = null;
            try {
                date = new Date(Date.parse(this.getValue()));
            }
            catch (RuntimeException e) {
                e.printStackTrace();
            }
            if (date != null) {
                ret.addAll(formatter.formatDate(date, mediaProvider.getFormatManager().getFormat(this, this.getFormatName()), mediaProvider.getResourceManager()));
            } else {
                TextContent textContent = new TextContent();
                if (this.getValueType() == 1) {
                    textContent.setStaticText(this.getValue());
                } else {
                    textContent.setVariableText(this.getValue());
                }
                ret.add(textContent);
            }
        }
        return ret;
    }

    public Element store(Element element) {
        Element thisElement = element.getOwnerDocument().createElementNS("http://www.eclipse.org/vtp/media/content", ELEMENT_NAME);
        element.appendChild(thisElement);
        super.storeBaseInfo(thisElement);
        return thisElement;
    }

    public String getContentType() {
        return "org.eclipse.vtp.framework.interactions.core.media.content.date";
    }

    public Content createCopy() {
        return this.configureCopy(new DateContent());
    }
}

