/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.framework.interactions.core.media;

import org.eclipse.vtp.framework.interactions.core.media.IDataSet;
import org.eclipse.vtp.framework.interactions.core.media.InputGrammar;
import org.eclipse.vtp.framework.util.XMLUtilities;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public abstract class FileInputGrammar
extends InputGrammar {
    public static final int STATIC_PATH = 1;
    public static final int VARIABLE_PATH = 2;
    private int dataType = 1;
    private String data = "";

    public FileInputGrammar() {
    }

    public FileInputGrammar(Element element) {
        String dataTypeString = element.getAttribute("dataType");
        if (dataTypeString.equals("")) {
            dataTypeString = "1";
        }
        this.dataType = Integer.parseInt(dataTypeString);
        try {
            this.data = XMLUtilities.getElementTextData((Element)element, (boolean)true);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void setStaticPath(String path) {
        this.dataType = 1;
        this.data = path;
    }

    public void setVariablePath(String variable) {
        this.dataType = 2;
        this.data = variable;
    }

    public String getPath() {
        return this.data;
    }

    public int getPathType() {
        return this.dataType;
    }

    public boolean isDataAware() {
        return this.dataType == 2;
    }

    public InputGrammar captureData(IDataSet dataSet) {
        if (this.dataType == 1) {
            return this;
        }
        FileInputGrammar clone = null;
        try {
            clone = (FileInputGrammar)this.getClass().newInstance();
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        clone.setStaticPath(dataSet.getData(this.data).toString());
        return clone;
    }

    protected void storeBaseInfo(Element thisElement) {
        thisElement.setAttribute("dataType", Integer.toString(this.dataType));
        Text dataNode = thisElement.getOwnerDocument().createTextNode(this.data);
        thisElement.appendChild(dataNode);
    }

    public String getFileTypeName() {
        return "FILE";
    }
}

