/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.framework.interactions.core.media;

import java.util.List;
import org.eclipse.vtp.framework.interactions.core.media.Content;
import org.eclipse.vtp.framework.interactions.core.media.IDataSet;
import org.eclipse.vtp.framework.interactions.core.media.IFormatter;
import org.eclipse.vtp.framework.interactions.core.media.IMediaProvider;
import org.eclipse.vtp.framework.util.XMLUtilities;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public abstract class FormattableContent
extends Content {
    public static final int STATIC_VALUE = 1;
    public static final int VARIABLE_VALUE = 2;
    private int dataType = 1;
    private String data = "";
    private String formatName = "";

    public FormattableContent() {
    }

    public FormattableContent(Element element) {
        String dataTypeString = element.getAttribute("dataType");
        this.dataType = dataTypeString.equals("") ? 1 : ("static".equalsIgnoreCase(dataTypeString) ? 1 : ("variable".equalsIgnoreCase(dataTypeString) ? 2 : Integer.parseInt(dataTypeString)));
        try {
            this.data = XMLUtilities.getElementTextData((Element)element, (boolean)true);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.formatName = element.getAttribute("format");
    }

    public abstract String getContentTypeName();

    public abstract List format(IFormatter var1, IMediaProvider var2);

    public boolean isDataAware() {
        return this.dataType == 2;
    }

    public Content captureData(IDataSet dataSet) {
        if (this.dataType == 1) {
            return this;
        }
        FormattableContent copy = (FormattableContent)this.createCopy();
        copy.setStaticValue(dataSet.getData(this.data).toString());
        return copy;
    }

    public void setStaticValue(String value) {
        this.dataType = 1;
        this.data = value;
    }

    public void setVariableValue(String variableName) {
        this.dataType = 2;
        this.data = variableName;
    }

    public int getValueType() {
        return this.dataType;
    }

    public String getValue() {
        return this.data;
    }

    public String getFormatName() {
        return this.formatName;
    }

    public void setFormatName(String formatName) {
        this.formatName = formatName == null ? "" : formatName;
    }

    protected void storeBaseInfo(Element thisElement) {
        thisElement.setAttribute("dataType", this.dataType == 1 ? "static" : "variable");
        thisElement.setAttribute("format", this.formatName);
        Text dataNode = thisElement.getOwnerDocument().createTextNode(this.data);
        thisElement.appendChild(dataNode);
    }

    protected FormattableContent configureCopy(FormattableContent copy) {
        copy.dataType = this.dataType;
        copy.data = this.data;
        copy.formatName = this.formatName;
        return copy;
    }
}

