/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.framework.interactions.core.media;

import java.util.LinkedList;
import java.util.List;
import org.eclipse.vtp.framework.interactions.core.media.Content;
import org.eclipse.vtp.framework.interactions.core.media.FormattableContent;
import org.eclipse.vtp.framework.interactions.core.media.IDataSet;
import org.eclipse.vtp.framework.interactions.core.media.IMediaProvider;

public class MediaRenderingManager {
    public static final int CAPTURE = 1;
    public static final int RESOLVE = 2;
    public static final int FORMAT = 4;
    public static final int COMPLETE = 7;
    private IMediaProvider mediaProvider;
    private IDataSet dataSet;

    public MediaRenderingManager(IMediaProvider mediaProvider, IDataSet dataSet) {
        this.mediaProvider = mediaProvider;
        this.dataSet = dataSet;
    }

    public List renderContent(int renderingFlags, List contentSet) {
        LinkedList<Content> inputList = contentSet;
        LinkedList<Content> renderedList = contentSet;
        if ((renderingFlags & 1) > 0) {
            renderedList = new LinkedList<Content>();
            for (Content c : inputList) {
                if (c.isDataAware()) {
                    renderedList.add(c.captureData(this.dataSet));
                    continue;
                }
                renderedList.add(c);
            }
            inputList = renderedList;
        }
        if ((renderingFlags & 2) > 0) {
            renderedList = new LinkedList();
            for (Content c : inputList) {
                if (c.isResolvable()) {
                    renderedList.addAll(c.resolve(this.mediaProvider));
                    continue;
                }
                renderedList.add(c);
            }
            inputList = renderedList;
        }
        if ((renderingFlags & 4) > 0) {
            renderedList = new LinkedList();
            for (Content c : inputList) {
                if (c instanceof FormattableContent) {
                    renderedList.addAll(((FormattableContent)c).format(this.mediaProvider.getFormatter(), this.mediaProvider));
                    continue;
                }
                renderedList.add(c);
            }
        }
        return renderedList;
    }
}

