/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.framework.interactions.core.media;

import java.math.BigDecimal;
import java.util.Currency;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.vtp.framework.interactions.core.media.Content;
import org.eclipse.vtp.framework.interactions.core.media.FormattableContent;
import org.eclipse.vtp.framework.interactions.core.media.IFormatter;
import org.eclipse.vtp.framework.interactions.core.media.IMediaProvider;
import org.w3c.dom.Element;

public class MoneyContent
extends FormattableContent {
    public static final String ELEMENT_NAME = "money-content";

    public MoneyContent() {
    }

    public MoneyContent(Element element) {
        super(element);
    }

    public String getContentTypeName() {
        return "MONEY";
    }

    public List format(IFormatter formatter, IMediaProvider mediaProvider) {
        LinkedList ret = new LinkedList();
        if (this.getValueType() != 2) {
            ret.addAll(formatter.formatMoney(new BigDecimal(this.getValue()), Currency.getInstance("USD"), mediaProvider.getFormatManager().getFormat(this, this.getFormatName()), mediaProvider.getResourceManager()));
        }
        return ret;
    }

    public Element store(Element element) {
        Element thisElement = element.getOwnerDocument().createElementNS("http://www.eclipse.org/vtp/media/content", ELEMENT_NAME);
        element.appendChild(thisElement);
        super.storeBaseInfo(thisElement);
        return thisElement;
    }

    public String getContentType() {
        return "org.eclipse.vtp.framework.interactions.core.media.content.money";
    }

    public Content createCopy() {
        return this.configureCopy(new MoneyContent());
    }
}

