/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.framework.interactions.core.media;

import java.util.LinkedList;
import java.util.List;
import org.eclipse.vtp.framework.interactions.core.media.Content;
import org.eclipse.vtp.framework.interactions.core.media.IDataSet;
import org.eclipse.vtp.framework.interactions.core.media.IMediaProvider;
import org.eclipse.vtp.framework.interactions.core.media.ISharedContentProvider;
import org.w3c.dom.Element;

public class ReferencedContent
extends Content {
    public static final int STATIC_REF = 1;
    public static final int VARIABLE_REF = 2;
    public static final String ELEMENT_NAME = "referenced-content";
    private int referenceType = 1;
    private String referencedName = "";

    public ReferencedContent() {
    }

    public ReferencedContent(Element element) {
        String referenceTypeString = element.getAttribute("referenceType");
        this.referenceType = referenceTypeString.equals("") ? 1 : ("static".equalsIgnoreCase(referenceTypeString) ? 1 : ("variable".equalsIgnoreCase(referenceTypeString) ? 2 : Integer.parseInt(referenceTypeString)));
        this.referencedName = element.getAttribute("referencedName");
    }

    public String getReferencedName() {
        return this.referencedName;
    }

    public int getReferenceType() {
        return this.referenceType;
    }

    public void setStaticReferencedName(String name) {
        this.referenceType = 1;
        this.referencedName = name;
    }

    public void setVariableReferencedName(String name) {
        this.referenceType = 2;
        this.referencedName = name;
    }

    public Element store(Element element) {
        Element thisElement = element.getOwnerDocument().createElementNS("http://www.eclipse.org/vtp/media/content", ELEMENT_NAME);
        element.appendChild(thisElement);
        thisElement.setAttribute("referenceType", this.referenceType == 1 ? "static" : "variable");
        thisElement.setAttribute("referencedName", this.referencedName);
        return thisElement;
    }

    public String getContentType() {
        return "org.eclipse.vtp.framework.interactions.core.media.content.referenced";
    }

    public boolean isDataAware() {
        return this.referenceType == 2;
    }

    public Content captureData(IDataSet dataSet) {
        if (this.referenceType == 1) {
            return this;
        }
        ReferencedContent clone = new ReferencedContent();
        clone.setStaticReferencedName(dataSet.getData(this.referencedName).toString());
        return clone;
    }

    public boolean isResolvable() {
        return true;
    }

    public List resolve(IMediaProvider mediaProvider) {
        ISharedContentProvider scp;
        Content refContent;
        LinkedList<Content> ret = new LinkedList<Content>();
        if (this.referenceType == 1 && mediaProvider.hasSharedContent() && (refContent = (scp = mediaProvider.getSharedContentProvider()).getSharedContent(this.referencedName)) != null) {
            if (refContent.isResolvable()) {
                ret.addAll(refContent.resolve(mediaProvider));
            } else {
                ret.add(refContent);
            }
        }
        return ret;
    }

    public Content createCopy() {
        ReferencedContent copy = new ReferencedContent();
        copy.referenceType = this.referenceType;
        copy.referencedName = this.referencedName;
        return copy;
    }
}

