/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.framework.interactions.core.media;

import org.eclipse.vtp.framework.interactions.core.media.Content;
import org.eclipse.vtp.framework.interactions.core.media.IDataSet;
import org.eclipse.vtp.framework.util.XMLUtilities;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class TextContent
extends Content {
    public static final int STATIC_TEXT = 1;
    public static final int VARIABLE_TEXT = 2;
    public static final String ELEMENT_NAME = "text-content";
    private int dataType = 1;
    private String data = "";

    public TextContent() {
    }

    public TextContent(Element element) {
        String dataTypeString = element.getAttribute("dataType");
        this.dataType = dataTypeString.equals("") ? 1 : ("static".equalsIgnoreCase(dataTypeString) ? 1 : ("variable".equalsIgnoreCase(dataTypeString) ? 2 : Integer.parseInt(dataTypeString)));
        try {
            this.data = XMLUtilities.getElementTextData((Element)element, (boolean)true);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void setStaticText(String text) {
        this.dataType = 1;
        this.data = text;
    }

    public void setVariableText(String variableName) {
        this.dataType = 2;
        this.data = variableName;
    }

    public int getTextType() {
        return this.dataType;
    }

    public String getText() {
        return this.data;
    }

    public Element store(Element element) {
        Element thisElement = element.getOwnerDocument().createElementNS("http://www.eclipse.org/vtp/media/content", ELEMENT_NAME);
        element.appendChild(thisElement);
        thisElement.setAttribute("dataType", this.dataType == 1 ? "static" : "variable");
        Text dataNode = thisElement.getOwnerDocument().createTextNode(this.data);
        thisElement.appendChild(dataNode);
        return thisElement;
    }

    public String getContentType() {
        return "org.eclipse.vtp.framework.interactions.core.media.content.text";
    }

    public boolean isDataAware() {
        return this.dataType == 2;
    }

    public Content captureData(IDataSet dataSet) {
        if (this.dataType == 1) {
            return this;
        }
        TextContent clone = new TextContent();
        clone.setStaticText(dataSet.getData(this.data).toString());
        return clone;
    }

    public Content createCopy() {
        TextContent copy = new TextContent();
        copy.dataType = this.dataType;
        copy.data = this.data;
        return copy;
    }
}

