/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.framework.interactions.core.services;

import java.lang.reflect.Constructor;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.vtp.framework.interactions.core.media.Content;
import org.eclipse.vtp.framework.interactions.core.media.IContentFactory;
import org.eclipse.vtp.framework.interactions.core.media.IContentType;
import org.eclipse.vtp.framework.interactions.core.media.IContentTypeRegistry;
import org.osgi.framework.Bundle;
import org.w3c.dom.Element;

public class ContentManager
implements IContentTypeRegistry,
IContentFactory {
    private final Map contentTypes;
    private final Map contentTypeIndex;

    public ContentManager(IExtensionRegistry registry) {
        IExtensionPoint point = registry.getExtensionPoint("org.eclipse.vtp.framework.interactions.core.contenttypes");
        IExtension[] extensions = point.getExtensions();
        HashMap<String, ContentType> contentTypes = new HashMap<String, ContentType>(extensions.length);
        HashMap<String, ContentType> contentTypeIndex = new HashMap<String, ContentType>(extensions.length);
        int i = 0;
        while (i < extensions.length) {
            Bundle bundle = Platform.getBundle((String)extensions[i].getContributor().getName());
            IConfigurationElement[] elements = extensions[i].getConfigurationElements();
            int j = 0;
            while (j < elements.length) {
                try {
                    ContentType contentType = new ContentType(elements[j].getAttribute("id"), elements[j].getAttribute("class"), bundle.loadClass(elements[j].getAttribute("class")));
                    contentTypes.put(contentType.getId(), contentType);
                    contentTypeIndex.put(String.valueOf(elements[j].getAttribute("element-name")) + elements[j].getAttribute("element-uri"), contentType);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                ++j;
            }
            ++i;
        }
        this.contentTypes = Collections.unmodifiableMap(contentTypes);
        this.contentTypeIndex = Collections.unmodifiableMap(contentTypeIndex);
    }

    public String[] getContentTypeIDs() {
        return this.contentTypes.keySet().toArray(new String[this.contentTypes.size()]);
    }

    public IContentType getContentType(String contentTypeID) {
        return (IContentType)this.contentTypes.get(contentTypeID);
    }

    public Content loadContent(Element configuration) {
        if (configuration == null) {
            return null;
        }
        ContentType contentType = (ContentType)this.contentTypeIndex.get(String.valueOf(configuration.getLocalName()) + configuration.getNamespaceURI());
        if (contentType == null) {
            return null;
        }
        return contentType.newInstance(configuration);
    }

    private final class ContentType
    implements IContentType {
        private final String id;
        private final String name;
        private final Constructor constructor;

        ContentType(String id, String name, Class contentClass) {
            this.id = id;
            Constructor constructor = null;
            this.name = name;
            try {
                constructor = contentClass.getConstructor(IContentFactory.class, Element.class);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                try {
                    constructor = contentClass.getConstructor(Element.class);
                }
                catch (NoSuchMethodException ex) {
                    throw new IllegalStateException(ex);
                }
            }
            this.constructor = constructor;
        }

        Content newInstance(Element configuration) {
            try {
                if (this.constructor.getParameterTypes().length == 1) {
                    return (Content)this.constructor.newInstance(configuration);
                }
                return (Content)this.constructor.newInstance(ContentManager.this, configuration);
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
        }

        public String getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }
    }
}

