/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.framework.interactions.core.services;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.vtp.framework.common.IBrand;
import org.eclipse.vtp.framework.common.IBrandSelection;
import org.eclipse.vtp.framework.common.IDataObject;
import org.eclipse.vtp.framework.common.IScriptingEngine;
import org.eclipse.vtp.framework.common.IScriptingService;
import org.eclipse.vtp.framework.common.IVariableRegistry;
import org.eclipse.vtp.framework.interactions.core.IInteractionTypeSelection;
import org.eclipse.vtp.framework.interactions.core.ILanguageSelection;
import org.eclipse.vtp.framework.interactions.core.commands.BridgeMessageCommand;
import org.eclipse.vtp.framework.interactions.core.commands.ConversationCommand;
import org.eclipse.vtp.framework.interactions.core.commands.DataRequestCommand;
import org.eclipse.vtp.framework.interactions.core.commands.EndMessageCommand;
import org.eclipse.vtp.framework.interactions.core.commands.ExternalReferenceCommand;
import org.eclipse.vtp.framework.interactions.core.commands.FinalCommand;
import org.eclipse.vtp.framework.interactions.core.commands.InitialCommand;
import org.eclipse.vtp.framework.interactions.core.commands.InputRequestCommand;
import org.eclipse.vtp.framework.interactions.core.commands.MetaDataMessageCommand;
import org.eclipse.vtp.framework.interactions.core.commands.MetaDataRequestCommand;
import org.eclipse.vtp.framework.interactions.core.commands.OutputMessageCommand;
import org.eclipse.vtp.framework.interactions.core.commands.SelectionRequestCommand;
import org.eclipse.vtp.framework.interactions.core.commands.TransferMessageCommand;
import org.eclipse.vtp.framework.interactions.core.configurations.BridgeMessageConfiguration;
import org.eclipse.vtp.framework.interactions.core.configurations.DataRequestConfiguration;
import org.eclipse.vtp.framework.interactions.core.configurations.ExternalReferenceConfiguration;
import org.eclipse.vtp.framework.interactions.core.configurations.InputConfiguration;
import org.eclipse.vtp.framework.interactions.core.configurations.InputRequestConfiguration;
import org.eclipse.vtp.framework.interactions.core.configurations.MediaConfiguration;
import org.eclipse.vtp.framework.interactions.core.configurations.MetaDataConfiguration;
import org.eclipse.vtp.framework.interactions.core.configurations.MetaDataItemConfiguration;
import org.eclipse.vtp.framework.interactions.core.configurations.OutputConfiguration;
import org.eclipse.vtp.framework.interactions.core.configurations.OutputMessageConfiguration;
import org.eclipse.vtp.framework.interactions.core.configurations.PropertyConfiguration;
import org.eclipse.vtp.framework.interactions.core.configurations.SelectionChoiceConfiguration;
import org.eclipse.vtp.framework.interactions.core.configurations.SelectionRequestConfiguration;
import org.eclipse.vtp.framework.interactions.core.configurations.TransferMessageConfiguration;
import org.eclipse.vtp.framework.interactions.core.conversation.IBridgeMessage;
import org.eclipse.vtp.framework.interactions.core.conversation.IConversation;
import org.eclipse.vtp.framework.interactions.core.conversation.IDataRequest;
import org.eclipse.vtp.framework.interactions.core.conversation.IEndMessage;
import org.eclipse.vtp.framework.interactions.core.conversation.IExternalReference;
import org.eclipse.vtp.framework.interactions.core.conversation.IFinal;
import org.eclipse.vtp.framework.interactions.core.conversation.IInitial;
import org.eclipse.vtp.framework.interactions.core.conversation.IInputRequest;
import org.eclipse.vtp.framework.interactions.core.conversation.IInteraction;
import org.eclipse.vtp.framework.interactions.core.conversation.IMetaDataMessage;
import org.eclipse.vtp.framework.interactions.core.conversation.IMetaDataRequest;
import org.eclipse.vtp.framework.interactions.core.conversation.IOutputMessage;
import org.eclipse.vtp.framework.interactions.core.conversation.ISelectionRequest;
import org.eclipse.vtp.framework.interactions.core.conversation.ITransferMessage;
import org.eclipse.vtp.framework.interactions.core.media.Content;
import org.eclipse.vtp.framework.interactions.core.media.CustomInputGrammar;
import org.eclipse.vtp.framework.interactions.core.media.FileContent;
import org.eclipse.vtp.framework.interactions.core.media.FileInputGrammar;
import org.eclipse.vtp.framework.interactions.core.media.IDataSet;
import org.eclipse.vtp.framework.interactions.core.media.IMediaProviderRegistry;
import org.eclipse.vtp.framework.interactions.core.media.InputGrammar;
import org.eclipse.vtp.framework.interactions.core.media.MediaRenderingManager;
import org.eclipse.vtp.framework.interactions.core.media.TextContent;
import org.eclipse.vtp.framework.spi.ICommand;
import org.eclipse.vtp.framework.spi.ICommandProcessor;

public class Conversation
implements IConversation {
    private final ICommandProcessor commandProcessor;
    private final IBrandSelection brandSelection;
    private final IInteractionTypeSelection interactionTypeSelection;
    private final ILanguageSelection languageSelection;
    private final IMediaProviderRegistry mediaProviderRegistry;
    private final IVariableRegistry variableRegistry;
    private final IDataSet dataSet;
    private final IScriptingService scriptingService;

    public Conversation(ICommandProcessor commandProcessor, IBrandSelection brandSelection, IInteractionTypeSelection interactionTypeSelection, ILanguageSelection languageSelection, IMediaProviderRegistry mediaProviderRegistry, IVariableRegistry variableRegistry, IScriptingService scriptingService) {
        this.commandProcessor = commandProcessor;
        this.brandSelection = brandSelection;
        this.interactionTypeSelection = interactionTypeSelection;
        this.languageSelection = languageSelection;
        this.mediaProviderRegistry = mediaProviderRegistry;
        this.variableRegistry = variableRegistry;
        this.dataSet = new DataSet(variableRegistry);
        this.scriptingService = scriptingService;
    }

    private List resolveOutput(OutputConfiguration configuration) {
        if (configuration == null) {
            return Collections.EMPTY_LIST;
        }
        String interactionTypeID = this.interactionTypeSelection.getSelectedInteractionType().getId();
        String languageID = this.languageSelection.getSelectedLanguage().getName();
        Content[] result = null;
        IBrand brand = this.brandSelection.getSelectedBrand();
        while (brand != null && result == null) {
            result = configuration.getItem(brand.getName(), interactionTypeID, languageID);
            if (result != null) continue;
            brand = brand.getParentBrand();
        }
        if (result == null) {
            return Collections.EMPTY_LIST;
        }
        String mediaProviderID = null;
        while (brand != null && mediaProviderID == null) {
            mediaProviderID = this.mediaProviderRegistry.lookupMediaProviderID(brand.getName(), interactionTypeID, languageID);
            if (mediaProviderID != null) continue;
            brand = brand.getParentBrand();
        }
        if (mediaProviderID == null) {
            return Collections.EMPTY_LIST;
        }
        List content = new MediaRenderingManager(this.mediaProviderRegistry.getMediaProvider(mediaProviderID), this.dataSet).renderContent(7, new ArrayList(Arrays.asList(result)));
        for (Content item : content) {
            if (!(item instanceof FileContent)) continue;
            ((FileContent)item).setStaticPath(String.valueOf(mediaProviderID) + "/" + ((FileContent)item).getPath());
        }
        return content;
    }

    private InputGrammar resolveInput(InputConfiguration configuration) {
        if (configuration == null) {
            return null;
        }
        String interactionTypeID = this.interactionTypeSelection.getSelectedInteractionType().getId();
        String languageID = this.languageSelection.getSelectedLanguage().getName();
        InputGrammar result = null;
        IBrand brand = this.brandSelection.getSelectedBrand();
        while (brand != null && result == null) {
            result = configuration.getItem(brand.getName(), interactionTypeID, languageID);
            if (result != null) continue;
            brand = brand.getParentBrand();
        }
        if (result == null) {
            return null;
        }
        String mediaProviderID = null;
        while (brand != null && mediaProviderID == null) {
            mediaProviderID = this.mediaProviderRegistry.lookupMediaProviderID(brand.getName(), interactionTypeID, languageID);
            if (mediaProviderID != null) continue;
            brand = brand.getParentBrand();
        }
        if (mediaProviderID == null) {
            return null;
        }
        if (result.isDataAware()) {
            result = result.captureData(this.dataSet);
        }
        if (result instanceof FileInputGrammar) {
            ((FileInputGrammar)result).setStaticPath(String.valueOf(mediaProviderID) + "/" + ((FileInputGrammar)result).getPath());
        }
        return result;
    }

    private String resolveProperty(PropertyConfiguration configuration, boolean useInteractionType) {
        if (configuration == null) {
            return null;
        }
        String interactionTypeID = this.interactionTypeSelection.getSelectedInteractionType().getId();
        String result = null;
        IBrand brand = this.brandSelection.getSelectedBrand();
        while (brand != null && result == null) {
            result = configuration.getItem(brand.getName(), useInteractionType ? interactionTypeID : "");
            brand = brand.getParentBrand();
        }
        return result;
    }

    private List resolveMetaData(MetaDataConfiguration configuration) {
        String interactionTypeID = this.interactionTypeSelection.getSelectedInteractionType().getId();
        String languageID = this.languageSelection.getSelectedLanguage().getName();
        MetaDataItemConfiguration[] items = null;
        IBrand brand = this.brandSelection.getSelectedBrand();
        while (brand != null && items == null) {
            items = configuration.getItem(String.valueOf(brand.getName()) + interactionTypeID + languageID);
            brand = brand.getParentBrand();
        }
        if (items == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<MetaDataItemConfiguration> results = new ArrayList<MetaDataItemConfiguration>(items.length);
        int i = 0;
        while (i < items.length) {
            block8: {
                MetaDataItemConfiguration item = items[i];
                switch (items[i].getValueType()) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        item = new MetaDataItemConfiguration();
                        item.setName(items[i].getName());
                        item.setStaticValue(String.valueOf(this.scriptingService.createScriptingEngine(items[i].getScriptingLanguage()).execute(items[i].getValue())));
                        break;
                    }
                    case 2: {
                        item = new MetaDataItemConfiguration();
                        item.setName(items[i].getName());
                        item.setStaticValue(this.dataSet.getData(items[i].getValue()).toString());
                        break;
                    }
                    default: {
                        break block8;
                    }
                }
                results.add(item);
            }
            ++i;
        }
        return results;
    }

    public IInitial createInitial(String resultParameterName, Map variables) {
        return new Initial(resultParameterName, variables);
    }

    public IOutputMessage createOutputMessage(OutputMessageConfiguration configuration) {
        return new OutputMessage(configuration);
    }

    public IMetaDataMessage createMetaDataMessage(MetaDataConfiguration configuration) {
        return new MetaDataMessage(configuration);
    }

    public IMetaDataRequest createMetaDataRequest(MetaDataConfiguration configuration, String resultParameterName) {
        return new MetaDataRequest(configuration, resultParameterName);
    }

    public IInputRequest createInputRequest(InputRequestConfiguration configuration, String resultParameterName) {
        return new InputRequest(configuration, resultParameterName);
    }

    public ISelectionRequest createSelectionRequest(SelectionRequestConfiguration configuration, String resultParameterName) {
        return new SelectionRequest(configuration, resultParameterName);
    }

    public IDataRequest createDataRequest(DataRequestConfiguration configuration, String resultParameterName) {
        return new DataRequest(configuration, resultParameterName);
    }

    public IExternalReference createExternalReference(ExternalReferenceConfiguration configuration) {
        return new ExternalReference(configuration);
    }

    public ITransferMessage createTransferMessage(TransferMessageConfiguration configuration) {
        return new TransferMessage(configuration);
    }

    public IBridgeMessage createBridgeMessage(BridgeMessageConfiguration configuration, String resultParameterName) {
        return new BridgeMessage(configuration, resultParameterName);
    }

    public IEndMessage createEndMessage() {
        return new EndMessage();
    }

    public IFinal createFinal() {
        return new Final();
    }

    private abstract class AbstractInteraction
    implements IInteraction {
        private AbstractInteraction() {
        }

        abstract ConversationCommand createCommand();

        public final boolean enqueue() {
            ConversationCommand command = this.createCommand();
            if (command == null) {
                return false;
            }
            return Conversation.this.commandProcessor.enqueue((ICommand)command);
        }

        public final boolean process() throws IllegalStateException {
            ConversationCommand command = this.createCommand();
            if (command == null) {
                return false;
            }
            return Conversation.this.commandProcessor.process((ICommand)command);
        }
    }

    private final class BridgeMessage
    extends AbstractInteraction
    implements IBridgeMessage {
        private final BridgeMessageConfiguration configuration;
        private final String resultParameterName;

        BridgeMessage(BridgeMessageConfiguration configuration, String resultParameterName) {
            this.configuration = configuration;
            this.resultParameterName = resultParameterName;
        }

        ConversationCommand createCommand() {
            String value = Conversation.this.resolveProperty(this.configuration.getDestination(), false);
            if (value == null) {
                return null;
            }
            String type = Conversation.this.resolveProperty(this.configuration.getType(), false);
            if ("variable".equalsIgnoreCase(type)) {
                value = String.valueOf(Conversation.this.variableRegistry.getVariable(value));
            } else if ("expression".equalsIgnoreCase(type)) {
                value = String.valueOf(Conversation.this.scriptingService.createScriptingEngine("JavaScript").execute(value));
            }
            BridgeMessageCommand command = new BridgeMessageCommand();
            command.setDestination(value);
            command.setResultName(this.resultParameterName);
            command.setTransferredResultValue("transferred");
            command.setBusyResultValue("busy");
            command.setUnavailableResultValue("unavailable");
            command.setNoAuthResultValue("noauthorization");
            command.setBadDestResultValue("baddestination");
            command.setNoRouteResultValue("noroute");
            command.setNoResourceResultValue("noresource");
            command.setProtocolResultValue("protocol");
            command.setBadBridgeResultValue("badbridge");
            command.setBadUriResultValue("baduri");
            return command;
        }
    }

    private final class DataRequest
    extends AbstractInteraction
    implements IDataRequest {
        private final DataRequestConfiguration configuration;
        private final String resultParameterName;
        private final Map parameters = new HashMap();

        DataRequest(DataRequestConfiguration configuration, String resultParameterName) {
            this.configuration = configuration;
            this.resultParameterName = resultParameterName;
        }

        ConversationCommand createCommand() {
            DataRequestCommand command = new DataRequestCommand();
            command.setResultName(this.resultParameterName);
            command.setFilledResultValue("success.filled");
            command.setNoInputResultValue("error.input.noinput");
            command.setDataName(this.configuration.getDataName());
            MediaConfiguration mediaConfig = this.configuration.getMediaConfiguration();
            if (mediaConfig != null) {
                String[] propertyNames = mediaConfig.getPropertyConfigurationNames();
                int i = 0;
                while (i < propertyNames.length) {
                    String value = Conversation.this.resolveProperty(mediaConfig.getPropertyConfiguration(propertyNames[i]), true);
                    if (value != null) {
                        command.setPropertyValue(propertyNames[i], value);
                    }
                    ++i;
                }
                List content = Conversation.this.resolveOutput(mediaConfig.getOutputConfiguration(this.configuration.getOutputName()));
                for (Content item : content) {
                    if (item instanceof TextContent) {
                        command.addTextOutput(((TextContent)item).getText());
                        continue;
                    }
                    if (!(item instanceof FileContent)) continue;
                    command.addFileOutput(((FileContent)item).getPath());
                }
            }
            for (Map.Entry entry : this.parameters.entrySet()) {
                command.setParameterValues((String)entry.getKey(), (String[])entry.getValue());
            }
            return command;
        }

        public void setParameterValue(String name, String value) {
            String[] stringArray;
            if (name == null) {
                return;
            }
            if (value == null) {
                stringArray = null;
            } else {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = value;
            }
            this.setParameterValues(name, stringArray);
        }

        public void setParameterValues(String name, String[] values) {
            if (name == null) {
                return;
            }
            if (values == null) {
                this.parameters.remove(name);
            } else {
                this.parameters.put(name, values);
            }
        }
    }

    private final class DataSet
    implements IDataSet {
        private final IVariableRegistry variables;

        DataSet(IVariableRegistry variables) {
            this.variables = variables;
        }

        public Object getData(String name) {
            IDataObject result = this.variables.getVariable(name);
            if (result == null) {
                return "";
            }
            return result.toString();
        }
    }

    private final class EndMessage
    extends AbstractInteraction
    implements IEndMessage {
        private EndMessage() {
        }

        ConversationCommand createCommand() {
            return new EndMessageCommand();
        }
    }

    private final class ExternalReference
    extends AbstractInteraction
    implements IExternalReference {
        private final ExternalReferenceConfiguration configuration;
        private final Map parameters = new HashMap();

        ExternalReference(ExternalReferenceConfiguration configuration) {
            this.configuration = configuration;
        }

        ConversationCommand createCommand() {
            ExternalReferenceCommand command = new ExternalReferenceCommand();
            for (Map.Entry entry : this.parameters.entrySet()) {
                command.setParameterValues((String)entry.getKey(), (String[])entry.getValue());
            }
            return command;
        }

        public void setParameterValue(String name, String value) {
            String[] stringArray;
            if (name == null) {
                return;
            }
            if (value == null) {
                stringArray = null;
            } else {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = value;
            }
            this.setParameterValues(name, stringArray);
        }

        public void setParameterValues(String name, String[] values) {
            if (name == null) {
                return;
            }
            if (values == null) {
                this.parameters.remove(name);
            } else {
                this.parameters.put(name, values);
            }
        }
    }

    private final class Final
    extends AbstractInteraction
    implements IFinal {
        private final Map variables = new HashMap();

        private Final() {
        }

        public void setVariableValue(String variableName, String variableValue) {
            this.variables.put(variableName, variableValue);
        }

        ConversationCommand createCommand() {
            FinalCommand command = new FinalCommand();
            for (Map.Entry entry : this.variables.entrySet()) {
                command.addVariable((String)entry.getKey(), (String)entry.getValue());
            }
            return command;
        }
    }

    private final class Initial
    extends AbstractInteraction
    implements IInitial {
        private final String resultParameterName;
        private final Map variables;
        private final Map parameters = new HashMap();

        Initial(String resultParameterName, Map variables) {
            this.resultParameterName = resultParameterName;
            this.variables = variables;
        }

        ConversationCommand createCommand() {
            InitialCommand command = new InitialCommand();
            command.setResultName(this.resultParameterName);
            command.setResultValue("success.filled");
            for (Map.Entry entry : this.variables.entrySet()) {
                command.setVariable((String)entry.getKey(), (String)entry.getValue());
            }
            for (Map.Entry entry : this.parameters.entrySet()) {
                command.setParameterValues((String)entry.getKey(), (String[])entry.getValue());
            }
            return command;
        }

        public void setParameterValue(String name, String value) {
            String[] stringArray;
            if (name == null) {
                return;
            }
            if (value == null) {
                stringArray = null;
            } else {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = value;
            }
            this.setParameterValues(name, stringArray);
        }

        public void setParameterValues(String name, String[] values) {
            if (name == null) {
                return;
            }
            if (values == null) {
                this.parameters.remove(name);
            } else {
                this.parameters.put(name, values);
            }
        }
    }

    private final class InputRequest
    extends AbstractInteraction
    implements IInputRequest {
        private final InputRequestConfiguration configuration;
        private final String resultParameterName;
        private final Map parameters = new HashMap();

        InputRequest(InputRequestConfiguration configuration, String resultParameterName) {
            this.configuration = configuration;
            this.resultParameterName = resultParameterName;
        }

        ConversationCommand createCommand() {
            InputRequestCommand command = new InputRequestCommand();
            command.setResultName(this.resultParameterName);
            command.setFilledResultValue("success.filled");
            command.setNoInputResultValue("error.input.noinput");
            command.setNoMatchResultValue("error.input.nomatch");
            command.setDataName(this.configuration.getDataName());
            MediaConfiguration mediaConfig = this.configuration.getMediaConfiguration();
            if (mediaConfig != null) {
                String[] propertyNames = mediaConfig.getPropertyConfigurationNames();
                int i = 0;
                while (i < propertyNames.length) {
                    String value = Conversation.this.resolveProperty(mediaConfig.getPropertyConfiguration(propertyNames[i]), true);
                    if (value != null) {
                        command.setPropertyValue(propertyNames[i], value);
                    }
                    ++i;
                }
                List content = Conversation.this.resolveOutput(mediaConfig.getOutputConfiguration(this.configuration.getOutputName()));
                for (Content item : content) {
                    if (item instanceof TextContent) {
                        command.addTextOutput(((TextContent)item).getText());
                        continue;
                    }
                    if (!(item instanceof FileContent)) continue;
                    command.addFileOutput(((FileContent)item).getPath());
                }
                InputGrammar grammar = Conversation.this.resolveInput(mediaConfig.getInputConfiguration(this.configuration.getInputName()));
                if (grammar instanceof FileInputGrammar) {
                    command.setFileInput(((FileInputGrammar)grammar).getPath());
                } else if (grammar instanceof CustomInputGrammar) {
                    command.setCustomInput(((CustomInputGrammar)grammar).getCustomInputData());
                }
                System.out.println("#####: " + this.configuration.getInputName());
                System.out.println("#####: " + this.configuration.getInputName2());
                InputGrammar grammar2 = Conversation.this.resolveInput(mediaConfig.getInputConfiguration(this.configuration.getInputName2()));
                if (grammar2 instanceof FileInputGrammar) {
                    command.setFileInput2(((FileInputGrammar)grammar2).getPath());
                } else if (grammar2 instanceof CustomInputGrammar) {
                    command.setCustomInput2(((CustomInputGrammar)grammar2).getCustomInputData());
                }
            }
            for (Map.Entry entry : this.parameters.entrySet()) {
                command.setParameterValues((String)entry.getKey(), (String[])entry.getValue());
            }
            return command;
        }

        public void setParameterValue(String name, String value) {
            String[] stringArray;
            if (name == null) {
                return;
            }
            if (value == null) {
                stringArray = null;
            } else {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = value;
            }
            this.setParameterValues(name, stringArray);
        }

        public void setParameterValues(String name, String[] values) {
            if (name == null) {
                return;
            }
            if (values == null) {
                this.parameters.remove(name);
            } else {
                this.parameters.put(name, values);
            }
        }
    }

    private final class MetaDataMessage
    extends AbstractInteraction
    implements IMetaDataMessage {
        private final MetaDataConfiguration configuration;
        private final Map parameters = new HashMap();

        MetaDataMessage(MetaDataConfiguration configuration) {
            this.configuration = configuration;
        }

        ConversationCommand createCommand() {
            MetaDataMessageCommand command = new MetaDataMessageCommand();
            List metaData = Conversation.this.resolveMetaData(this.configuration);
            for (MetaDataItemConfiguration metaDataItemConfiguration : metaData) {
                command.setMetaDataValue(metaDataItemConfiguration.getName(), metaDataItemConfiguration.getValue());
            }
            for (Map.Entry entry : this.parameters.entrySet()) {
                command.setParameterValues((String)entry.getKey(), (String[])entry.getValue());
            }
            return command;
        }

        public void setParameterValue(String name, String value) {
            String[] stringArray;
            if (name == null) {
                return;
            }
            if (value == null) {
                stringArray = null;
            } else {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = value;
            }
            this.setParameterValues(name, stringArray);
        }

        public void setParameterValues(String name, String[] values) {
            if (name == null) {
                return;
            }
            if (values == null) {
                this.parameters.remove(name);
            } else {
                this.parameters.put(name, values);
            }
        }
    }

    private final class MetaDataRequest
    extends AbstractInteraction
    implements IMetaDataRequest {
        private final MetaDataConfiguration configuration;
        private final String resultParameterName;
        private final Map parameters = new HashMap();

        MetaDataRequest(MetaDataConfiguration configuration, String resultParameterName) {
            this.configuration = configuration;
            this.resultParameterName = resultParameterName;
        }

        ConversationCommand createCommand() {
            MetaDataRequestCommand command = new MetaDataRequestCommand();
            command.setResultName(this.resultParameterName);
            command.setFilledResultValue("success.filled");
            command.setDataName("GetAttachedData");
            List metaData = Conversation.this.resolveMetaData(this.configuration);
            for (MetaDataItemConfiguration metaDataItemConfiguration : metaData) {
                command.addMetaDataName(metaDataItemConfiguration.getName());
            }
            for (Map.Entry entry : this.parameters.entrySet()) {
                command.setParameterValues((String)entry.getKey(), (String[])entry.getValue());
            }
            return command;
        }

        public void setParameterValue(String name, String value) {
            String[] stringArray;
            if (name == null) {
                return;
            }
            if (value == null) {
                stringArray = null;
            } else {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = value;
            }
            this.setParameterValues(name, stringArray);
        }

        public void setParameterValues(String name, String[] values) {
            if (name == null) {
                return;
            }
            if (values == null) {
                this.parameters.remove(name);
            } else {
                this.parameters.put(name, values);
            }
        }
    }

    private final class OutputMessage
    extends AbstractInteraction
    implements IOutputMessage {
        private final OutputMessageConfiguration configuration;
        private final Map parameters = new HashMap();

        OutputMessage(OutputMessageConfiguration configuration) {
            this.configuration = configuration;
        }

        ConversationCommand createCommand() {
            OutputMessageCommand command = new OutputMessageCommand();
            MediaConfiguration mediaConfig = this.configuration.getMediaConfiguration();
            if (mediaConfig != null) {
                String[] propertyNames = mediaConfig.getPropertyConfigurationNames();
                int i = 0;
                while (i < propertyNames.length) {
                    String value = Conversation.this.resolveProperty(mediaConfig.getPropertyConfiguration(propertyNames[i]), true);
                    if (value != null) {
                        command.setPropertyValue(propertyNames[i], value);
                    }
                    ++i;
                }
                List content = Conversation.this.resolveOutput(mediaConfig.getOutputConfiguration(this.configuration.getOutputName()));
                for (Content item : content) {
                    if (item instanceof TextContent) {
                        command.addTextOutput(((TextContent)item).getText());
                        continue;
                    }
                    if (!(item instanceof FileContent)) continue;
                    command.addFileOutput(((FileContent)item).getPath());
                }
            }
            for (Map.Entry entry : this.parameters.entrySet()) {
                command.setParameterValues((String)entry.getKey(), (String[])entry.getValue());
            }
            return command;
        }

        public void setParameterValue(String name, String value) {
            String[] stringArray;
            if (name == null) {
                return;
            }
            if (value == null) {
                stringArray = null;
            } else {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = value;
            }
            this.setParameterValues(name, stringArray);
        }

        public void setParameterValues(String name, String[] values) {
            if (name == null) {
                return;
            }
            if (values == null) {
                this.parameters.remove(name);
            } else {
                this.parameters.put(name, values);
            }
        }
    }

    private final class SelectionRequest
    extends AbstractInteraction
    implements ISelectionRequest {
        private final SelectionRequestConfiguration configuration;
        private final String resultParameterName;
        private final Map parameters = new HashMap();

        SelectionRequest(SelectionRequestConfiguration configuration, String resultParameterName) {
            this.configuration = configuration;
            this.resultParameterName = resultParameterName;
        }

        ConversationCommand createCommand() {
            SelectionRequestCommand command;
            block20: {
                command = new SelectionRequestCommand();
                command.setResultName(this.resultParameterName);
                command.setFilledResultValue("success.filled");
                command.setNoInputResultValue("error.input.noinput");
                command.setNoMatchResultValue("error.input.nomatch");
                command.setSelectionName(this.configuration.getDataName());
                MediaConfiguration mediaConfig = this.configuration.getMediaConfiguration();
                if (mediaConfig != null) {
                    String[] propertyNames = mediaConfig.getPropertyConfigurationNames();
                    int i = 0;
                    while (i < propertyNames.length) {
                        String value = Conversation.this.resolveProperty(mediaConfig.getPropertyConfiguration(propertyNames[i]), true);
                        if (value != null) {
                            command.setPropertyValue(propertyNames[i], value);
                        }
                        ++i;
                    }
                    List content = Conversation.this.resolveOutput(mediaConfig.getOutputConfiguration(this.configuration.getOutputName()));
                    for (Content item : content) {
                        if (item instanceof TextContent) {
                            command.addTextOutput(((TextContent)item).getText());
                            continue;
                        }
                        if (!(item instanceof FileContent)) continue;
                        command.addFileOutput(((FileContent)item).getPath());
                    }
                }
                SelectionChoiceConfiguration[] choices = this.configuration.getChoices();
                HashMap<String, SelectionChoiceConfiguration> choiceIndex = new HashMap<String, SelectionChoiceConfiguration>(choices.length);
                int i = 0;
                while (i < choices.length) {
                    choiceIndex.put(choices[i].getName(), choices[i]);
                    ++i;
                }
                String[] choiceNames = null;
                IBrand brand = Conversation.this.brandSelection.getSelectedBrand();
                while (choiceNames == null && brand != null) {
                    choiceNames = this.configuration.getBrandedChoices(brand.getName());
                    brand = brand.getParentBrand();
                }
                if (choiceNames == null) break block20;
                int i2 = 0;
                int index = 0;
                while (i2 < choiceNames.length) {
                    block21: {
                        SelectionChoiceConfiguration choice;
                        block22: {
                            IScriptingEngine engine;
                            choice = (SelectionChoiceConfiguration)choiceIndex.get(choiceNames[i2]);
                            if (choice == null) break block21;
                            String script = choice.getScript();
                            String scriptingLanguage = choice.getScriptingLanguage();
                            if (scriptingLanguage == null || script == null || (engine = Conversation.this.scriptingService.createScriptingEngine(scriptingLanguage)) == null) break block22;
                            Object scriptResult = engine.execute(script);
                            if (Boolean.FALSE.toString().equalsIgnoreCase(String.valueOf(scriptResult))) break block21;
                        }
                        command.addOption(choice.getName());
                        mediaConfig = choice.getMediaConfiguration();
                        if (mediaConfig != null) {
                            String[] propertyNames = mediaConfig.getPropertyConfigurationNames();
                            int j = 0;
                            while (j < propertyNames.length) {
                                String value = Conversation.this.resolveProperty(mediaConfig.getPropertyConfiguration(propertyNames[j]), true);
                                if (value != null) {
                                    command.setOptionProperty(index, propertyNames[j], value);
                                }
                                ++j;
                            }
                            List content = Conversation.this.resolveOutput(mediaConfig.getOutputConfiguration(choice.getOutputName()));
                            for (Content item : content) {
                                if (item instanceof TextContent) {
                                    command.addOptionTextOutput(index, ((TextContent)item).getText());
                                    continue;
                                }
                                if (!(item instanceof FileContent)) continue;
                                command.addOptionFileOutput(index, ((FileContent)item).getPath());
                            }
                            InputGrammar grammar = Conversation.this.resolveInput(mediaConfig.getInputConfiguration(choice.getInputName()));
                            if (grammar instanceof FileInputGrammar) {
                                command.setOptionFileInput(index, ((FileInputGrammar)grammar).getPath());
                            } else if (grammar instanceof CustomInputGrammar) {
                                command.setOptionCustomInput(index, ((CustomInputGrammar)grammar).getCustomInputData());
                            }
                        }
                        ++index;
                    }
                    ++i2;
                }
            }
            for (Map.Entry entry : this.parameters.entrySet()) {
                command.setParameterValues((String)entry.getKey(), (String[])entry.getValue());
            }
            return command;
        }

        public void setParameterValue(String name, String value) {
            String[] stringArray;
            if (name == null) {
                return;
            }
            if (value == null) {
                stringArray = null;
            } else {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = value;
            }
            this.setParameterValues(name, stringArray);
        }

        public void setParameterValues(String name, String[] values) {
            if (name == null) {
                return;
            }
            if (values == null) {
                this.parameters.remove(name);
            } else {
                this.parameters.put(name, values);
            }
        }
    }

    private final class TransferMessage
    extends AbstractInteraction
    implements ITransferMessage {
        private final TransferMessageConfiguration configuration;

        TransferMessage(TransferMessageConfiguration configuration) {
            this.configuration = configuration;
        }

        ConversationCommand createCommand() {
            String value = Conversation.this.resolveProperty(this.configuration.getDestination(), false);
            if (value == null) {
                return null;
            }
            String type = Conversation.this.resolveProperty(this.configuration.getType(), false);
            if ("variable".equalsIgnoreCase(type)) {
                value = String.valueOf(Conversation.this.variableRegistry.getVariable(value));
            } else if ("expression".equalsIgnoreCase(type)) {
                value = String.valueOf(Conversation.this.scriptingService.createScriptingEngine("JavaScript").execute(value));
            }
            TransferMessageCommand command = new TransferMessageCommand();
            command.setDestination(value);
            return command;
        }
    }
}

