/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.framework.interactions.core.services;

import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.vtp.framework.interactions.core.ILanguage;
import org.eclipse.vtp.framework.interactions.core.ILanguageRegistry;
import org.eclipse.vtp.framework.interactions.core.configurations.LanguageConfiguration;

public class LanguageRegistry
implements ILanguageRegistry {
    private final Map languages;

    public LanguageRegistry(LanguageConfiguration[] configurations) {
        HashMap<String, Language> languages = new HashMap<String, Language>(configurations.length);
        int i = 0;
        while (i < configurations.length) {
            languages.put(configurations[i].getID(), new Language(configurations[i]));
            ++i;
        }
        this.languages = Collections.unmodifiableMap(languages);
    }

    public String[] getLanguageIDs() {
        return this.languages.keySet().toArray(new String[this.languages.size()]);
    }

    public ILanguage getLanguage(String languageID) {
        return (ILanguage)this.languages.get(languageID);
    }

    private final class Language
    implements ILanguage {
        private final String id;
        private final String name;
        private final Locale locale;

        Language(LanguageConfiguration configuration) {
            this.id = configuration.getID();
            this.name = this.id.substring(this.id.lastIndexOf(":") + 1);
            String localeStr = configuration.getLocale();
            if (localeStr != null && localeStr.length() > 0) {
                Locale locale = null;
                StringTokenizer st = new StringTokenizer(localeStr, "_-");
                if (st.hasMoreElements()) {
                    String language = st.nextToken();
                    if (st.hasMoreElements()) {
                        String country = st.nextToken();
                        locale = st.hasMoreElements() ? new Locale(language, country, st.nextToken()) : new Locale(language, country);
                    } else {
                        locale = new Locale(language);
                    }
                }
                this.locale = locale;
            } else {
                this.locale = null;
            }
        }

        public String getID() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public Locale getLocale() {
            return this.locale;
        }
    }
}

