/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.framework.interactions.core.services;

import java.util.Locale;
import org.eclipse.vtp.framework.core.ISessionContext;
import org.eclipse.vtp.framework.interactions.core.ILanguage;
import org.eclipse.vtp.framework.interactions.core.ILanguageRegistry;
import org.eclipse.vtp.framework.interactions.core.ILanguageSelection;

public class LanguageSelection
implements ILanguageSelection {
    private final ISessionContext context;
    private final ILanguageRegistry languageRegistry;
    private final ILanguage defaultLanguage;

    public LanguageSelection(ISessionContext context, ILanguageRegistry languageRegistry) {
        this.context = context;
        this.languageRegistry = languageRegistry;
        ILanguage defaultLanguage = null;
        String[] ids = languageRegistry.getLanguageIDs();
        Locale locale = Locale.getDefault();
        int i = 0;
        while (defaultLanguage == null && i < ids.length) {
            if (locale.equals(languageRegistry.getLanguage(ids[i]).getLocale())) {
                defaultLanguage = languageRegistry.getLanguage(ids[i]);
            }
            ++i;
        }
        if (defaultLanguage == null) {
            locale = new Locale(locale.getLanguage(), locale.getCountry());
            i = 0;
            while (defaultLanguage == null && i < ids.length) {
                if (locale.equals(languageRegistry.getLanguage(ids[i]).getLocale())) {
                    defaultLanguage = languageRegistry.getLanguage(ids[i]);
                }
                ++i;
            }
            if (defaultLanguage == null) {
                locale = new Locale(locale.getLanguage());
                i = 0;
                while (defaultLanguage == null && i < ids.length) {
                    if (locale.equals(languageRegistry.getLanguage(ids[i]).getLocale())) {
                        defaultLanguage = languageRegistry.getLanguage(ids[i]);
                    }
                    ++i;
                }
            }
        }
        this.defaultLanguage = defaultLanguage;
    }

    public ILanguage getSelectedLanguage() {
        String id = (String)this.context.getAttribute("language.selection");
        if (id == null) {
            return this.defaultLanguage;
        }
        ILanguage lang = this.languageRegistry.getLanguage(id);
        if (lang == null) {
            return this.defaultLanguage;
        }
        return lang;
    }

    public boolean setSelectedLanguage(String lanaguageID) {
        if (lanaguageID == null) {
            this.context.clearAttribute("language.selection");
            return true;
        }
        ILanguage lang = this.languageRegistry.getLanguage(lanaguageID);
        if (lang == null) {
            return false;
        }
        this.context.setAttribute("language.selection", (Object)lanaguageID);
        return true;
    }
}

