/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.framework.interactions.core.services;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.vtp.framework.core.IProcessContext;
import org.eclipse.vtp.framework.interactions.core.configurations.MediaProviderBindingConfiguration;
import org.eclipse.vtp.framework.interactions.core.configurations.MediaProviderConfiguration;
import org.eclipse.vtp.framework.interactions.core.configurations.SharedContentConfiguration;
import org.eclipse.vtp.framework.interactions.core.media.Content;
import org.eclipse.vtp.framework.interactions.core.media.FormattableContent;
import org.eclipse.vtp.framework.interactions.core.media.IContentType;
import org.eclipse.vtp.framework.interactions.core.media.IContentTypeRegistry;
import org.eclipse.vtp.framework.interactions.core.media.IFormatManager;
import org.eclipse.vtp.framework.interactions.core.media.IFormatter;
import org.eclipse.vtp.framework.interactions.core.media.IFormatterRegistry;
import org.eclipse.vtp.framework.interactions.core.media.IMediaProvider;
import org.eclipse.vtp.framework.interactions.core.media.IMediaProviderRegistry;
import org.eclipse.vtp.framework.interactions.core.media.IResourceManager;
import org.eclipse.vtp.framework.interactions.core.media.IResourceManagerRegistry;
import org.eclipse.vtp.framework.interactions.core.media.ISharedContentProvider;

public class MediaProviderRegistry
implements IMediaProviderRegistry {
    private final Map mediaProviders;
    private final Map mediaProviderIndex;

    public MediaProviderRegistry(IProcessContext context, IContentTypeRegistry content, IFormatterRegistry formatters, IResourceManagerRegistry resources, MediaProviderConfiguration[] configurations, MediaProviderBindingConfiguration[] bindings) {
        HashMap<String, MediaProvider> mediaProviders = new HashMap<String, MediaProvider>(configurations.length);
        HashMap contentTypes = new HashMap();
        int i = 0;
        while (i < configurations.length) {
            mediaProviders.put(configurations[i].getID(), new MediaProvider(context, content, formatters, resources, configurations[i], contentTypes));
            ++i;
        }
        this.mediaProviders = Collections.unmodifiableMap(mediaProviders);
        HashMap<String, String> mediaProviderIndex = new HashMap<String, String>(bindings.length);
        int i2 = 0;
        while (i2 < bindings.length) {
            mediaProviderIndex.put(bindings[i2].getKey(), bindings[i2].getMediaProviderID());
            ++i2;
        }
        this.mediaProviderIndex = Collections.unmodifiableMap(mediaProviderIndex);
    }

    public String[] getMediaProviderIDs() {
        return this.mediaProviders.keySet().toArray(new String[this.mediaProviders.size()]);
    }

    public IMediaProvider getMediaProvider(String mediaProviderID) {
        return (IMediaProvider)this.mediaProviders.get(mediaProviderID);
    }

    public String lookupMediaProviderID(String brandPath, String interactionTypeID, String langugageID) {
        return (String)this.mediaProviderIndex.get(String.valueOf(brandPath) + interactionTypeID + langugageID);
    }

    private final class MediaProvider
    implements IMediaProvider,
    IFormatManager,
    ISharedContentProvider {
        private final List contentTypes;
        private final IFormatter formatter;
        private final IResourceManager resourceManager;
        private final Map sharedContent;

        MediaProvider(IProcessContext context, IContentTypeRegistry content, IFormatterRegistry formatters, IResourceManagerRegistry resources, MediaProviderConfiguration configuration, Map cache) {
            ArrayList<IContentType> contentTypes = new ArrayList<IContentType>((Collection)Arrays.asList(content.getContentTypeIDs()));
            int i = 0;
            while (i < contentTypes.size()) {
                contentTypes.set(i, content.getContentType((String)contentTypes.get(i)));
                ++i;
            }
            this.contentTypes = Collections.unmodifiableList(contentTypes);
            this.formatter = formatters.getFormatter(configuration.getFormatterID());
            this.resourceManager = resources.getResourceManager(configuration.getResourceManagerID());
            SharedContentConfiguration[] contentConfigurations = configuration.getSharedContent();
            HashMap<String, Content> sharedContent = new HashMap<String, Content>(contentConfigurations.length);
            int i2 = 0;
            while (i2 < contentConfigurations.length) {
                sharedContent.put(contentConfigurations[i2].getName(), contentConfigurations[i2].getContent().createCopy());
                ++i2;
            }
            this.sharedContent = Collections.unmodifiableMap(sharedContent);
        }

        public List getSupportedContentTypes() {
            return this.contentTypes;
        }

        public IFormatManager getFormatManager() {
            return this;
        }

        public IFormatter getFormatter() {
            return this.formatter;
        }

        public IResourceManager getResourceManager() {
            return this.resourceManager;
        }

        public boolean hasSharedContent() {
            return !this.sharedContent.isEmpty();
        }

        public ISharedContentProvider getSharedContentProvider() {
            return this.sharedContent.isEmpty() ? null : this;
        }

        public String getFormat(FormattableContent content, String formatName) {
            return this.formatter.getDefaultFormatDefintion(content, formatName);
        }

        public List getFormats(FormattableContent content) {
            return this.formatter.getDefaultFormats(content);
        }

        public List listSharedContent() {
            return new ArrayList(this.sharedContent.keySet());
        }

        public Content getSharedContent(String contentName) {
            Content content = (Content)this.sharedContent.get(contentName);
            if (content == null) {
                return null;
            }
            return content.createCopy();
        }
    }
}

