/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.framework.interactions.core.support;

import org.eclipse.vtp.framework.interactions.core.commands.BridgeMessageCommand;
import org.eclipse.vtp.framework.interactions.core.commands.DataRequestCommand;
import org.eclipse.vtp.framework.interactions.core.commands.EndMessageCommand;
import org.eclipse.vtp.framework.interactions.core.commands.ExternalReferenceCommand;
import org.eclipse.vtp.framework.interactions.core.commands.FinalCommand;
import org.eclipse.vtp.framework.interactions.core.commands.IConversationCommandVisitor;
import org.eclipse.vtp.framework.interactions.core.commands.InitialCommand;
import org.eclipse.vtp.framework.interactions.core.commands.InputRequestCommand;
import org.eclipse.vtp.framework.interactions.core.commands.MetaDataMessageCommand;
import org.eclipse.vtp.framework.interactions.core.commands.MetaDataRequestCommand;
import org.eclipse.vtp.framework.interactions.core.commands.OutputMessageCommand;
import org.eclipse.vtp.framework.interactions.core.commands.SelectionRequestCommand;
import org.eclipse.vtp.framework.interactions.core.commands.TransferMessageCommand;
import org.eclipse.vtp.framework.interactions.core.platforms.IDocument;
import org.eclipse.vtp.framework.interactions.core.platforms.ILinkFactory;
import org.eclipse.vtp.framework.interactions.core.platforms.IPlatform;
import org.eclipse.vtp.framework.interactions.core.platforms.IRenderingQueue;
import org.eclipse.vtp.framework.spi.ICommand;
import org.eclipse.vtp.framework.spi.ICommandVisitor;

public abstract class AbstractPlatform
implements IPlatform {
    protected AbstractPlatform() {
    }

    protected IDocument renderInitialDocument(ILinkFactory links, InitialCommand initialCommand) {
        return null;
    }

    protected IDocument renderOutputMessage(ILinkFactory links, OutputMessageCommand outputMessageCommand) {
        return null;
    }

    protected IDocument renderMetaDataMessage(ILinkFactory links, MetaDataMessageCommand metaDataMessageCommand) {
        return null;
    }

    protected IDocument renderMetaDataRequest(ILinkFactory links, MetaDataRequestCommand metaDataMessageRequest) {
        return null;
    }

    protected IDocument renderInputRequest(ILinkFactory links, InputRequestCommand inputRequestCommand) {
        return null;
    }

    protected IDocument renderSelectionRequest(ILinkFactory links, SelectionRequestCommand selectionRequestCommand) {
        return null;
    }

    protected IDocument renderDataRequest(ILinkFactory links, DataRequestCommand dataRequestCommand) {
        return null;
    }

    protected IDocument renderExternalReference(ILinkFactory links, ExternalReferenceCommand externalReferenceCommand) {
        return null;
    }

    protected IDocument renderTransferMessage(ILinkFactory links, TransferMessageCommand transferMessageCommand) {
        return null;
    }

    protected IDocument renderBridgeMessage(ILinkFactory links, BridgeMessageCommand bridgeMessageCommand) {
        return null;
    }

    protected IDocument renderEndMessage(ILinkFactory links, EndMessageCommand endMessageCommand) {
        return null;
    }

    protected IDocument renderFinalDocument(ILinkFactory links, FinalCommand finalCommand) {
        return null;
    }

    public IDocument createDocument(ILinkFactory links, IRenderingQueue renderingQueue) {
        IDocument document = null;
        Renderer renderer = new Renderer(links);
        while (!renderingQueue.isEmpty() && document == null) {
            document = (IDocument)renderingQueue.next().accept((ICommandVisitor)renderer);
        }
        return document;
    }

    private final class Renderer
    implements IConversationCommandVisitor {
        private final ILinkFactory links;

        Renderer(ILinkFactory links) {
            this.links = links;
        }

        public Object visitInitial(InitialCommand initialCommand) {
            return AbstractPlatform.this.renderInitialDocument(this.links, initialCommand);
        }

        public Object visitOutputMessage(OutputMessageCommand outputMessageCommand) {
            return AbstractPlatform.this.renderOutputMessage(this.links, outputMessageCommand);
        }

        public Object visitMetaDataMessage(MetaDataMessageCommand metaDataMessageCommand) {
            return AbstractPlatform.this.renderMetaDataMessage(this.links, metaDataMessageCommand);
        }

        public Object visitMetaDataRequest(MetaDataRequestCommand metaDataRequestCommand) {
            return AbstractPlatform.this.renderMetaDataRequest(this.links, metaDataRequestCommand);
        }

        public Object visitInputRequest(InputRequestCommand inputRequestCommand) {
            return AbstractPlatform.this.renderInputRequest(this.links, inputRequestCommand);
        }

        public Object visitSelectionRequest(SelectionRequestCommand selectionRequestCommand) {
            return AbstractPlatform.this.renderSelectionRequest(this.links, selectionRequestCommand);
        }

        public Object visitDataRequest(DataRequestCommand dataRequestCommand) {
            return AbstractPlatform.this.renderDataRequest(this.links, dataRequestCommand);
        }

        public Object visitExternalReference(ExternalReferenceCommand externalReferenceCommand) {
            return AbstractPlatform.this.renderExternalReference(this.links, externalReferenceCommand);
        }

        public Object visitTransferMessage(TransferMessageCommand transferMessageCommand) {
            return AbstractPlatform.this.renderTransferMessage(this.links, transferMessageCommand);
        }

        public Object visitBridgeMessage(BridgeMessageCommand bridgeMessageCommand) {
            return AbstractPlatform.this.renderBridgeMessage(this.links, bridgeMessageCommand);
        }

        public Object visitEndMessage(EndMessageCommand endMessageCommand) {
            return AbstractPlatform.this.renderEndMessage(this.links, endMessageCommand);
        }

        public Object visitFinal(FinalCommand finalCommand) {
            return AbstractPlatform.this.renderFinalDocument(this.links, finalCommand);
        }

        public Object visitUnknown(ICommand unknownCommand) throws NullPointerException {
            return null;
        }
    }
}

