/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.framework.interactions.core.support;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.vtp.framework.util.XMLWriter;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public abstract class Widget {
    private static final String EMPTY = new String();

    protected Widget() {
    }

    public abstract void writeWidget(ContentHandler var1) throws NullPointerException, SAXException;

    public void writeWidget(OutputStream outputStream) throws IOException, NullPointerException {
        if (outputStream == null) {
            throw new NullPointerException("writer");
        }
        OutputStreamWriter writer = new OutputStreamWriter(outputStream);
        this.writeWidget(writer);
        writer.flush();
    }

    public void writeWidget(Writer writer) throws IOException, NullPointerException {
        if (writer == null) {
            throw new NullPointerException("writer");
        }
        try {
            PrintWriter printWriter = new PrintWriter(writer);
            this.writeWidget((ContentHandler)new XMLWriter(printWriter));
            printWriter.flush();
        }
        catch (SAXException e) {
            IOException ex = new IOException(e.getMessage());
            ex.initCause(e);
            throw ex;
        }
    }

    protected void writeAttribute(AttributesImpl attributes, String uri, String localName, String name, String type, String value) throws NullPointerException {
        if (attributes == null) {
            throw new NullPointerException("attributes");
        }
        uri = uri == null ? EMPTY : uri;
        localName = localName == null ? EMPTY : localName;
        name = name == null ? EMPTY : name;
        type = type == null ? EMPTY : type;
        value = value == null ? EMPTY : value;
        int index = -1;
        if (uri.length() == 0) {
            if (name.length() > 0) {
                index = attributes.getIndex(name);
            }
            if (index < 0 && localName.length() > 0) {
                index = attributes.getIndex(localName);
            }
        } else if (localName.length() == 0) {
            index = attributes.getIndex(name);
        } else {
            index = attributes.getIndex(uri, localName);
            if (index < 0 && name.length() > 0) {
                index = attributes.getIndex(name);
            }
        }
        if (index >= 0) {
            attributes.setAttribute(index, uri, localName, name, type, value);
        } else {
            attributes.addAttribute(uri, localName, name, type, value);
        }
    }

    protected void writeChildren(ContentHandler outputHandler, Widget[] children) throws NullPointerException, SAXException {
        if (outputHandler == null) {
            throw new NullPointerException("outputHandler");
        }
        if (children != null) {
            int i = 0;
            while (i < children.length) {
                children[i].writeWidget(outputHandler);
                ++i;
            }
        }
    }

    protected void writeChildren(ContentHandler outputHandler, Collection children) throws NullPointerException, SAXException {
        if (outputHandler == null) {
            throw new NullPointerException("outputHandler");
        }
        if (children != null) {
            Iterator i = children.iterator();
            while (i.hasNext()) {
                ((Widget)i.next()).writeWidget(outputHandler);
            }
        }
    }

    public String toString() {
        StringWriter writer = new StringWriter();
        try {
            this.writeWidget(writer);
        }
        catch (IOException e) {
            writer.write(e.getMessage());
        }
        return writer.toString();
    }
}

