/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.framework.interactions.core.support;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.xml.transform.Source;
import javax.xml.transform.sax.SAXSource;
import org.eclipse.vtp.framework.interactions.core.platforms.IDocument;
import org.eclipse.vtp.framework.interactions.core.support.Widget;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;

public abstract class WidgetDocument
extends Widget
implements IDocument {
    protected WidgetDocument() {
    }

    public String getContentType() {
        return "text/xml";
    }

    public Source toXMLSource() throws IllegalStateException {
        return new SAXSource(new WidgetReader(), new InputSource());
    }

    private final class WidgetReader
    implements XMLReader {
        private final Map features = new HashMap();
        private final Map properties = new HashMap();
        private ContentHandler contentHandler = null;
        private DTDHandler dtdHandler = null;
        private EntityResolver entityResolver = null;
        private ErrorHandler errorHandler = null;

        private WidgetReader() {
        }

        public boolean getFeature(String name) throws SAXNotRecognizedException, SAXNotSupportedException {
            return Boolean.TRUE.equals(this.features.get(name));
        }

        public Object getProperty(String name) throws SAXNotRecognizedException, SAXNotSupportedException {
            return this.properties.get(name);
        }

        public ContentHandler getContentHandler() {
            return this.contentHandler;
        }

        public DTDHandler getDTDHandler() {
            return this.dtdHandler;
        }

        public EntityResolver getEntityResolver() {
            return this.entityResolver;
        }

        public ErrorHandler getErrorHandler() {
            return this.errorHandler;
        }

        public void setFeature(String name, boolean value) throws SAXNotRecognizedException, SAXNotSupportedException {
            if (value) {
                this.features.put(name, Boolean.TRUE);
            } else {
                this.features.remove(name);
            }
        }

        public void setProperty(String name, Object value) throws SAXNotRecognizedException, SAXNotSupportedException {
            if (value == null) {
                this.properties.remove(name);
            } else {
                this.properties.put(name, value);
            }
        }

        public void setContentHandler(ContentHandler handler) {
            this.contentHandler = handler;
        }

        public void setDTDHandler(DTDHandler handler) {
            this.dtdHandler = handler;
        }

        public void setEntityResolver(EntityResolver resolver) {
            this.entityResolver = resolver;
        }

        public void setErrorHandler(ErrorHandler handler) {
            this.errorHandler = handler;
        }

        public void parse(String systemId) throws IOException, SAXException {
            WidgetDocument.this.writeWidget(this.contentHandler);
        }

        public void parse(InputSource input) throws IOException, SAXException {
            WidgetDocument.this.writeWidget(this.contentHandler);
        }
    }
}

