/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.framework.interactions.voice.media;

import java.math.BigDecimal;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Currency;
import java.util.Date;
import java.util.List;
import org.eclipse.vtp.framework.interactions.core.media.Content;
import org.eclipse.vtp.framework.interactions.core.media.DateContent;
import org.eclipse.vtp.framework.interactions.core.media.FormattableContent;
import org.eclipse.vtp.framework.interactions.core.media.IResourceManager;
import org.eclipse.vtp.framework.interactions.core.media.MoneyContent;
import org.eclipse.vtp.framework.interactions.core.media.TextContent;
import org.eclipse.vtp.framework.interactions.voice.media.AudioContent;
import org.eclipse.vtp.framework.interactions.voice.media.VoiceFormatter;

public class SimpleEnglishVoiceFormatter
extends VoiceFormatter {
    private static final Currency USD_CURRENCY = Currency.getInstance("USD");
    private static final String[] months = new String[]{"january", "february", "march", "april", "may", "june", "july", "august", "september", "october", "november", "december"};

    public List formatDate(Date date, String formatDefinition, IResourceManager resourceManager) {
        ArrayList<Object> ret = new ArrayList<Object>();
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        if (formatDefinition == null || formatDefinition.equals("")) {
            TextContent tc = new TextContent();
            tc.setStaticText(String.valueOf(date.toString()) + " ");
            ret.add(tc);
        } else if (formatDefinition.equals("Short Date") || formatDefinition.equals("Default")) {
            ret.addAll(this.formatNumber(cal.get(2) + 1, "Default", resourceManager));
            ret.addAll(this.formatNumber(cal.get(5), "Default", resourceManager));
            ret.addAll(this.formatYear(Integer.toString(cal.get(1)), resourceManager));
        } else if (formatDefinition.equals("Long Date")) {
            ret.add(this.getAudioContent(resourceManager, "/Months/", months[cal.get(2)], months[cal.get(2)]));
            ret.addAll(this.formatNumber(cal.get(5), "Default", resourceManager));
            ret.addAll(this.formatYear(Integer.toString(cal.get(1)), resourceManager));
        } else if (formatDefinition.equals("Short Time")) {
            DateFormat df = DateFormat.getTimeInstance(3);
            TextContent tc = new TextContent();
            tc.setStaticText(df.format(date));
            ret.add(tc);
        } else if (formatDefinition.equals("Long Time")) {
            DateFormat df = DateFormat.getTimeInstance(1);
            TextContent tc = new TextContent();
            tc.setStaticText(df.format(date));
            ret.add(tc);
        } else if (formatDefinition.equals("Short Date Time")) {
            DateFormat df = DateFormat.getDateTimeInstance(3, 3);
            TextContent tc = new TextContent();
            tc.setStaticText(df.format(date));
            ret.add(tc);
        } else if (formatDefinition.equals("Long Date Time")) {
            DateFormat df = DateFormat.getDateTimeInstance(1, 1);
            TextContent tc = new TextContent();
            tc.setStaticText(df.format(date));
            ret.add(tc);
        }
        return ret;
    }

    public List formatDigits(String digits, String formatDefinition, IResourceManager resourceManager) {
        char[] chars = digits.toCharArray();
        ArrayList<AudioContent> ret = new ArrayList<AudioContent>();
        int i = 0;
        while (i < chars.length) {
            if (Character.isDigit(chars[i])) {
                AudioContent ac;
                if (resourceManager.isFileResource("/Digits/" + new String(chars, i, 1) + ".vox")) {
                    ac = new AudioContent();
                    ac.setStaticPath("/Digits/" + new String(chars, i, 1) + ".vox");
                    ret.add(ac);
                } else if (resourceManager.isFileResource("/Digits/" + new String(chars, i, 1) + ".wav")) {
                    ac = new AudioContent();
                    ac.setStaticPath("/Digits/" + new String(chars, i, 1) + ".wav");
                    ret.add(ac);
                } else if (resourceManager.isFileResource("/Digits/" + new String(chars, i, 1) + ".au")) {
                    ac = new AudioContent();
                    ac.setStaticPath("/Digits/" + new String(chars, i, 1) + ".au");
                    ret.add(ac);
                } else {
                    TextContent tc = new TextContent();
                    tc.setStaticText(String.valueOf(new String(chars, i, 1)) + " ");
                    ret.add((AudioContent)tc);
                }
            }
            ++i;
        }
        return ret;
    }

    public List formatLetters(String text, String formatDefinition, IResourceManager resourceManager) {
        char[] chars = text.toCharArray();
        ArrayList<AudioContent> ret = new ArrayList<AudioContent>();
        int i = 0;
        while (i < chars.length) {
            if (Character.isLetterOrDigit(chars[i])) {
                AudioContent ac;
                String prefixPath = "/Letters/";
                if (Character.isDigit(chars[i])) {
                    prefixPath = "/Digits/";
                }
                if (resourceManager.isFileResource(String.valueOf(prefixPath) + new String(chars, i, 1).toUpperCase() + ".vox")) {
                    ac = new AudioContent();
                    ac.setStaticPath(String.valueOf(prefixPath) + new String(chars, i, 1).toUpperCase() + ".vox");
                    ret.add(ac);
                } else if (resourceManager.isFileResource(String.valueOf(prefixPath) + new String(chars, i, 1).toUpperCase() + ".wav")) {
                    ac = new AudioContent();
                    ac.setStaticPath(String.valueOf(prefixPath) + new String(chars, i, 1).toUpperCase() + ".wav");
                    ret.add(ac);
                } else if (resourceManager.isFileResource(String.valueOf(prefixPath) + new String(chars, i, 1).toUpperCase() + ".au")) {
                    ac = new AudioContent();
                    ac.setStaticPath(String.valueOf(prefixPath) + new String(chars, i, 1).toUpperCase() + ".au");
                    ret.add(ac);
                } else {
                    TextContent tc = new TextContent();
                    tc.setStaticText(String.valueOf(new String(chars, i, 1)) + " ");
                    ret.add((AudioContent)tc);
                }
            }
            ++i;
        }
        return ret;
    }

    public List formatMoney(BigDecimal money, Currency currency, String formatDefinition, IResourceManager resourceManager) {
        ArrayList<Content> ret = new ArrayList<Content>();
        money = money.setScale(2, 1);
        if (USD_CURRENCY.equals(currency)) {
            int cents;
            if (money.compareTo(ZERO) < 0) {
                ret.add(this.getAudioContent(resourceManager, "/Common/", "negative", "negative"));
                money = money.multiply(NEGATIVE_ONE);
            }
            List dollarList = this.formatNumber(money.intValue(), "Default", resourceManager);
            ret.addAll(dollarList);
            if (money.intValue() == 1 || formatDefinition.equals("Force Singular")) {
                ret.add(this.getAudioContent(resourceManager, "/Common/", "dollar", "dollar"));
            } else {
                ret.add(this.getAudioContent(resourceManager, "/Common/", "dollars", "dollars"));
            }
            String str = money.toString();
            if (str.indexOf(46) >= 0 && (cents = Integer.parseInt(str.substring(str.indexOf(46) + 1))) > 0) {
                ret.add(this.getAudioContent(resourceManager, "/Common/", "and", "and"));
                List centsList = this.formatNumber(cents, "Default", resourceManager);
                ret.addAll(centsList);
                if (cents == 1 || formatDefinition.equals("Force Singular")) {
                    ret.add(this.getAudioContent(resourceManager, "/Common/", "cent", "cent"));
                } else {
                    ret.add(this.getAudioContent(resourceManager, "/Common/", "cents", "cents"));
                }
            }
        }
        return ret;
    }

    public List formatNumber(int number, String formatDefinition, IResourceManager resourceManager) {
        int thousands;
        int millions;
        int billions;
        ArrayList<Content> ret = new ArrayList<Content>();
        if (number == 0) {
            ret.add(this.getAudioContent(resourceManager, "/Digits/", "0", "0"));
            return ret;
        }
        if (number < 0) {
            ret.add(this.getAudioContent(resourceManager, "/Common/", "negative", "negative"));
            number *= -1;
        }
        if ((billions = number / 1000000000) > 0) {
            this.translateNumberInHundreds(resourceManager, billions, ret);
            ret.add(this.getAudioContent(resourceManager, "/Common/", "billion", "billion"));
            number -= billions * 1000000000;
        }
        if ((millions = number / 1000000) > 0) {
            this.translateNumberInHundreds(resourceManager, millions, ret);
            ret.add(this.getAudioContent(resourceManager, "/Common/", "million", "million"));
            number -= millions * 1000000;
        }
        if ((thousands = number / 1000) > 0) {
            this.translateNumberInHundreds(resourceManager, thousands, ret);
            ret.add(this.getAudioContent(resourceManager, "/Common/", "thousand", "thousand"));
            number -= thousands * 1000;
        }
        this.translateNumberInHundreds(resourceManager, number % 1000, ret);
        return ret;
    }

    private void translateNumberInHundreds(IResourceManager resourceManager, int number, List content) {
        int hundreds = number / 100;
        if (hundreds > 0) {
            content.add(this.getAudioContent(resourceManager, "/Digits/", String.valueOf(hundreds), String.valueOf(hundreds)));
            content.add(this.getAudioContent(resourceManager, "/Common/", "hundred", "hundred"));
            number -= hundreds * 100;
        }
        if (number > 19) {
            content.add(this.getAudioContent(resourceManager, "/Digits/", String.valueOf(number - number % 10), String.valueOf(number - number % 10)));
            number %= 10;
        }
        if (number > 0) {
            content.add(this.getAudioContent(resourceManager, "/Digits/", String.valueOf(number), String.valueOf(number)));
        }
    }

    public List formatOrdinal(int ordinal, String formatDefinition, IResourceManager resourceManager) {
        int hundreds;
        int thousands;
        int millions;
        int billions;
        ArrayList<Content> ret = new ArrayList<Content>();
        if (ordinal == 0) {
            ret.add(this.getAudioContent(resourceManager, "/Ordinals/", "0th", "zeroth"));
            return ret;
        }
        if (ordinal < 0) {
            ret.add(this.getAudioContent(resourceManager, "/Common/", "negative", "negative"));
            ordinal *= -1;
        }
        if ((billions = ordinal / 1000000000) > 0) {
            this.translateNumberInHundreds(resourceManager, billions, ret);
            if ((ordinal -= billions * 1000000000) == 0) {
                ret.add(this.getAudioContent(resourceManager, "/Common/", "billionth", "billionth"));
            } else {
                ret.add(this.getAudioContent(resourceManager, "/Common/", "billion", "billion"));
            }
        }
        if ((millions = ordinal / 1000000) > 0) {
            this.translateNumberInHundreds(resourceManager, millions, ret);
            if ((ordinal -= millions * 1000000) == 0) {
                ret.add(this.getAudioContent(resourceManager, "/Common/", "millionth", "millionth"));
            } else {
                ret.add(this.getAudioContent(resourceManager, "/Common/", "million", "million"));
            }
        }
        if ((thousands = ordinal / 1000) > 0) {
            this.translateNumberInHundreds(resourceManager, thousands, ret);
            if ((ordinal -= thousands * 1000) == 0) {
                ret.add(this.getAudioContent(resourceManager, "/Common/", "thousandth", "thousandth"));
            } else {
                ret.add(this.getAudioContent(resourceManager, "/Common/", "thousand", "thousand"));
            }
        }
        if ((hundreds = ordinal / 100) > 0) {
            this.translateNumberInHundreds(resourceManager, hundreds, ret);
            if ((ordinal -= hundreds * 100) == 0) {
                ret.add(this.getAudioContent(resourceManager, "/Common/", "hundredth", "hundredth"));
            } else {
                ret.add(this.getAudioContent(resourceManager, "/Common/", "hundred", "hundred"));
            }
        }
        if (ordinal % 10 == 0) {
            ret.add(this.getAudioContent(resourceManager, "/Ordinals/", String.valueOf(String.valueOf(ordinal)) + "th", String.valueOf(String.valueOf(ordinal)) + "th"));
        } else {
            int tens = ordinal / 10;
            if (tens > 1) {
                this.translateNumberInHundreds(resourceManager, tens * 10, ret);
                ordinal -= tens * 10;
            }
            switch (ordinal) {
                case 1: {
                    ret.add(this.getAudioContent(resourceManager, "/Ordinals/", "1st", "1st"));
                    break;
                }
                case 2: {
                    ret.add(this.getAudioContent(resourceManager, "/Ordinals/", "2nd", "2nd"));
                    break;
                }
                case 3: {
                    ret.add(this.getAudioContent(resourceManager, "/Ordinals/", "3rd", "3rd"));
                    break;
                }
                default: {
                    ret.add(this.getAudioContent(resourceManager, "/Ordinals/", String.valueOf(String.valueOf(ordinal)) + "th", String.valueOf(String.valueOf(ordinal)) + "th"));
                }
            }
        }
        return ret;
    }

    private List formatYear(String year, IResourceManager resourceManager) {
        ArrayList<Object> ret = new ArrayList<Object>();
        if (year.length() != 4) {
            TextContent tc = new TextContent();
            tc.setStaticText(year);
            ret.add(tc);
        } else {
            int century = Integer.parseInt(year.substring(0, 2));
            int tens = Integer.parseInt(year.substring(2));
            if (century < 10) {
                ret.addAll(this.formatNumber(tens == 0 || tens > 9 ? century * 100 : century, "default", resourceManager));
            } else if (century < 13) {
                ret.addAll(this.formatNumber(century, "defualt", resourceManager));
                ret.add(this.getAudioContent(resourceManager, "/Common/", "hundred", "hundred"));
            } else if (century % 10 == 0) {
                ret.addAll(this.formatNumber(century * 100, "default", resourceManager));
            } else {
                ret.addAll(this.formatNumber(century, "default", resourceManager));
            }
            if (century % 10 == 0) {
                if (tens > 0 && tens < 10) {
                    ret.addAll(this.formatNumber(tens, "default", resourceManager));
                } else {
                    ret.addAll(this.formatNumber(tens, "default", resourceManager));
                }
            } else if (tens > 0 && tens < 10) {
                ret.add(this.getAudioContent(resourceManager, "/Common/", "oh", "oh"));
                ret.addAll(this.formatNumber(tens, "default", resourceManager));
            } else {
                ret.addAll(this.formatNumber(tens, "default", resourceManager));
            }
        }
        return ret;
    }

    public String getLanguageCode() {
        return "en";
    }

    public String getLanguageName() {
        return "English";
    }

    public List getDefaultFormats(FormattableContent formattable) {
        ArrayList<String> ret = new ArrayList<String>();
        if (formattable instanceof DateContent) {
            ret.add("Short Date");
            ret.add("Long Date");
            ret.add("Short Time");
            ret.add("Long Time");
            ret.add("Short Date Time");
            ret.add("Long Date Time");
        } else if (formattable instanceof MoneyContent) {
            ret.add("Force Singular");
        }
        return ret;
    }
}

