/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.framework.interactions.voice.services;

import java.io.IOException;
import java.math.BigDecimal;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.vtp.framework.interactions.core.commands.BridgeMessageCommand;
import org.eclipse.vtp.framework.interactions.core.commands.DataRequestCommand;
import org.eclipse.vtp.framework.interactions.core.commands.EndMessageCommand;
import org.eclipse.vtp.framework.interactions.core.commands.ExternalReferenceCommand;
import org.eclipse.vtp.framework.interactions.core.commands.FinalCommand;
import org.eclipse.vtp.framework.interactions.core.commands.InitialCommand;
import org.eclipse.vtp.framework.interactions.core.commands.InputRequestCommand;
import org.eclipse.vtp.framework.interactions.core.commands.OutputMessageCommand;
import org.eclipse.vtp.framework.interactions.core.commands.SelectionRequestCommand;
import org.eclipse.vtp.framework.interactions.core.commands.TransferMessageCommand;
import org.eclipse.vtp.framework.interactions.core.platforms.IDocument;
import org.eclipse.vtp.framework.interactions.core.platforms.ILink;
import org.eclipse.vtp.framework.interactions.core.platforms.ILinkFactory;
import org.eclipse.vtp.framework.interactions.core.support.AbstractPlatform;
import org.eclipse.vtp.framework.interactions.voice.vxml.Assignment;
import org.eclipse.vtp.framework.interactions.voice.vxml.AudioOutput;
import org.eclipse.vtp.framework.interactions.voice.vxml.Block;
import org.eclipse.vtp.framework.interactions.voice.vxml.Catch;
import org.eclipse.vtp.framework.interactions.voice.vxml.Choice;
import org.eclipse.vtp.framework.interactions.voice.vxml.Dialog;
import org.eclipse.vtp.framework.interactions.voice.vxml.Disconnect;
import org.eclipse.vtp.framework.interactions.voice.vxml.Else;
import org.eclipse.vtp.framework.interactions.voice.vxml.ElseIf;
import org.eclipse.vtp.framework.interactions.voice.vxml.ExternalGrammar;
import org.eclipse.vtp.framework.interactions.voice.vxml.Field;
import org.eclipse.vtp.framework.interactions.voice.vxml.Filled;
import org.eclipse.vtp.framework.interactions.voice.vxml.Form;
import org.eclipse.vtp.framework.interactions.voice.vxml.Goto;
import org.eclipse.vtp.framework.interactions.voice.vxml.If;
import org.eclipse.vtp.framework.interactions.voice.vxml.Menu;
import org.eclipse.vtp.framework.interactions.voice.vxml.NoInput;
import org.eclipse.vtp.framework.interactions.voice.vxml.NoMatch;
import org.eclipse.vtp.framework.interactions.voice.vxml.OutputSet;
import org.eclipse.vtp.framework.interactions.voice.vxml.Parameter;
import org.eclipse.vtp.framework.interactions.voice.vxml.Prompt;
import org.eclipse.vtp.framework.interactions.voice.vxml.Recording;
import org.eclipse.vtp.framework.interactions.voice.vxml.Return;
import org.eclipse.vtp.framework.interactions.voice.vxml.Subdialog;
import org.eclipse.vtp.framework.interactions.voice.vxml.Submit;
import org.eclipse.vtp.framework.interactions.voice.vxml.TextOutput;
import org.eclipse.vtp.framework.interactions.voice.vxml.Transfer;
import org.eclipse.vtp.framework.interactions.voice.vxml.VXMLConstants;
import org.eclipse.vtp.framework.interactions.voice.vxml.VXMLDocument;
import org.eclipse.vtp.framework.interactions.voice.vxml.Variable;

public class VoicePlatform
extends AbstractPlatform
implements VXMLConstants {
    private static final BigDecimal ONE_HUNDRED = new BigDecimal("100");
    private static final BigDecimal TEN = new BigDecimal("10");
    protected static final String VXML_BUILTIN_PREFIX = "VXML:Builtin:";

    protected VXMLDocument createVXMLDocument(ILinkFactory links, Dialog dialog) {
        VXMLDocument document = new VXMLDocument();
        document.addDialog(dialog);
        Catch hangupCatch = new Catch("connection.disconnect.hangup");
        hangupCatch.addAction(new Goto(links.createAbortLink().toString()));
        document.addEventHandler(hangupCatch);
        try {
            document.writeWidget(System.err);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return document;
    }

    protected IDocument renderOutputMessage(ILinkFactory links, OutputMessageCommand outputMessageCommand) {
        String bargeIn = outputMessageCommand.getPropertyValue("barge-in");
        bargeIn = Boolean.TRUE.toString().equalsIgnoreCase(bargeIn) ? Boolean.TRUE.toString() : (Boolean.FALSE.toString().equalsIgnoreCase(bargeIn) ? Boolean.FALSE.toString() : null);
        Form form = new Form("OutputMessageForm");
        if (bargeIn != null) {
            form.setProperty("bargein", bargeIn);
        }
        Block block = new Block("OutputMessageBlock");
        OutputSet outputs = new OutputSet();
        int i = 0;
        while (i < outputMessageCommand.getOutputCount()) {
            switch (outputMessageCommand.getOutputType(i)) {
                case 1: {
                    outputs.addOutput(new AudioOutput(links.createResourceLink(outputMessageCommand.getOutputValue(i)).toString()));
                    break;
                }
                case 2: {
                    outputs.addOutput(new TextOutput(outputMessageCommand.getOutputValue(i)));
                }
            }
            ++i;
        }
        Prompt prompt = new Prompt(outputs);
        if (bargeIn != null) {
            prompt.setBargeInEnabled(Boolean.valueOf(bargeIn));
        }
        block.addAction(prompt);
        ILink nextLink = links.createNextLink();
        String[] parameterNames = outputMessageCommand.getParameterNames();
        int i2 = 0;
        while (i2 < parameterNames.length) {
            nextLink.setParameters(parameterNames[i2], outputMessageCommand.getParameterValues(parameterNames[i2]));
            ++i2;
        }
        block.addAction(new Goto(nextLink.toString()));
        form.addFormElement(block);
        return this.createVXMLDocument(links, form);
    }

    protected IDocument renderInitialDocument(ILinkFactory links, InitialCommand initialCommand) {
        VXMLDocument document = new VXMLDocument();
        Form form = new Form("InitialForm");
        form.addVariable(new Variable("ANI", ""));
        form.addVariable(new Variable("DNIS", ""));
        String[] variables = initialCommand.getVariableNames();
        int i = 0;
        while (i < variables.length) {
            String value = initialCommand.getVariableValue(variables[i]);
            if (value == null) {
                value = "";
            }
            form.addVariable(new Variable(variables[i], "'" + value + "'"));
            ++i;
        }
        Block block = new Block("InitialBlock");
        LinkedHashMap varMap = new LinkedHashMap();
        this.generateInitialVariableRequests(varMap);
        for (String key : varMap.keySet()) {
            block.addAction(new Assignment(key, (String)varMap.get(key)));
        }
        ILink nextLink = links.createNextLink();
        String[] parameterNames = initialCommand.getParameterNames();
        int i2 = 0;
        while (i2 < parameterNames.length) {
            nextLink.setParameters(parameterNames[i2], initialCommand.getParameterValues(parameterNames[i2]));
            ++i2;
        }
        nextLink.setParameter(initialCommand.getResultName(), initialCommand.getResultValue());
        String[] fields = new String[varMap.size() + variables.length];
        int j = 0;
        Iterator i3 = varMap.keySet().iterator();
        while (i3.hasNext()) {
            fields[j] = (String)i3.next();
            ++j;
        }
        System.arraycopy(variables, 0, fields, varMap.size(), variables.length);
        block.addAction(new Submit(nextLink.toString(), fields));
        form.addFormElement(block);
        document.addDialog(form);
        return document;
    }

    protected void generateInitialVariableRequests(Map variables) {
        variables.put("ANI", "session.connection.remote.uri");
        variables.put("DNIS", "session.connection.local.uri");
    }

    protected IDocument renderInputRequest(ILinkFactory links, InputRequestCommand inputRequestCommand) {
        String customData;
        Form form = new Form("InputRequestForm");
        String bargeIn = inputRequestCommand.getPropertyValue("barge-in");
        bargeIn = Boolean.TRUE.toString().equalsIgnoreCase(bargeIn) ? Boolean.TRUE.toString() : (Boolean.FALSE.toString().equalsIgnoreCase(bargeIn) ? Boolean.FALSE.toString() : null);
        String timeout = inputRequestCommand.getPropertyValue("initial-timeout");
        String inputMode = inputRequestCommand.getPropertyValue("input-mode");
        if (inputMode == null || inputMode.length() == 0) {
            inputMode = "dtmf only";
        }
        String confidenceLevel = inputRequestCommand.getPropertyValue("confidence-level");
        String sensitivity = inputRequestCommand.getPropertyValue("sensitivity-level");
        String speedVsAccuracy = inputRequestCommand.getPropertyValue("speed-vs-accuracy");
        String speechCompletionTimeout = inputRequestCommand.getPropertyValue("speech-complete-timeout");
        String speechIncompleteTimeout = inputRequestCommand.getPropertyValue("speech-incomplete-timeout");
        String maxSpeechLength = inputRequestCommand.getPropertyValue("max-speech-timeout");
        String maxNBest = inputRequestCommand.getPropertyValue("max-n-best");
        String interDigitTimeout = inputRequestCommand.getPropertyValue("interdigit-timeout");
        String terminationTimeout = inputRequestCommand.getPropertyValue("termination-timeout");
        String terminationCharacter = inputRequestCommand.getPropertyValue("termination-character");
        String grammarMode = "voice";
        Field field = new Field(inputRequestCommand.getDataName());
        if (bargeIn != null) {
            field.setProperty("bargein", bargeIn);
        }
        if (timeout != null && timeout.length() > 0) {
            field.setProperty("timeout", String.valueOf(timeout) + "s");
        }
        if ("hybrid".equalsIgnoreCase(inputMode)) {
            field.setProperty("inputmodes", "dtmf voice");
            field.setProperty("com.telera.speechenabled", Boolean.TRUE.toString());
        }
        if ("dtmf only".equalsIgnoreCase(inputMode)) {
            grammarMode = "dtmf";
            field.setProperty("inputmodes", "dtmf");
            field.setProperty("com.telera.speechenabled", Boolean.FALSE.toString());
        } else {
            try {
                if (confidenceLevel != null && confidenceLevel.length() > 0) {
                    field.setProperty("confidencelevel", new BigDecimal(confidenceLevel).divide(ONE_HUNDRED).toString());
                }
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
            }
            try {
                if (sensitivity != null && sensitivity.length() > 0) {
                    field.setProperty("sensitivity", new BigDecimal(sensitivity).divide(ONE_HUNDRED).toString());
                }
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
            }
            try {
                if (speedVsAccuracy != null && speedVsAccuracy.length() > 0) {
                    field.setProperty("speedvsaccuracy", new BigDecimal(speedVsAccuracy).divide(ONE_HUNDRED).toString());
                }
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
            }
            if (speechCompletionTimeout != null && speechCompletionTimeout.length() > 0) {
                field.setProperty("completetimeout", String.valueOf(speechCompletionTimeout) + "s");
            }
            if (speechIncompleteTimeout != null && speechIncompleteTimeout.length() > 0) {
                field.setProperty("incompletetimeout", String.valueOf(speechIncompleteTimeout) + "s");
            }
            if (maxSpeechLength != null && maxSpeechLength.length() > 0) {
                field.setProperty("maxspeechtimeout", String.valueOf(maxSpeechLength) + "s");
            } else {
                field.setProperty("maxspeechtimeout", "10s");
            }
            if (maxNBest != null && maxNBest.length() > 0) {
                field.setProperty("maxnbest", maxNBest);
            }
        }
        if ("voice only".equalsIgnoreCase(inputMode)) {
            field.setProperty("inputmodes", "voice");
            field.setProperty("com.telera.speechenabled", Boolean.TRUE.toString());
        } else {
            if (interDigitTimeout != null && interDigitTimeout.length() > 0) {
                field.setProperty("interdigittimeout", String.valueOf(interDigitTimeout) + "s");
            }
            if (terminationTimeout != null && terminationTimeout.length() > 0) {
                field.setProperty("termtimeout", String.valueOf(terminationTimeout) + "s");
            }
            if (terminationCharacter != null && terminationCharacter.length() > 0 && !"none".equalsIgnoreCase(terminationCharacter)) {
                field.setProperty("termchar", terminationCharacter);
            } else {
                field.setProperty("termchar", String.valueOf('D'));
            }
        }
        OutputSet outputs = new OutputSet();
        int i = 0;
        while (i < inputRequestCommand.getOutputCount()) {
            switch (inputRequestCommand.getOutputType(i)) {
                case 1: {
                    outputs.addOutput(new AudioOutput(links.createResourceLink(inputRequestCommand.getOutputValue(i)).toString()));
                    break;
                }
                case 2: {
                    outputs.addOutput(new TextOutput(inputRequestCommand.getOutputValue(i)));
                }
            }
            ++i;
        }
        Prompt prompt = new Prompt(outputs);
        if (bargeIn != null) {
            prompt.setBargeInEnabled(Boolean.valueOf(bargeIn));
        }
        field.setPrompt(prompt);
        if (inputRequestCommand.getInputValue() != null) {
            switch (inputRequestCommand.getInputType()) {
                case 1: {
                    field.addGrammar(new ExternalGrammar(grammarMode, links.createResourceLink(inputRequestCommand.getInputValue()).toString()));
                    break;
                }
                case 0x7FFFFFFF: {
                    customData = inputRequestCommand.getInputValue();
                    if (customData == null || !customData.startsWith(VXML_BUILTIN_PREFIX)) break;
                    field.setType(customData.substring(VXML_BUILTIN_PREFIX.length()));
                }
            }
        }
        if (inputRequestCommand.getInput2Value() != null) {
            switch (inputRequestCommand.getInput2Type()) {
                case 1: {
                    field.addGrammar(new ExternalGrammar(grammarMode, links.createResourceLink(inputRequestCommand.getInput2Value()).toString()));
                    break;
                }
                case 0x7FFFFFFF: {
                    customData = inputRequestCommand.getInput2Value();
                    if (customData == null || !customData.startsWith(VXML_BUILTIN_PREFIX)) break;
                    field.setType(customData.substring(VXML_BUILTIN_PREFIX.length()));
                }
            }
        }
        String[] parameterNames = inputRequestCommand.getParameterNames();
        ILink filledLink = links.createNextLink();
        int i2 = 0;
        while (i2 < parameterNames.length) {
            filledLink.setParameters(parameterNames[i2], inputRequestCommand.getParameterValues(parameterNames[i2]));
            ++i2;
        }
        filledLink.setParameter(inputRequestCommand.getResultName(), inputRequestCommand.getFilledResultValue());
        Filled filled = new Filled();
        filled.addAction(new Submit(filledLink.toString(), new String[]{inputRequestCommand.getDataName()}));
        field.addFilledHandler(filled);
        ILink noInputLink = links.createNextLink();
        int i3 = 0;
        while (i3 < parameterNames.length) {
            noInputLink.setParameters(parameterNames[i3], inputRequestCommand.getParameterValues(parameterNames[i3]));
            ++i3;
        }
        noInputLink.setParameter(inputRequestCommand.getResultName(), inputRequestCommand.getNoInputResultValue());
        NoInput noInput = new NoInput();
        noInput.addAction(new Submit(noInputLink.toString(), new String[]{inputRequestCommand.getDataName()}));
        field.addEventHandler(noInput);
        ILink noMatchLink = links.createNextLink();
        int i4 = 0;
        while (i4 < parameterNames.length) {
            noMatchLink.setParameters(parameterNames[i4], inputRequestCommand.getParameterValues(parameterNames[i4]));
            ++i4;
        }
        noMatchLink.setParameter(inputRequestCommand.getResultName(), inputRequestCommand.getNoMatchResultValue());
        NoMatch noMatch = new NoMatch();
        noMatch.addAction(new Submit(noMatchLink.toString(), new String[]{inputRequestCommand.getDataName()}));
        field.addEventHandler(noMatch);
        form.addFormElement(field);
        return this.createVXMLDocument(links, form);
    }

    protected IDocument renderSelectionRequest(ILinkFactory links, SelectionRequestCommand selectionRequestCommand) {
        String bargeIn = this.getNormalizedBoolean(selectionRequestCommand.getPropertyValue("barge-in"));
        String timeout = selectionRequestCommand.getPropertyValue("initial-timeout");
        String inputMode = selectionRequestCommand.getPropertyValue("input-mode");
        if (inputMode == null || inputMode.length() == 0) {
            inputMode = "dtmf only";
        }
        String confidenceLevel = selectionRequestCommand.getPropertyValue("confidence-level");
        String sensitivity = selectionRequestCommand.getPropertyValue("sensitivity-level");
        String speedVsAccuracy = selectionRequestCommand.getPropertyValue("speed-vs-accuracy");
        String speechCompletionTimeout = selectionRequestCommand.getPropertyValue("speech-complete-timeout");
        String speechIncompleteTimeout = selectionRequestCommand.getPropertyValue("speech-incomplete-timeout");
        String maxSpeechLength = selectionRequestCommand.getPropertyValue("max-speech-timeout");
        String maxNBest = selectionRequestCommand.getPropertyValue("max-n-best");
        String interDigitTimeout = selectionRequestCommand.getPropertyValue("interdigit-timeout");
        String terminationTimeout = selectionRequestCommand.getPropertyValue("termination-timeout");
        String terminationCharacter = selectionRequestCommand.getPropertyValue("termination-character");
        String grammarMode = null;
        OutputSet outputs = new OutputSet();
        int i = 0;
        while (i < selectionRequestCommand.getOutputCount()) {
            switch (selectionRequestCommand.getOutputType(i)) {
                case 1: {
                    outputs.addOutput(new AudioOutput(links.createResourceLink(selectionRequestCommand.getOutputValue(i)).toString()));
                    break;
                }
                case 2: {
                    outputs.addOutput(new TextOutput(selectionRequestCommand.getOutputValue(i)));
                }
            }
            ++i;
        }
        Prompt prompt = new Prompt(outputs);
        if (bargeIn != null) {
            prompt.setBargeInEnabled(Boolean.valueOf(bargeIn));
        }
        Menu menu = new Menu(selectionRequestCommand.getSelectionName(), prompt);
        if (bargeIn != null) {
            menu.setProperty("bargein", bargeIn);
        }
        if (timeout != null && timeout.length() > 0) {
            menu.setProperty("timeout", String.valueOf(timeout) + "s");
        }
        if ("hybrid".equalsIgnoreCase(inputMode)) {
            menu.setProperty("inputmodes", "dtmf voice");
            menu.setProperty("com.telera.speechenabled", Boolean.TRUE.toString());
        }
        if ("dtmf only".equalsIgnoreCase(inputMode)) {
            grammarMode = "dtmf";
            menu.setProperty("inputmodes", "dtmf");
            menu.setProperty("com.telera.speechenabled", Boolean.FALSE.toString());
        } else {
            try {
                if (confidenceLevel != null && confidenceLevel.length() > 0) {
                    menu.setProperty("confidencelevel", new BigDecimal(confidenceLevel).divide(ONE_HUNDRED).toString());
                }
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
            }
            try {
                if (sensitivity != null && sensitivity.length() > 0) {
                    menu.setProperty("sensitivity", new BigDecimal(sensitivity).divide(ONE_HUNDRED).toString());
                }
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
            }
            try {
                if (speedVsAccuracy != null && speedVsAccuracy.length() > 0) {
                    menu.setProperty("speedvsaccuracy", new BigDecimal(speedVsAccuracy).divide(ONE_HUNDRED).toString());
                }
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
            }
            if (speechCompletionTimeout != null && speechCompletionTimeout.length() > 0) {
                menu.setProperty("completetimeout", String.valueOf(speechCompletionTimeout) + "s");
            }
            if (speechIncompleteTimeout != null && speechIncompleteTimeout.length() > 0) {
                menu.setProperty("incompletetimeout", String.valueOf(speechIncompleteTimeout) + "s");
            }
            if (maxSpeechLength != null && maxSpeechLength.length() > 0) {
                menu.setProperty("maxspeechtimeout", String.valueOf(maxSpeechLength) + "s");
            } else {
                menu.setProperty("maxspeechtimeout", "10s");
            }
            if (maxNBest != null && maxNBest.length() > 0) {
                menu.setProperty("maxnbest", maxNBest);
            }
        }
        if ("voice only".equalsIgnoreCase(inputMode)) {
            grammarMode = "voice";
            menu.setProperty("inputmodes", "voice");
            menu.setProperty("com.telera.speechenabled", Boolean.TRUE.toString());
        } else {
            if (interDigitTimeout != null && interDigitTimeout.length() > 0) {
                menu.setProperty("interdigittimeout", String.valueOf(interDigitTimeout) + "s");
            }
            if (terminationTimeout != null && terminationTimeout.length() > 0) {
                menu.setProperty("termtimeout", String.valueOf(terminationTimeout) + "s");
            }
            if (terminationCharacter != null && terminationCharacter.length() > 0 && !"none".equalsIgnoreCase(terminationCharacter)) {
                menu.setProperty("termchar", terminationCharacter);
            } else {
                menu.setProperty("termchar", "");
            }
        }
        ILink nextLink = links.createNextLink();
        String[] parameterNames = selectionRequestCommand.getParameterNames();
        int i2 = 0;
        while (i2 < parameterNames.length) {
            nextLink.setParameters(parameterNames[i2], selectionRequestCommand.getParameterValues(parameterNames[i2]));
            ++i2;
        }
        nextLink.setParameter(selectionRequestCommand.getResultName(), selectionRequestCommand.getFilledResultValue());
        i2 = 0;
        while (i2 < selectionRequestCommand.getOptionCount()) {
            String silent = selectionRequestCommand.getOptionProperty(i2, "silent");
            silent = Boolean.TRUE.toString().equalsIgnoreCase(silent) ? Boolean.TRUE.toString() : (Boolean.FALSE.toString().equalsIgnoreCase(silent) ? Boolean.FALSE.toString() : null);
            String dtmf = selectionRequestCommand.getOptionProperty(i2, "dtmf");
            if (!Boolean.TRUE.toString().equals(silent)) {
                int j = 0;
                while (j < selectionRequestCommand.getOptionOutputCount(i2)) {
                    switch (selectionRequestCommand.getOptionOutputType(i2, j)) {
                        case 1: {
                            outputs.addOutput(new AudioOutput(links.createResourceLink(selectionRequestCommand.getOptionOutputValue(i2, j)).toString()));
                            break;
                        }
                        case 2: {
                            outputs.addOutput(new TextOutput(selectionRequestCommand.getOptionOutputValue(i2, j)));
                        }
                    }
                    ++j;
                }
            }
            nextLink.setParameter(selectionRequestCommand.getSelectionName(), selectionRequestCommand.getOption(i2));
            Choice choice = new Choice(nextLink.toString());
            if (!"dtmf".equals(grammarMode)) {
                switch (selectionRequestCommand.getOptionInputType(i2)) {
                    case 1: {
                        choice.setGrammar(new ExternalGrammar("voice", links.createResourceLink(selectionRequestCommand.getOptionInputValue(i2)).toString()));
                    }
                }
            }
            if (!"voice".equals(grammarMode)) {
                choice.setDTMF(dtmf == null ? "0" : dtmf);
            }
            menu.addChoice(choice);
            ++i2;
        }
        NoInput noInput = new NoInput();
        nextLink.setParameter(selectionRequestCommand.getResultName(), selectionRequestCommand.getNoInputResultValue());
        nextLink.setParameter(selectionRequestCommand.getSelectionName(), null);
        noInput.addAction(new Goto(nextLink.toString()));
        menu.addEventHandler(noInput);
        NoMatch noMatch = new NoMatch();
        nextLink.setParameter(selectionRequestCommand.getResultName(), selectionRequestCommand.getNoMatchResultValue());
        nextLink.setParameter(selectionRequestCommand.getSelectionName(), null);
        noMatch.addAction(new Goto(nextLink.toString()));
        menu.addEventHandler(noMatch);
        return this.createVXMLDocument(links, menu);
    }

    protected IDocument renderDataRequest(ILinkFactory links, DataRequestCommand dataRequestCommand) {
        Form form = new Form("DataRequestForm");
        String bargeIn = this.getNormalizedBoolean(dataRequestCommand.getPropertyValue("barge-in"));
        String playBeep = this.getNormalizedBoolean(dataRequestCommand.getPropertyValue("play-beep"));
        String dtmfTerm = this.getNormalizedBoolean(dataRequestCommand.getPropertyValue("dtmf-termination"));
        String initialTimeout = dataRequestCommand.getPropertyValue("initial-timeout");
        String finalSilence = dataRequestCommand.getPropertyValue("final-silence-timeout");
        String maxRecordTime = dataRequestCommand.getPropertyValue("max-record-time");
        Recording recording = new Recording(dataRequestCommand.getDataName());
        recording.setFileType("audio/x-wav");
        recording.setProperty("inputmodes", "dtmf");
        if (playBeep != null) {
            recording.setBeepEnabled(Boolean.valueOf(playBeep));
        }
        if (dtmfTerm != null) {
            recording.setDtmfTermEnabled(Boolean.valueOf(dtmfTerm));
        }
        if (initialTimeout != null && initialTimeout.length() > 0) {
            recording.setTimeout(String.valueOf(initialTimeout) + "s");
        }
        if (finalSilence != null && finalSilence.length() > 0) {
            recording.setFinalSilence(String.valueOf(finalSilence) + "s");
        }
        if (maxRecordTime != null && maxRecordTime.length() > 0) {
            recording.setMaxtime(String.valueOf(maxRecordTime) + "s");
        } else {
            recording.setMaxtime("10s");
        }
        OutputSet outputs = new OutputSet();
        int i = 0;
        while (i < dataRequestCommand.getOutputCount()) {
            switch (dataRequestCommand.getOutputType(i)) {
                case 1: {
                    outputs.addOutput(new AudioOutput(links.createResourceLink(dataRequestCommand.getOutputValue(i)).toString()));
                    break;
                }
                case 2: {
                    outputs.addOutput(new TextOutput(dataRequestCommand.getOutputValue(i)));
                }
            }
            ++i;
        }
        Prompt prompt = new Prompt(outputs);
        if (bargeIn != null) {
            prompt.setBargeInEnabled(Boolean.valueOf(bargeIn));
        }
        recording.setPrompt(prompt);
        String[] parameterNames = dataRequestCommand.getParameterNames();
        String[] submitVars = new String[parameterNames.length + 2];
        submitVars[0] = dataRequestCommand.getDataName();
        submitVars[1] = dataRequestCommand.getResultName();
        Filled filled = new Filled();
        filled.addVariable(new Variable(dataRequestCommand.getResultName(), "'" + dataRequestCommand.getFilledResultValue() + "'"));
        int i2 = 0;
        while (i2 < parameterNames.length) {
            submitVars[i2 + 2] = parameterNames[i2];
            String[] values = dataRequestCommand.getParameterValues(parameterNames[i2]);
            StringBuffer buf = new StringBuffer();
            int v = 0;
            while (v < values.length) {
                buf.append(values[v]);
                if (v < values.length - 1) {
                    buf.append(',');
                }
                ++v;
            }
            Variable paramVar = new Variable(parameterNames[i2], "'" + buf.toString() + "'");
            filled.addVariable(paramVar);
            ++i2;
        }
        ILink filledLink = links.createNextLink();
        Submit submit = new Submit(filledLink.toString(), submitVars);
        submit.setMethod("post");
        submit.setEncodingType("multipart/form-data");
        filled.addAction(submit);
        recording.addFilledHandler(filled);
        ILink noInputLink = links.createNextLink();
        int i3 = 0;
        while (i3 < parameterNames.length) {
            noInputLink.setParameters(parameterNames[i3], dataRequestCommand.getParameterValues(parameterNames[i3]));
            ++i3;
        }
        noInputLink.setParameter(dataRequestCommand.getResultName(), dataRequestCommand.getNoInputResultValue());
        NoInput noInput = new NoInput();
        noInput.addAction(new Submit(noInputLink.toString(), new String[]{dataRequestCommand.getDataName()}));
        recording.addEventHandler(noInput);
        form.addFormElement(recording);
        return this.createVXMLDocument(links, form);
    }

    protected IDocument renderExternalReference(ILinkFactory links, ExternalReferenceCommand externalReferenceCommand) {
        Form form = new Form("ExternalReferenceForm");
        Subdialog subdialog = new Subdialog(externalReferenceCommand.getReferenceName());
        subdialog.setSourceURI(externalReferenceCommand.getReferenceURI());
        String[] inputArgNames = externalReferenceCommand.getInputArgumentNames();
        int i = 0;
        while (i < inputArgNames.length) {
            subdialog.addParameter(new Parameter(inputArgNames[i], externalReferenceCommand.getInputArgumentValue(inputArgNames[i])));
            ++i;
        }
        ILink nextLink = links.createNextLink();
        String[] parameterNames = externalReferenceCommand.getParameterNames();
        int i2 = 0;
        while (i2 < parameterNames.length) {
            nextLink.setParameters(parameterNames[i2], externalReferenceCommand.getParameterValues(parameterNames[i2]));
            ++i2;
        }
        Filled filled = new Filled();
        String[] outputArgNames = externalReferenceCommand.getOutputArgumentNames();
        int i3 = 0;
        while (i3 < outputArgNames.length) {
            filled.addVariable(new Variable(outputArgNames[i3], String.valueOf(externalReferenceCommand.getReferenceName()) + "." + externalReferenceCommand.getOutputArgumentValue(outputArgNames[i3])));
            ++i3;
        }
        filled.addAction(new Submit(nextLink.toString(), outputArgNames));
        subdialog.addFilledHandler(filled);
        form.addFormElement(subdialog);
        return this.createVXMLDocument(links, form);
    }

    protected IDocument renderTransferMessage(ILinkFactory links, TransferMessageCommand transferMessageCommand) {
        VXMLDocument document = new VXMLDocument();
        Form form = new Form("TransferMessageForm");
        form.addFormElement(new Transfer("TransferMessageElement", transferMessageCommand.getDestination()));
        document.addDialog(form);
        return document;
    }

    protected IDocument renderBridgeMessage(ILinkFactory links, BridgeMessageCommand bridgeMessageCommand) {
        Form form = new Form("BridgeMessageForm");
        Transfer tx = new Transfer("BridgeMessageElement", bridgeMessageCommand.getDestination());
        tx.setMaxTime("0s");
        tx.setBridgeEnabled(true);
        Filled filled = new Filled();
        If ifBusy = new If("BridgeMessageElement == 'busy'");
        ILink link = links.createNextLink();
        link.setParameter(bridgeMessageCommand.getResultName(), bridgeMessageCommand.getBusyResultValue());
        ifBusy.addAction(new Goto(link.toString()));
        ElseIf ifNoAnswer = new ElseIf("BridgeMessageElement == 'noanswer'");
        link.setParameter(bridgeMessageCommand.getResultName(), bridgeMessageCommand.getUnavailableResultValue());
        ifNoAnswer.addAction(new Goto(link.toString()));
        ifBusy.addElseIf(ifNoAnswer);
        ElseIf ifNoAuth = new ElseIf("BridgeMessageElement == 'error.connection.noauthorization'");
        link.setParameter(bridgeMessageCommand.getResultName(), bridgeMessageCommand.getNoAuthResultValue());
        ifNoAuth.addAction(new Goto(link.toString()));
        ifBusy.addElseIf(ifNoAuth);
        ElseIf ifBadDest = new ElseIf("BridgeMessageElement == 'error.connection.baddestination'");
        link.setParameter(bridgeMessageCommand.getResultName(), bridgeMessageCommand.getBadDestResultValue());
        ifBadDest.addAction(new Goto(link.toString()));
        ifBusy.addElseIf(ifBadDest);
        ElseIf ifNoRoute = new ElseIf("BridgeMessageElement == 'error.connection.noroute'");
        link.setParameter(bridgeMessageCommand.getResultName(), bridgeMessageCommand.getNoRouteResultValue());
        ifNoRoute.addAction(new Goto(link.toString()));
        ifBusy.addElseIf(ifNoRoute);
        ElseIf ifNoResource = new ElseIf("BridgeMessageElement == 'error.connection.noresource'");
        link.setParameter(bridgeMessageCommand.getResultName(), bridgeMessageCommand.getNoResourceResultValue());
        ifNoResource.addAction(new Goto(link.toString()));
        ifBusy.addElseIf(ifNoResource);
        ElseIf ifProtocol = new ElseIf("BridgeMessageElement == 'error.connection.protocol'");
        link.setParameter(bridgeMessageCommand.getResultName(), bridgeMessageCommand.getProtocolResultValue());
        ifProtocol.addAction(new Goto(link.toString()));
        ifBusy.addElseIf(ifProtocol);
        ElseIf ifBadBridge = new ElseIf("BridgeMessageElement == 'error.unsupported.transfer.bridge'");
        link.setParameter(bridgeMessageCommand.getResultName(), bridgeMessageCommand.getBadBridgeResultValue());
        ifBadBridge.addAction(new Goto(link.toString()));
        ifBusy.addElseIf(ifBadBridge);
        ElseIf ifBadUri = new ElseIf("BridgeMessageElement == 'error.unsupported.uri'");
        link.setParameter(bridgeMessageCommand.getResultName(), bridgeMessageCommand.getBadUriResultValue());
        ifBadUri.addAction(new Goto(link.toString()));
        ifBusy.addElseIf(ifBadUri);
        Else ifTransferred = new Else();
        link.setParameter(bridgeMessageCommand.getResultName(), bridgeMessageCommand.getTransferredResultValue());
        ifTransferred.addAction(new Goto(link.toString()));
        ifBusy.setElse(ifTransferred);
        filled.addIfClause(ifBusy);
        tx.addFilledHandler(filled);
        form.addFormElement(tx);
        return this.createVXMLDocument(links, form);
    }

    protected IDocument renderEndMessage(ILinkFactory links, EndMessageCommand endMessageCommand) {
        VXMLDocument document = new VXMLDocument();
        Form form = new Form("EndMessageForm");
        Block block = new Block("EndMessageBlock");
        block.addAction(new Disconnect());
        form.addFormElement(block);
        document.addDialog(form);
        return document;
    }

    protected IDocument renderFinalDocument(ILinkFactory links, FinalCommand finalCommand) {
        VXMLDocument document = new VXMLDocument();
        Form form = new Form("FinalForm");
        String[] variables = finalCommand.getVariableNames();
        int i = 0;
        while (i < variables.length) {
            form.addVariable(new Variable(variables[i], "'" + finalCommand.getVariable(variables[i]) + "'"));
            ++i;
        }
        Block block = new Block("FinalBlock");
        block.addAction(new Return(variables));
        form.addFormElement(block);
        document.addDialog(form);
        return document;
    }

    public String getInteractionTypeID() {
        return "org.eclipse.vtp.framework.interactions.voice.interaction";
    }

    public String getNormalizedBoolean(String parameter) {
        String ret = null;
        if (Boolean.TRUE.toString().equalsIgnoreCase(parameter)) {
            ret = Boolean.TRUE.toString();
        } else if (Boolean.FALSE.toString().equalsIgnoreCase(parameter)) {
            ret = Boolean.FALSE.toString();
        }
        return ret;
    }
}

