/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.framework.interactions.voice.vxml;

import java.util.LinkedList;
import java.util.List;
import org.eclipse.vtp.framework.interactions.voice.vxml.EventHandler;
import org.eclipse.vtp.framework.interactions.voice.vxml.Filled;
import org.eclipse.vtp.framework.interactions.voice.vxml.FormElement;
import org.eclipse.vtp.framework.interactions.voice.vxml.Grammar;
import org.eclipse.vtp.framework.interactions.voice.vxml.Option;
import org.eclipse.vtp.framework.interactions.voice.vxml.Prompt;
import org.eclipse.vtp.framework.interactions.voice.vxml.PropertiesSupport;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class Field
extends FormElement {
    private String type;
    private Prompt prompt = null;
    private List grammars = new LinkedList();
    private final PropertiesSupport properties = new PropertiesSupport();
    private final LinkedList options = new LinkedList();
    private final LinkedList filledHandlers = new LinkedList();
    private final LinkedList eventHandlers = new LinkedList();

    public Field(String name) throws IllegalArgumentException, NullPointerException {
        super(name);
    }

    public Field(String name, Prompt prompt) throws IllegalArgumentException, NullPointerException {
        super(name);
        this.setPrompt(prompt);
    }

    public Field(String name, String expression) throws IllegalArgumentException, NullPointerException {
        super(name, expression);
    }

    public Field(String name, String expression, Prompt prompt) throws IllegalArgumentException, NullPointerException {
        super(name, expression);
        this.setPrompt(prompt);
    }

    public Field(String name, String expression, String condition) throws IllegalArgumentException, NullPointerException {
        super(name, expression, condition);
    }

    public Field(String name, String expression, String condition, Prompt prompt) throws IllegalArgumentException, NullPointerException {
        super(name, expression, condition);
        this.setPrompt(prompt);
    }

    public String getType() {
        return this.type;
    }

    public Prompt getPrompt() {
        return this.prompt;
    }

    public Grammar[] getGrammar() {
        return this.grammars.toArray(new Grammar[this.grammars.size()]);
    }

    public String[] getPropertyNames() {
        return this.properties.getPropertyNames();
    }

    public String getPropertyValue(String propertyName) throws NullPointerException {
        return this.properties.getPropertyValue(propertyName);
    }

    public Option[] getOptions() {
        return this.options.toArray(new Option[this.options.size()]);
    }

    public Filled[] getFilledHandlers() {
        return this.filledHandlers.toArray(new Filled[this.filledHandlers.size()]);
    }

    public EventHandler[] getEventHandlers() {
        return this.eventHandlers.toArray(new EventHandler[this.eventHandlers.size()]);
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setPrompt(Prompt prompt) {
        this.prompt = prompt;
    }

    public void addGrammar(Grammar grammar) {
        this.grammars.add(grammar);
    }

    public void setProperty(String propertyName, String propertyValue) throws NullPointerException {
        this.properties.setProperty(propertyName, propertyValue);
    }

    public void clearProperty(String propertyName) throws NullPointerException {
        this.properties.clearProperty(propertyName);
    }

    public void addOption(Option option) throws NullPointerException {
        if (option == null) {
            throw new NullPointerException("option");
        }
        this.options.add(option);
    }

    public void removeOption(Option option) throws NullPointerException {
        if (option == null) {
            throw new NullPointerException("option");
        }
        this.options.remove(option);
    }

    public void addFilledHandler(Filled filled) throws NullPointerException {
        if (filled == null) {
            throw new NullPointerException("filled");
        }
        this.filledHandlers.add(filled);
    }

    public void removeFilledHandler(Filled filled) throws NullPointerException {
        if (filled == null) {
            throw new NullPointerException("filled");
        }
        this.filledHandlers.remove(filled);
    }

    public void addEventHandler(EventHandler eventHandler) throws NullPointerException {
        if (eventHandler == null) {
            throw new NullPointerException("eventHandler");
        }
        this.eventHandlers.add(eventHandler);
    }

    public void removeEventHandler(EventHandler eventHandler) throws NullPointerException {
        if (eventHandler == null) {
            throw new NullPointerException("eventHandler");
        }
        this.eventHandlers.remove(eventHandler);
    }

    public void writeWidget(ContentHandler outputHandler) throws NullPointerException, SAXException {
        if (outputHandler == null) {
            throw new NullPointerException("outputHandler");
        }
        AttributesImpl attributes = new AttributesImpl();
        this.writeAttributes(attributes);
        outputHandler.startElement("http://www.w3.org/2001/vxml", "field", "field", attributes);
        this.writeProperties(outputHandler);
        this.writePrompt(outputHandler);
        this.writeGrammar(outputHandler);
        this.writeOptions(outputHandler);
        this.writeFilledHandlers(outputHandler);
        this.writeEventHandlers(outputHandler);
        outputHandler.endElement("http://www.w3.org/2001/vxml", "field", "field");
    }

    protected void writeAttributes(AttributesImpl attributes) {
        super.writeAttributes(attributes);
        if (this.type != null && this.type.length() > 0) {
            this.writeAttribute(attributes, null, null, "type", "CDATA", this.type);
        }
    }

    protected void writePrompt(ContentHandler outputHandler) throws NullPointerException, SAXException {
        if (this.prompt != null) {
            this.prompt.writeWidget(outputHandler);
        }
    }

    protected void writeGrammar(ContentHandler outputHandler) throws NullPointerException, SAXException {
        for (Grammar g : this.grammars) {
            if (g == null) continue;
            g.writeWidget(outputHandler);
        }
    }

    protected void writeProperties(ContentHandler outputHandler) throws NullPointerException, SAXException {
        this.properties.writeWidget(outputHandler);
    }

    protected void writeOptions(ContentHandler outputHandler) throws NullPointerException, SAXException {
        if (this.options.isEmpty()) {
            return;
        }
        outputHandler.startElement("http://www.w3.org/2001/vxml", "enumerate", "enumerate", new AttributesImpl());
        outputHandler.endElement("http://www.w3.org/2001/vxml", "enumerate", "enumerate");
        this.writeChildren(outputHandler, this.options);
    }

    protected void writeFilledHandlers(ContentHandler outputHandler) throws NullPointerException, SAXException {
        this.writeChildren(outputHandler, this.filledHandlers);
    }

    protected void writeEventHandlers(ContentHandler outputHandler) throws NullPointerException, SAXException {
        this.writeChildren(outputHandler, this.eventHandlers);
    }
}

