/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.framework.interactions.voice.vxml;

import java.util.Iterator;
import java.util.LinkedList;
import org.eclipse.vtp.framework.interactions.core.support.Widget;
import org.eclipse.vtp.framework.interactions.voice.vxml.Action;
import org.eclipse.vtp.framework.interactions.voice.vxml.If;
import org.eclipse.vtp.framework.interactions.voice.vxml.VXMLConstants;
import org.eclipse.vtp.framework.interactions.voice.vxml.Variable;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class Filled
extends Widget
implements VXMLConstants {
    private String mode = null;
    private final LinkedList names = new LinkedList();
    private final LinkedList variables = new LinkedList();
    private final LinkedList actionsAndIfClauses = new LinkedList();

    public Filled() {
    }

    public Filled(String mode) throws IllegalArgumentException, NullPointerException {
        this.setMode(mode);
    }

    public Filled(String[] names) throws IllegalArgumentException, NullPointerException {
        if (names != null) {
            int i = 0;
            while (i < names.length) {
                this.addName(names[i]);
                ++i;
            }
        }
    }

    public Filled(String mode, String[] names) throws IllegalArgumentException, NullPointerException {
        this.setMode(mode);
        if (names != null) {
            int i = 0;
            while (i < names.length) {
                this.addName(names[i]);
                ++i;
            }
        }
    }

    public String getMode() {
        return this.mode;
    }

    public String[] getNames() {
        return this.names.toArray(new String[this.names.size()]);
    }

    public Variable[] getVariables() {
        return this.variables.toArray(new Variable[this.variables.size()]);
    }

    public Widget[] getActionsAndIfClauses() {
        return this.actionsAndIfClauses.toArray(new Widget[this.actionsAndIfClauses.size()]);
    }

    public void setMode(String mode) throws IllegalArgumentException, NullPointerException {
        if (mode == null) {
            this.mode = null;
        } else if (mode.equalsIgnoreCase("all")) {
            this.mode = "all";
        } else if (mode.equalsIgnoreCase("any")) {
            this.mode = "any";
        } else {
            throw new IllegalArgumentException("mode==\"" + mode + "\"");
        }
    }

    public void addName(String name) throws IllegalArgumentException, NullPointerException {
        if (name == null) {
            throw new NullPointerException("name");
        }
        if (name.length() == 0) {
            throw new IllegalArgumentException("name");
        }
        this.names.add(name);
    }

    public void removeName(String name) throws IllegalArgumentException, NullPointerException {
        if (name == null) {
            throw new NullPointerException("mode");
        }
        if (name.length() == 0) {
            throw new IllegalArgumentException("mode");
        }
        this.names.remove(name);
    }

    public void addVariable(Variable variable) throws NullPointerException {
        if (variable == null) {
            throw new NullPointerException("variable");
        }
        this.variables.add(variable);
    }

    public void removeVariable(Variable variable) throws NullPointerException {
        if (variable == null) {
            throw new NullPointerException("variable");
        }
        this.variables.remove(variable);
    }

    public void addAction(Action action) throws NullPointerException {
        if (action == null) {
            throw new NullPointerException("action");
        }
        this.actionsAndIfClauses.add(action);
    }

    public void removeAction(Action action) throws NullPointerException {
        if (action == null) {
            throw new NullPointerException("action");
        }
        this.actionsAndIfClauses.remove(action);
    }

    public void addIfClause(If ifClause) throws NullPointerException {
        if (ifClause == null) {
            throw new NullPointerException("ifClause");
        }
        this.actionsAndIfClauses.add(ifClause);
    }

    public void removeIfClause(If ifClause) throws NullPointerException {
        if (ifClause == null) {
            throw new NullPointerException("ifClause");
        }
        this.actionsAndIfClauses.remove(ifClause);
    }

    public void writeWidget(ContentHandler outputHandler) throws NullPointerException, SAXException {
        if (outputHandler == null) {
            throw new NullPointerException("outputHandler");
        }
        AttributesImpl attributes = new AttributesImpl();
        this.writeAttributes(attributes);
        outputHandler.startElement("http://www.w3.org/2001/vxml", "filled", "filled", attributes);
        this.writeVariables(outputHandler);
        this.writeActionsAndIfClauses(outputHandler);
        outputHandler.endElement("http://www.w3.org/2001/vxml", "filled", "filled");
    }

    protected void writeAttributes(AttributesImpl attributes) {
        if (this.mode != null) {
            this.writeAttribute(attributes, null, null, "mode", "CDATA", this.mode);
        }
        if (!this.names.isEmpty()) {
            StringBuffer nameList = new StringBuffer();
            Iterator i = this.names.iterator();
            while (i.hasNext()) {
                nameList.append((String)i.next());
                if (!i.hasNext()) continue;
                nameList.append(' ');
            }
            this.writeAttribute(attributes, null, null, "namelist", "CDATA", nameList.toString());
        }
    }

    protected void writeVariables(ContentHandler outputHandler) throws NullPointerException, SAXException {
        this.writeChildren(outputHandler, this.variables);
    }

    protected void writeActionsAndIfClauses(ContentHandler outputHandler) throws NullPointerException, SAXException {
        if (outputHandler == null) {
            throw new NullPointerException("outputHandler");
        }
        this.writeChildren(outputHandler, this.actionsAndIfClauses);
    }
}

