/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.framework.interactions.voice.vxml;

import java.util.LinkedList;
import org.eclipse.vtp.framework.interactions.voice.vxml.Dialog;
import org.eclipse.vtp.framework.interactions.voice.vxml.Filled;
import org.eclipse.vtp.framework.interactions.voice.vxml.FormElement;
import org.eclipse.vtp.framework.interactions.voice.vxml.Variable;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class Form
extends Dialog {
    private final LinkedList variables = new LinkedList();
    private final LinkedList formElements = new LinkedList();
    private final LinkedList filledHandlers = new LinkedList();

    public Form(String id) throws IllegalArgumentException, NullPointerException {
        super(id);
    }

    public Form(String id, String scope) throws IllegalArgumentException, NullPointerException {
        super(id, scope);
    }

    Variable[] getVariables() {
        return this.variables.toArray(new Variable[this.variables.size()]);
    }

    FormElement[] getFormElements() {
        return this.formElements.toArray(new FormElement[this.formElements.size()]);
    }

    Filled[] getFilledHandlers() {
        return this.filledHandlers.toArray(new Filled[this.filledHandlers.size()]);
    }

    public void addVariable(Variable variable) throws NullPointerException {
        if (variable == null) {
            throw new NullPointerException("variable");
        }
        this.variables.add(variable);
    }

    public void removeVariable(Variable variable) throws NullPointerException {
        if (variable == null) {
            throw new NullPointerException("variable");
        }
        this.variables.remove(variable);
    }

    public void addFormElement(FormElement formElement) throws NullPointerException {
        if (formElement == null) {
            throw new NullPointerException("formElement");
        }
        this.formElements.add(formElement);
    }

    public void removeFormElement(FormElement formElement) throws NullPointerException {
        if (formElement == null) {
            throw new NullPointerException("formElement");
        }
        this.formElements.remove(formElement);
    }

    public void addFilledHandler(Filled filled) throws NullPointerException {
        if (filled == null) {
            throw new NullPointerException("filled");
        }
        this.filledHandlers.add(filled);
    }

    public void removeFilledHandler(Filled filled) throws NullPointerException {
        if (filled == null) {
            throw new NullPointerException("filled");
        }
        this.filledHandlers.remove(filled);
    }

    public void writeWidget(ContentHandler outputHandler) throws NullPointerException, SAXException {
        if (outputHandler == null) {
            throw new NullPointerException("outputHandler");
        }
        AttributesImpl attributes = new AttributesImpl();
        this.writeAttributes(attributes);
        outputHandler.startElement("http://www.w3.org/2001/vxml", "form", "form", attributes);
        this.writeProperties(outputHandler);
        this.writeVariables(outputHandler);
        this.writeFormElements(outputHandler);
        this.writeFilledHandlers(outputHandler);
        this.writeEventHandlers(outputHandler);
        outputHandler.endElement("http://www.w3.org/2001/vxml", "form", "form");
    }

    protected void writeVariables(ContentHandler outputHandler) throws NullPointerException, SAXException {
        this.writeChildren(outputHandler, this.variables);
    }

    protected void writeFormElements(ContentHandler outputHandler) throws NullPointerException, SAXException {
        this.writeChildren(outputHandler, this.formElements);
    }

    protected void writeFilledHandlers(ContentHandler outputHandler) throws NullPointerException, SAXException {
        this.writeChildren(outputHandler, this.filledHandlers);
    }
}

