/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.framework.interactions.voice.vxml;

import java.util.Locale;
import org.eclipse.vtp.framework.interactions.voice.vxml.Action;
import org.eclipse.vtp.framework.interactions.voice.vxml.Output;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class Prompt
extends Action {
    private Output output;
    private boolean bargeInEnabled = true;
    private Locale language = Locale.getDefault();
    private String timeout = null;

    public Prompt(Output output) throws NullPointerException {
        this.setOutput(output);
    }

    public Prompt(Output output, boolean bargeIn) throws NullPointerException {
        this.setOutput(output);
        this.setBargeInEnabled(bargeIn);
    }

    public Output getOutput() {
        return this.output;
    }

    public boolean isBargeInEnabled() {
        return this.bargeInEnabled;
    }

    public Locale getLanguage() {
        return this.language;
    }

    public String getTimeout() {
        return this.timeout;
    }

    public void setOutput(Output output) throws NullPointerException {
        if (output == null) {
            throw new NullPointerException("output");
        }
        this.output = output;
    }

    public void setBargeInEnabled(boolean bargeInEnabled) {
        this.bargeInEnabled = bargeInEnabled;
    }

    public void setLanguage(Locale language) throws NullPointerException {
        if (language == null) {
            throw new NullPointerException("language");
        }
        this.language = language;
    }

    public void setTimeout(String timeout) throws IllegalArgumentException {
        if (timeout != null && timeout.length() == 0) {
            throw new IllegalArgumentException("timeout");
        }
        this.timeout = timeout;
    }

    public void writeWidget(ContentHandler outputHandler) throws NullPointerException, SAXException {
        if (outputHandler == null) {
            throw new NullPointerException("outputHandler");
        }
        AttributesImpl attributes = new AttributesImpl();
        this.writeAttributes(attributes);
        outputHandler.startElement("http://www.w3.org/2001/vxml", "prompt", "prompt", attributes);
        this.writeOutput(outputHandler);
        outputHandler.endElement("http://www.w3.org/2001/vxml", "prompt", "prompt");
    }

    protected void writeAttributes(AttributesImpl attributes) {
        this.writeAttribute(attributes, null, null, "bargein", "CDATA", String.valueOf(this.bargeInEnabled));
        StringBuffer xmlLang = new StringBuffer(this.language.getLanguage());
        if (this.language.getCountry() != null && this.language.getCountry().length() > 0) {
            xmlLang.append('-').append(this.language.getCountry());
        }
        this.writeAttribute(attributes, null, null, "xml:lang", "CDATA", xmlLang.toString());
        if (this.timeout != null) {
            this.writeAttribute(attributes, null, null, "timeout", "CDATA", this.timeout);
        }
    }

    protected void writeOutput(ContentHandler outputHandler) throws NullPointerException, SAXException {
        this.output.writeWidget(outputHandler);
    }
}

