/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.framework.interactions.voice.vxml;

import java.util.LinkedList;
import org.eclipse.vtp.framework.interactions.voice.vxml.EventHandler;
import org.eclipse.vtp.framework.interactions.voice.vxml.Filled;
import org.eclipse.vtp.framework.interactions.voice.vxml.FormElement;
import org.eclipse.vtp.framework.interactions.voice.vxml.Prompt;
import org.eclipse.vtp.framework.interactions.voice.vxml.PropertiesSupport;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class Recording
extends FormElement {
    private boolean beepEnabled = false;
    private boolean dtmfTermEnabled = true;
    private String maxtime = null;
    private String finalSilence = null;
    private String fileType = null;
    private String timeout = null;
    private Prompt prompt = null;
    private final PropertiesSupport properties = new PropertiesSupport();
    private final LinkedList filledHandlers = new LinkedList();
    private final LinkedList eventHandlers = new LinkedList();

    public Recording(String name) throws IllegalArgumentException, NullPointerException {
        super(name);
    }

    public Recording(String name, String expression) throws IllegalArgumentException, NullPointerException {
        super(name, expression);
    }

    public Recording(String name, String expression, String condition) throws IllegalArgumentException, NullPointerException {
        super(name, expression, condition);
    }

    public boolean isBeepEnabled() {
        return this.beepEnabled;
    }

    public boolean isDtmfTermEnabled() {
        return this.dtmfTermEnabled;
    }

    public String getMaxtime() {
        return this.maxtime;
    }

    public String getFinalSilence() {
        return this.finalSilence;
    }

    public String getFileType() {
        return this.fileType;
    }

    public String getTimeout() {
        return this.timeout;
    }

    public Prompt getPrompt() {
        return this.prompt;
    }

    public String[] getPropertyNames() {
        return this.properties.getPropertyNames();
    }

    public String getPropertyValue(String propertyName) throws NullPointerException {
        return this.properties.getPropertyValue(propertyName);
    }

    Filled[] getFilledHandlers() {
        return this.filledHandlers.toArray(new Filled[this.filledHandlers.size()]);
    }

    EventHandler[] getEventHandlers() {
        return this.eventHandlers.toArray(new EventHandler[this.eventHandlers.size()]);
    }

    public void setBeepEnabled(boolean beepEnabled) {
        this.beepEnabled = beepEnabled;
    }

    public void setDtmfTermEnabled(boolean dtmfTermEnabled) {
        this.dtmfTermEnabled = dtmfTermEnabled;
    }

    public void setMaxtime(String maxtime) throws IllegalArgumentException {
        if (maxtime != null && maxtime.length() == 0) {
            throw new IllegalArgumentException("maxtime");
        }
        this.maxtime = maxtime;
    }

    public void setFinalSilence(String finalSilence) throws IllegalArgumentException {
        if (finalSilence != null && finalSilence.length() == 0) {
            throw new IllegalArgumentException("finalSilence");
        }
        this.finalSilence = finalSilence;
    }

    public void setFileType(String fileType) throws IllegalArgumentException {
        if (fileType != null && fileType.length() == 0) {
            throw new IllegalArgumentException("fileType");
        }
        this.fileType = fileType;
    }

    public void setTimeout(String timeout) throws IllegalArgumentException {
        if (timeout != null && timeout.length() == 0) {
            throw new IllegalArgumentException("timeout");
        }
        this.timeout = timeout;
        if (this.prompt != null) {
            this.prompt.setTimeout(timeout);
        }
    }

    public void setPrompt(Prompt prompt) {
        this.prompt = prompt;
        if (prompt != null) {
            prompt.setTimeout(this.timeout);
        }
    }

    public void setProperty(String propertyName, String propertyValue) throws NullPointerException {
        this.properties.setProperty(propertyName, propertyValue);
    }

    public void clearProperty(String propertyName) throws NullPointerException {
        this.properties.clearProperty(propertyName);
    }

    public void addFilledHandler(Filled filled) throws NullPointerException {
        if (filled == null) {
            throw new NullPointerException("filled");
        }
        this.filledHandlers.add(filled);
    }

    public void removeFilledHandler(Filled filled) throws NullPointerException {
        if (filled == null) {
            throw new NullPointerException("filled");
        }
        this.filledHandlers.remove(filled);
    }

    public void addEventHandler(EventHandler eventHandler) throws NullPointerException {
        if (eventHandler == null) {
            throw new NullPointerException("eventHandler");
        }
        this.eventHandlers.add(eventHandler);
    }

    public void removeEventHandler(EventHandler eventHandler) throws NullPointerException {
        if (eventHandler == null) {
            throw new NullPointerException("eventHandler");
        }
        this.eventHandlers.remove(eventHandler);
    }

    public void writeWidget(ContentHandler outputHandler) throws NullPointerException, SAXException {
        if (outputHandler == null) {
            throw new NullPointerException("outputHandler");
        }
        AttributesImpl attributes = new AttributesImpl();
        this.writeAttributes(attributes);
        outputHandler.startElement("http://www.w3.org/2001/vxml", "record", "record", attributes);
        this.writeProperties(outputHandler);
        this.writePrompt(outputHandler);
        this.writeFilledHandlers(outputHandler);
        this.writeEventHandlers(outputHandler);
        outputHandler.endElement("http://www.w3.org/2001/vxml", "record", "record");
    }

    protected void writeAttributes(AttributesImpl attributes) {
        super.writeAttributes(attributes);
        this.writeAttribute(attributes, null, null, "beep", "CDATA", String.valueOf(this.beepEnabled));
        this.writeAttribute(attributes, null, null, "dtmfterm", "CDATA", String.valueOf(this.dtmfTermEnabled));
        if (this.maxtime != null) {
            this.writeAttribute(attributes, null, null, "maxtime", "CDATA", this.maxtime);
        }
        if (this.finalSilence != null) {
            this.writeAttribute(attributes, null, null, "finalsilence", "CDATA", this.finalSilence);
        }
        if (this.fileType != null) {
            this.writeAttribute(attributes, null, null, "type", "CDATA", this.fileType);
        }
    }

    protected void writePrompt(ContentHandler outputHandler) throws NullPointerException, SAXException {
        if (this.prompt != null) {
            this.prompt.writeWidget(outputHandler);
        }
    }

    protected void writeProperties(ContentHandler outputHandler) throws NullPointerException, SAXException {
        this.properties.writeWidget(outputHandler);
    }

    protected void writeFilledHandlers(ContentHandler outputHandler) throws NullPointerException, SAXException {
        this.writeChildren(outputHandler, this.filledHandlers);
    }

    protected void writeEventHandlers(ContentHandler outputHandler) throws NullPointerException, SAXException {
        this.writeChildren(outputHandler, this.eventHandlers);
    }
}

