/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.framework.interactions.voice.vxml;

import java.util.LinkedList;
import org.eclipse.vtp.framework.interactions.voice.vxml.EventHandler;
import org.eclipse.vtp.framework.interactions.voice.vxml.Filled;
import org.eclipse.vtp.framework.interactions.voice.vxml.FormElement;
import org.eclipse.vtp.framework.interactions.voice.vxml.Parameter;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class Subdialog
extends FormElement {
    private String sourceURI = null;
    private final LinkedList parameters = new LinkedList();
    private final LinkedList filledHandlers = new LinkedList();
    private final LinkedList eventHandlers = new LinkedList();

    public Subdialog(String name) throws IllegalArgumentException, NullPointerException {
        super(name);
    }

    public Subdialog(String name, String expression) throws IllegalArgumentException, NullPointerException {
        super(name, expression);
    }

    public Subdialog(String name, String expression, String condition) throws IllegalArgumentException, NullPointerException {
        super(name, expression, condition);
    }

    public Subdialog(String name, String expression, String condition, String sourceURI) throws IllegalArgumentException, NullPointerException {
        super(name, expression, condition);
        this.setSourceURI(sourceURI);
    }

    public String getSourceURI() {
        return this.sourceURI;
    }

    Parameter[] getParameters() {
        return this.parameters.toArray(new Parameter[this.parameters.size()]);
    }

    Filled[] getFilledHandlers() {
        return this.filledHandlers.toArray(new Filled[this.filledHandlers.size()]);
    }

    EventHandler[] getEventHandlers() {
        return this.eventHandlers.toArray(new EventHandler[this.eventHandlers.size()]);
    }

    public void setSourceURI(String sourceURI) throws IllegalArgumentException {
        if (sourceURI != null && sourceURI.length() == 0) {
            throw new IllegalArgumentException("sourceURI");
        }
        this.sourceURI = sourceURI;
    }

    public void addParameter(Parameter parameter) throws NullPointerException {
        if (parameter == null) {
            throw new NullPointerException("parameter");
        }
        this.parameters.add(parameter);
    }

    public void removeParameter(Parameter parameter) throws NullPointerException {
        if (parameter == null) {
            throw new NullPointerException("parameter");
        }
        this.parameters.remove(parameter);
    }

    public void addFilledHandler(Filled filled) throws NullPointerException {
        if (filled == null) {
            throw new NullPointerException("filled");
        }
        this.filledHandlers.add(filled);
    }

    public void removeFilledHandler(Filled filled) throws NullPointerException {
        if (filled == null) {
            throw new NullPointerException("filled");
        }
        this.filledHandlers.remove(filled);
    }

    public void addEventHandler(EventHandler eventHandler) throws NullPointerException {
        if (eventHandler == null) {
            throw new NullPointerException("eventHandler");
        }
        this.eventHandlers.add(eventHandler);
    }

    public void removeEventHandler(EventHandler eventHandler) throws NullPointerException {
        if (eventHandler == null) {
            throw new NullPointerException("eventHandler");
        }
        this.eventHandlers.remove(eventHandler);
    }

    public void writeWidget(ContentHandler outputHandler) throws NullPointerException, SAXException {
        if (outputHandler == null) {
            throw new NullPointerException("outputHandler");
        }
        AttributesImpl attributes = new AttributesImpl();
        this.writeAttributes(attributes);
        outputHandler.startElement("http://www.w3.org/2001/vxml", "subdialog", "subdialog", attributes);
        this.writeParameters(outputHandler);
        this.writeFilledHandlers(outputHandler);
        this.writeEventHandlers(outputHandler);
        outputHandler.endElement("http://www.w3.org/2001/vxml", "subdialog", "subdialog");
    }

    protected void writeAttributes(AttributesImpl attributes) {
        super.writeAttributes(attributes);
        if (this.sourceURI != null) {
            this.writeAttribute(attributes, null, null, "src", "CDATA", this.sourceURI);
        }
    }

    protected void writeParameters(ContentHandler outputHandler) throws NullPointerException, SAXException {
        this.writeChildren(outputHandler, this.parameters);
    }

    protected void writeFilledHandlers(ContentHandler outputHandler) throws NullPointerException, SAXException {
        this.writeChildren(outputHandler, this.filledHandlers);
    }

    protected void writeEventHandlers(ContentHandler outputHandler) throws NullPointerException, SAXException {
        this.writeChildren(outputHandler, this.eventHandlers);
    }
}

