/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.framework.interactions.voice.vxml;

import java.util.LinkedList;
import java.util.List;
import org.eclipse.vtp.framework.interactions.core.support.WidgetDocument;
import org.eclipse.vtp.framework.interactions.voice.vxml.Dialog;
import org.eclipse.vtp.framework.interactions.voice.vxml.EventHandler;
import org.eclipse.vtp.framework.interactions.voice.vxml.PropertiesSupport;
import org.eclipse.vtp.framework.interactions.voice.vxml.Script;
import org.eclipse.vtp.framework.interactions.voice.vxml.VXMLConstants;
import org.eclipse.vtp.framework.interactions.voice.vxml.Variable;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class VXMLDocument
extends WidgetDocument
implements VXMLConstants {
    private String version = "2.0";
    private String applicationURI = null;
    private final PropertiesSupport properties = new PropertiesSupport();
    private final List variables = new LinkedList();
    private final List scripts = new LinkedList();
    private final List dialogs = new LinkedList();
    private final List eventHandlers = new LinkedList();

    public VXMLDocument() {
    }

    public VXMLDocument(String version) throws NullPointerException {
        this.setVersion(version);
    }

    public String getVersion() {
        return this.version;
    }

    public String getApplicationURI() {
        return this.version;
    }

    public String[] getPropertyNames() {
        return this.properties.getPropertyNames();
    }

    public String getPropertyValue(String propertyName) throws NullPointerException {
        return this.properties.getPropertyValue(propertyName);
    }

    Variable[] getVariables() {
        return this.variables.toArray(new Variable[this.variables.size()]);
    }

    Script[] getScripts() {
        return this.scripts.toArray(new Script[this.scripts.size()]);
    }

    Dialog[] getDialogs() {
        return this.dialogs.toArray(new Dialog[this.dialogs.size()]);
    }

    EventHandler[] getEventHandlers() {
        return this.eventHandlers.toArray(new EventHandler[this.eventHandlers.size()]);
    }

    public void setVersion(String version) {
        if (version == null) {
            throw new NullPointerException("version");
        }
        this.version = version;
    }

    public void setApplicationURI(String applicationURI) {
        this.applicationURI = applicationURI;
    }

    public void setProperty(String propertyName, String propertyValue) throws NullPointerException {
        this.properties.setProperty(propertyName, propertyValue);
    }

    public void clearProperty(String propertyName) throws NullPointerException {
        this.properties.clearProperty(propertyName);
    }

    public void addVariable(Variable variable) throws NullPointerException {
        if (variable == null) {
            throw new NullPointerException("variable");
        }
        this.variables.add(variable);
    }

    public void removeVariable(Variable variable) throws NullPointerException {
        if (variable == null) {
            throw new NullPointerException("variable");
        }
        this.variables.remove(variable);
    }

    public void addScript(Script script) throws NullPointerException {
        if (script == null) {
            throw new NullPointerException("script");
        }
        this.scripts.add(script);
    }

    public void removeScript(Script script) throws NullPointerException {
        if (script == null) {
            throw new NullPointerException("script");
        }
        this.scripts.remove(script);
    }

    public void addDialog(Dialog dialog) throws NullPointerException {
        if (dialog == null) {
            throw new NullPointerException("dialog");
        }
        this.dialogs.add(dialog);
    }

    public void removeDialog(Dialog dialog) throws NullPointerException {
        if (dialog == null) {
            throw new NullPointerException("dialog");
        }
        this.dialogs.remove(dialog);
    }

    public void addEventHandler(EventHandler eventHandler) throws NullPointerException {
        if (eventHandler == null) {
            throw new NullPointerException("eventHandler");
        }
        this.eventHandlers.add(eventHandler);
    }

    public void removeEventHandler(EventHandler eventHandler) throws NullPointerException {
        if (eventHandler == null) {
            throw new NullPointerException("eventHandler");
        }
        this.eventHandlers.remove(eventHandler);
    }

    public String getDocumentType() {
        return "http://www.w3.org/2001/vxml";
    }

    public void writeWidget(ContentHandler outputHandler) throws NullPointerException, SAXException {
        if (outputHandler == null) {
            throw new NullPointerException("outputHandler");
        }
        outputHandler.startDocument();
        outputHandler.startPrefixMapping("", "http://www.w3.org/2001/vxml");
        AttributesImpl attributes = new AttributesImpl();
        this.writeAttributes(attributes);
        outputHandler.startElement("http://www.w3.org/2001/vxml", "vxml", "vxml", attributes);
        this.writeProperties(outputHandler);
        this.writeVariables(outputHandler);
        this.writeScripts(outputHandler);
        this.writeDialogs(outputHandler);
        this.writeEventHandlers(outputHandler);
        outputHandler.endElement("http://www.w3.org/2001/vxml", "vxml", "vxml");
        outputHandler.endPrefixMapping("");
        outputHandler.endDocument();
    }

    protected void writeAttributes(AttributesImpl attributes) {
        this.writeAttribute(attributes, null, null, "version", "CDATA", this.version);
        if (this.applicationURI != null) {
            this.writeAttribute(attributes, null, null, "application", "CDATA", this.applicationURI);
        }
    }

    protected void writeProperties(ContentHandler outputHandler) throws NullPointerException, SAXException {
        this.properties.writeWidget(outputHandler);
    }

    protected void writeVariables(ContentHandler outputHandler) throws NullPointerException, SAXException {
        this.writeChildren(outputHandler, this.variables);
    }

    protected void writeScripts(ContentHandler outputHandler) throws NullPointerException, SAXException {
        this.writeChildren(outputHandler, this.scripts);
    }

    protected void writeDialogs(ContentHandler outputHandler) throws NullPointerException, SAXException {
        this.writeChildren(outputHandler, this.dialogs);
    }

    protected void writeEventHandlers(ContentHandler outputHandler) throws NullPointerException, SAXException {
        this.writeChildren(outputHandler, this.eventHandlers);
    }
}

