/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.editors.voice.mediascreens;

import java.util.List;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.vtp.desktop.editors.core.elements.MenuChoice;
import org.eclipse.vtp.desktop.editors.core.elements.OptionSetInformationProvider;

public class NewMenuChoiceWizard
extends Wizard {
    private ApplicationPage page = null;
    private OptionSetInformationProvider menu = null;
    private String brand = null;

    public NewMenuChoiceWizard(String brandName, OptionSetInformationProvider menu) {
        this.menu = menu;
        this.page = new ApplicationPage();
        this.addPage((IWizardPage)this.page);
        this.brand = brandName;
    }

    public boolean performFinish() {
        this.menu.addChoice(this.brand, new MenuChoice(this.page.nameField.getText(), null));
        return true;
    }

    private class ApplicationPage
    extends WizardPage {
        Text nameField;

        public ApplicationPage() {
            super("CreateApplicationPage", "New Menu Option", null);
            this.nameField = null;
            this.setPageComplete(false);
        }

        public void createControl(Composite parent) {
            this.setControl((Control)parent);
            Label hostLabel = new Label(parent, 0);
            hostLabel.setText("Option Name:");
            hostLabel.setSize(hostLabel.computeSize(-1, -1));
            this.nameField = new Text(parent, 2052);
            this.nameField.addKeyListener(new KeyListener(){

                public void keyPressed(KeyEvent e) {
                }

                public void keyReleased(KeyEvent e) {
                    if (ApplicationPage.this.nameField.getText().length() == 0) {
                        ApplicationPage.this.setPageComplete(false);
                    } else {
                        List options = NewMenuChoiceWizard.this.menu.getChoicesByBrand(NewMenuChoiceWizard.this.brand);
                        int i = 0;
                        while (i < options.size()) {
                            if (ApplicationPage.this.nameField.getText().equalsIgnoreCase(((MenuChoice)options.get(i)).getOptionName())) {
                                ApplicationPage.this.setPageComplete(false);
                                ApplicationPage.this.setErrorMessage("Another option already exists with that name.");
                                return;
                            }
                            ++i;
                        }
                        ApplicationPage.this.setPageComplete(true);
                        ApplicationPage.this.setErrorMessage(null);
                    }
                }
            });
            FormLayout formLayout = new FormLayout();
            formLayout.marginHeight = 10;
            formLayout.marginWidth = 10;
            parent.setLayout((Layout)formLayout);
            FormData hostLabelFormData = new FormData();
            hostLabelFormData.left = new FormAttachment(0, 10);
            hostLabelFormData.top = new FormAttachment(0, 13);
            hostLabelFormData.right = new FormAttachment(0, 10 + hostLabel.getSize().x);
            hostLabelFormData.bottom = new FormAttachment(0, 13 + hostLabel.getSize().y);
            hostLabel.setLayoutData((Object)hostLabelFormData);
            FormData hostFieldFormData = new FormData();
            hostFieldFormData.left = new FormAttachment((Control)hostLabel, 6);
            hostFieldFormData.top = new FormAttachment(0, 10);
            hostFieldFormData.right = new FormAttachment(100, -10);
            this.nameField.setLayoutData((Object)hostFieldFormData);
        }

        public String getApplicationName() {
            return this.nameField.getText();
        }
    }
}

