/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.editors.voice.mediascreens;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.vtp.desktop.core.Activator;
import org.eclipse.vtp.desktop.core.configuration.Brand;
import org.eclipse.vtp.desktop.core.configuration.ConfigurationManager;
import org.eclipse.vtp.desktop.core.configuration.media.GrammarMediaBinding;
import org.eclipse.vtp.desktop.core.configuration.media.MediaBindingManager;
import org.eclipse.vtp.desktop.core.configuration.media.PromptBindingItem;
import org.eclipse.vtp.desktop.core.configuration.media.PromptBindingItemEntry;
import org.eclipse.vtp.desktop.core.configuration.media.PromptMediaBinding;
import org.eclipse.vtp.desktop.core.configuration.media.PropertyBindingItem;
import org.eclipse.vtp.desktop.core.configuration.media.PropertyMediaBinding;
import org.eclipse.vtp.desktop.editors.core.dialogs.MenuOptionScriptDialog;
import org.eclipse.vtp.desktop.editors.core.elements.MenuChoice;
import org.eclipse.vtp.desktop.editors.core.elements.OptionSetInformationProvider;
import org.eclipse.vtp.desktop.editors.core.elements.PrimitiveElement;
import org.eclipse.vtp.desktop.editors.voice.mediascreens.NewMenuChoiceWizard;
import org.eclipse.vtp.desktop.media.core.GrammarBindingViewer;
import org.eclipse.vtp.desktop.media.core.MediaConfigurationScreen;
import org.eclipse.vtp.desktop.media.core.PromptBindingViewer;
import org.eclipse.vtp.desktop.media.core.PromptBindingViewerListener;
import org.eclipse.vtp.desktop.model.core.Element;
import org.eclipse.vtp.framework.interactions.core.media.Content;
import org.eclipse.vtp.framework.interactions.core.media.TextContent;

public class OptionSetMediaScreen
extends MediaConfigurationScreen
implements PromptBindingViewerListener {
    private FormToolkit toolkit;
    MediaBindingManager bindingManager;
    Combo inputModeCombo = null;
    Combo barginCombo = null;
    Spinner initialTimeoutSpinner = null;
    Spinner terminationTimeoutSpinner = null;
    Spinner speechCompleteTimeoutSpinner = null;
    Spinner speechIncompleteTimeoutSpinner = null;
    Spinner maxSpeechTimeoutSpinner = null;
    Spinner confidenceLevelSpinner = null;
    Spinner sensitivitySpinner = null;
    Spinner speedVsAccuracySpinner = null;
    List dtmfWidgets = new ArrayList();
    List voiceWidgets = new ArrayList();
    OptionSetInformationProvider info = null;
    Section contentSection = null;
    Composite comp = null;
    Button addOptionButton;
    Control addOptionComposite;
    Map moveUpButtons = new HashMap();
    Map moveDownButtons = new HashMap();
    Map optionControlMap = new HashMap();
    Map optionPromptMap = new HashMap();
    Map optionGrammarMap = new HashMap();
    ScrolledComposite sc = null;
    Font boldFont = null;
    MouseListener focusMaster = new MouseListener(){

        public void mouseDoubleClick(MouseEvent e) {
        }

        public void mouseDown(MouseEvent e) {
            OptionSetMediaScreen.this.comp.forceFocus();
        }

        public void mouseUp(MouseEvent e) {
        }
    };
    Color dividerColor;
    Composite mediaComposite = null;
    Brand currentBrand = null;
    String currentLanguage = null;

    public OptionSetMediaScreen(Element element) {
        super(element);
        this.bindingManager = (MediaBindingManager)element.getConfigurationManager("org.eclipse.vtp.configuration.media");
        this.info = (OptionSetInformationProvider)((PrimitiveElement)element).getInformationProvider();
    }

    public void save() {
        this.getElement().commitConfigurationChanges((ConfigurationManager)this.bindingManager);
    }

    public void cancel() {
        this.getElement().rollbackConfigurationChanges((ConfigurationManager)this.bindingManager);
    }

    public void createControls(Composite parent) {
        GridData gd;
        GridData gd2;
        this.boldFont = new Font((Device)parent.getDisplay(), parent.getFont().getFontData()[0].getName(), parent.getFont().getFontData()[0].getHeight(), 1);
        this.toolkit = new FormToolkit(parent.getDisplay());
        this.sc = new ScrolledComposite(parent, 512);
        this.sc.getVerticalBar().setIncrement(4);
        this.comp = new Composite((Composite)this.sc, 0);
        this.sc.setContent((Control)this.comp);
        this.comp.addMouseListener(this.focusMaster);
        this.comp.setBackground(parent.getBackground());
        this.comp.setLayout((Layout)new GridLayout(1, false));
        this.mediaComposite = new Composite(this.comp, 0);
        this.mediaComposite.setBackground(this.comp.getBackground());
        this.mediaComposite.setLayoutData((Object)new GridData(768));
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.verticalSpacing = 1;
        this.mediaComposite.setLayout((Layout)gridLayout);
        this.contentSection = this.toolkit.createSection(this.mediaComposite, 256);
        GridData gridData = new GridData(770);
        gridData.horizontalSpan = 2;
        this.contentSection.setLayoutData((Object)gridData);
        this.contentSection.setText("Options");
        this.addOptionComposite = this.createPropertyLabel(this.mediaComposite, "");
        Composite containerComp = this.createWrapperComposite(this.mediaComposite);
        this.addOptionButton = new Button(containerComp, 8);
        this.addOptionButton.setText("Add Option");
        this.addOptionButton.setLayoutData((Object)new GridData());
        this.addOptionButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                List currentOptions = OptionSetMediaScreen.this.info.getChoicesByBrand(OptionSetMediaScreen.this.currentBrand.getName());
                if (currentOptions.size() != 0) {
                    MenuChoice cfr_ignored_0 = (MenuChoice)currentOptions.get(currentOptions.size() - 1);
                }
                NewMenuChoiceWizard nmo = new NewMenuChoiceWizard(OptionSetMediaScreen.this.currentBrand.getName(), OptionSetMediaScreen.this.info);
                WizardDialog wd = new WizardDialog(Display.getCurrent().getActiveShell(), (IWizard)nmo);
                if (wd.open() == 0) {
                    OptionSetMediaScreen.this.setBrand(OptionSetMediaScreen.this.currentBrand);
                    OptionSetMediaScreen.this.setLanguage(OptionSetMediaScreen.this.currentLanguage);
                }
            }
        });
        Composite spacerComp = new Composite(this.mediaComposite, 0);
        spacerComp.setBackground(this.mediaComposite.getBackground());
        gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        gridData.heightHint = 15;
        spacerComp.setLayoutData((Object)gridData);
        Composite settingsComposite = new Composite(this.comp, 0);
        settingsComposite.setBackground(this.comp.getBackground());
        settingsComposite.setLayoutData((Object)new GridData(768));
        settingsComposite.setLayout((Layout)new GridLayout(2, false));
        Section settingsSection = this.toolkit.createSection(settingsComposite, 256);
        gridData = new GridData(770);
        gridData.horizontalSpan = 2;
        settingsSection.setLayoutData((Object)gridData);
        settingsSection.setText("Settings");
        Label inputModeLabel = this.createPropertyLabel(settingsComposite, "User Input Style");
        inputModeLabel.setToolTipText("This property selects the valid ways\r\na caller can provide input:\r\n\t*DTMF - Touchtone keypad only\t*Voice - Speech recognition only\t*Hybrid - Touchtone or speech accepted");
        containerComp = this.createWrapperComposite(settingsComposite);
        this.inputModeCombo = this.createValueDropDown(containerComp);
        this.inputModeCombo.add("Dtmf Only");
        this.inputModeCombo.add("Voice Only");
        this.inputModeCombo.add("Hybrid");
        this.inputModeCombo.select(0);
        this.inputModeCombo.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                try {
                    GridData gd;
                    GridData gd2;
                    PropertyMediaBinding propertyBinding = OptionSetMediaScreen.this.bindingManager.getPropertyBinding("input-mode");
                    PropertyBindingItem pbi = (PropertyBindingItem)propertyBinding.getPropertyItem(OptionSetMediaScreen.this.currentBrand.getName(), OptionSetMediaScreen.this.getInteractionType()).clone();
                    pbi.setValue(OptionSetMediaScreen.this.inputModeCombo.getItem(OptionSetMediaScreen.this.inputModeCombo.getSelectionIndex()));
                    propertyBinding.putPropertyItem(OptionSetMediaScreen.this.currentBrand.getName(), OptionSetMediaScreen.this.getInteractionType(), pbi);
                    for (Control control : OptionSetMediaScreen.this.dtmfWidgets) {
                        gd2 = (GridData)control.getLayoutData();
                        control.setVisible(false);
                        gd2.exclude = true;
                    }
                    for (Control control : OptionSetMediaScreen.this.voiceWidgets) {
                        gd2 = (GridData)control.getLayoutData();
                        control.setVisible(false);
                        gd2.exclude = true;
                    }
                    int sel = OptionSetMediaScreen.this.inputModeCombo.getSelectionIndex();
                    if (sel == 2 || sel == 0) {
                        for (Control control : OptionSetMediaScreen.this.dtmfWidgets) {
                            gd = (GridData)control.getLayoutData();
                            control.setVisible(true);
                            gd.exclude = false;
                        }
                    }
                    if (sel == 2 || sel == 1) {
                        for (Control control : OptionSetMediaScreen.this.voiceWidgets) {
                            gd = (GridData)control.getLayoutData();
                            control.setVisible(true);
                            gd.exclude = false;
                        }
                    }
                    Point preferred = OptionSetMediaScreen.this.comp.computeSize(OptionSetMediaScreen.this.sc.getMinWidth(), -1, true);
                    OptionSetMediaScreen.this.sc.setMinSize(preferred);
                    OptionSetMediaScreen.this.comp.layout();
                    if (preferred.y > OptionSetMediaScreen.this.sc.getClientArea().height) {
                        preferred = OptionSetMediaScreen.this.comp.computeSize(OptionSetMediaScreen.this.sc.getClientArea().width, -1, true);
                        OptionSetMediaScreen.this.sc.setMinSize(preferred);
                        OptionSetMediaScreen.this.comp.layout();
                    }
                    OptionSetMediaScreen.this.comp.getDisplay().asyncExec(new Runnable(){

                        public void run() {
                            (this).OptionSetMediaScreen.this.comp.layout(true, true);
                        }
                    });
                }
                catch (RuntimeException e1) {
                    e1.printStackTrace();
                }
            }
        });
        Label bargeLabel = this.createPropertyLabel(settingsComposite, "Barge-in Enabled");
        bargeLabel.setToolTipText("Determines whether the caller can\r\ninterrupt the prompt to begin entry");
        containerComp = this.createWrapperComposite(settingsComposite);
        this.barginCombo = this.createValueDropDown(containerComp);
        this.barginCombo.add("true");
        this.barginCombo.add("false");
        this.barginCombo.select(0);
        this.barginCombo.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                PropertyMediaBinding propertyBinding = OptionSetMediaScreen.this.bindingManager.getPropertyBinding("barge-in");
                PropertyBindingItem pbi = (PropertyBindingItem)propertyBinding.getPropertyItem(OptionSetMediaScreen.this.currentBrand.getName(), OptionSetMediaScreen.this.getInteractionType()).clone();
                pbi.setValue(OptionSetMediaScreen.this.barginCombo.getItem(OptionSetMediaScreen.this.barginCombo.getSelectionIndex()));
                propertyBinding.putPropertyItem(OptionSetMediaScreen.this.currentBrand.getName(), OptionSetMediaScreen.this.getInteractionType(), pbi);
            }
        });
        Label initialTimeoutLabel = this.createPropertyLabel(settingsComposite, "Initial Input Timeout (Seconds)");
        initialTimeoutLabel.setToolTipText("The amount of time in seconds to wait\r\nfor the caller to begin input before\r\na NoInput event.");
        containerComp = this.createWrapperComposite(settingsComposite);
        this.initialTimeoutSpinner = this.createValueSpinner(containerComp, 0, 100, 0, 0);
        this.initialTimeoutSpinner.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                PropertyMediaBinding propertyBinding = OptionSetMediaScreen.this.bindingManager.getPropertyBinding("initial-timeout");
                PropertyBindingItem pbi = (PropertyBindingItem)propertyBinding.getPropertyItem(OptionSetMediaScreen.this.currentBrand.getName(), OptionSetMediaScreen.this.getInteractionType()).clone();
                pbi.setValue(Integer.toString(OptionSetMediaScreen.this.initialTimeoutSpinner.getSelection()));
                propertyBinding.putPropertyItem(OptionSetMediaScreen.this.currentBrand.getName(), OptionSetMediaScreen.this.getInteractionType(), pbi);
            }
        });
        Label terminationTimeoutLabel = this.createPropertyLabel(settingsComposite, "Termination Timeout (Seconds)");
        terminationTimeoutLabel.setToolTipText("The amount of time in seconds to wait\r\nfor additional input after a selection\r\nhas been matched.");
        this.dtmfWidgets.add(terminationTimeoutLabel);
        containerComp = this.createWrapperComposite(settingsComposite);
        this.dtmfWidgets.add(containerComp);
        this.terminationTimeoutSpinner = this.createValueSpinner(containerComp, 0, 100, 0, 0);
        this.terminationTimeoutSpinner.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                PropertyMediaBinding propertyBinding = OptionSetMediaScreen.this.bindingManager.getPropertyBinding("termination-timeout");
                PropertyBindingItem pbi = (PropertyBindingItem)propertyBinding.getPropertyItem(OptionSetMediaScreen.this.currentBrand.getName(), OptionSetMediaScreen.this.getInteractionType()).clone();
                pbi.setValue(Integer.toString(OptionSetMediaScreen.this.terminationTimeoutSpinner.getSelection()));
                propertyBinding.putPropertyItem(OptionSetMediaScreen.this.currentBrand.getName(), OptionSetMediaScreen.this.getInteractionType(), pbi);
            }
        });
        Label speechIncompleteTimeoutLabel = this.createPropertyLabel(settingsComposite, "Speech Incomplete Timeout (Seconds)");
        speechIncompleteTimeoutLabel.setToolTipText("The amount of time in seconds to wait\r\nfor additional input if the current entry\r\ndoes not match the provided grammar.");
        this.voiceWidgets.add(speechIncompleteTimeoutLabel);
        containerComp = this.createWrapperComposite(settingsComposite);
        this.voiceWidgets.add(containerComp);
        this.speechIncompleteTimeoutSpinner = this.createValueSpinner(containerComp, 0, 100, 0, 0);
        this.speechIncompleteTimeoutSpinner.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                PropertyMediaBinding propertyBinding = OptionSetMediaScreen.this.bindingManager.getPropertyBinding("speech-incomplete-timeout");
                PropertyBindingItem pbi = (PropertyBindingItem)propertyBinding.getPropertyItem(OptionSetMediaScreen.this.currentBrand.getName(), OptionSetMediaScreen.this.getInteractionType()).clone();
                pbi.setValue(Integer.toString(OptionSetMediaScreen.this.speechIncompleteTimeoutSpinner.getSelection()));
                propertyBinding.putPropertyItem(OptionSetMediaScreen.this.currentBrand.getName(), OptionSetMediaScreen.this.getInteractionType(), pbi);
            }
        });
        Label speechCompleteTimeoutLabel = this.createPropertyLabel(settingsComposite, "Speech Completion Timeout (Seconds)");
        speechCompleteTimeoutLabel.setToolTipText("The amount of time in seconds to wait\r\nfor additional input if the current entry\r\nalready matches the provided grammar.");
        this.voiceWidgets.add(speechCompleteTimeoutLabel);
        containerComp = this.createWrapperComposite(settingsComposite);
        this.voiceWidgets.add(containerComp);
        this.speechCompleteTimeoutSpinner = this.createValueSpinner(containerComp, 0, 100, 0, 0);
        this.speechCompleteTimeoutSpinner.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                PropertyMediaBinding propertyBinding = OptionSetMediaScreen.this.bindingManager.getPropertyBinding("speech-complete-timeout");
                PropertyBindingItem pbi = (PropertyBindingItem)propertyBinding.getPropertyItem(OptionSetMediaScreen.this.currentBrand.getName(), OptionSetMediaScreen.this.getInteractionType()).clone();
                pbi.setValue(Integer.toString(OptionSetMediaScreen.this.speechCompleteTimeoutSpinner.getSelection()));
                propertyBinding.putPropertyItem(OptionSetMediaScreen.this.currentBrand.getName(), OptionSetMediaScreen.this.getInteractionType(), pbi);
            }
        });
        Label maxSpeechTimeoutLabel = this.createPropertyLabel(settingsComposite, "Maximum Speech Length (Seconds)");
        maxSpeechTimeoutLabel.setToolTipText("The maximum length of speech input\r\nin seconds that will be accepted.");
        this.voiceWidgets.add(maxSpeechTimeoutLabel);
        containerComp = this.createWrapperComposite(settingsComposite);
        this.voiceWidgets.add(containerComp);
        this.maxSpeechTimeoutSpinner = this.createValueSpinner(containerComp, 10, 300, 0, 0);
        this.maxSpeechTimeoutSpinner.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                PropertyMediaBinding propertyBinding = OptionSetMediaScreen.this.bindingManager.getPropertyBinding("max-speech-timeout");
                PropertyBindingItem pbi = (PropertyBindingItem)propertyBinding.getPropertyItem(OptionSetMediaScreen.this.currentBrand.getName(), OptionSetMediaScreen.this.getInteractionType()).clone();
                pbi.setValue(Integer.toString(OptionSetMediaScreen.this.maxSpeechTimeoutSpinner.getSelection()));
                propertyBinding.putPropertyItem(OptionSetMediaScreen.this.currentBrand.getName(), OptionSetMediaScreen.this.getInteractionType(), pbi);
            }
        });
        Label confidenceLevelLabel = this.createPropertyLabel(settingsComposite, "Confidence Level Accepted");
        confidenceLevelLabel.setToolTipText("The minimum level of confidence accepted\r\nby the speech recognition provider.");
        this.voiceWidgets.add(confidenceLevelLabel);
        containerComp = this.createWrapperComposite(settingsComposite);
        this.voiceWidgets.add(containerComp);
        this.confidenceLevelSpinner = this.createValueSpinner(containerComp, 0, 100, 0, 0);
        this.confidenceLevelSpinner.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                PropertyMediaBinding propertyBinding = OptionSetMediaScreen.this.bindingManager.getPropertyBinding("confidence-level");
                PropertyBindingItem pbi = (PropertyBindingItem)propertyBinding.getPropertyItem(OptionSetMediaScreen.this.currentBrand.getName(), OptionSetMediaScreen.this.getInteractionType()).clone();
                pbi.setValue(Integer.toString(OptionSetMediaScreen.this.confidenceLevelSpinner.getSelection()));
                propertyBinding.putPropertyItem(OptionSetMediaScreen.this.currentBrand.getName(), OptionSetMediaScreen.this.getInteractionType(), pbi);
            }
        });
        Label sensitivityLabel = this.createPropertyLabel(settingsComposite, "Caller Environment");
        sensitivityLabel.setToolTipText("Determines how sensitive the speech recognition\r\nwill be to background noise.  The lower the number,\r\nthe less senitive the system will be");
        this.voiceWidgets.add(sensitivityLabel);
        containerComp = this.createWrapperComposite(settingsComposite);
        this.voiceWidgets.add(containerComp);
        this.sensitivitySpinner = this.createValueSpinner(containerComp, 0, 100, 0, 0);
        this.sensitivitySpinner.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                PropertyMediaBinding propertyBinding = OptionSetMediaScreen.this.bindingManager.getPropertyBinding("sensitivity-level");
                PropertyBindingItem pbi = (PropertyBindingItem)propertyBinding.getPropertyItem(OptionSetMediaScreen.this.currentBrand.getName(), OptionSetMediaScreen.this.getInteractionType()).clone();
                pbi.setValue(Integer.toString(OptionSetMediaScreen.this.sensitivitySpinner.getSelection()));
                propertyBinding.putPropertyItem(OptionSetMediaScreen.this.currentBrand.getName(), OptionSetMediaScreen.this.getInteractionType(), pbi);
            }
        });
        Label speedVsAccuracyLabel = this.createPropertyLabel(settingsComposite, "Speed Vs Accuracy");
        speedVsAccuracyLabel.setToolTipText("A hint to the speech recognition platform indicating\r\nrelative focus between the speed in which the result\r\nis returned and the accuracy of that result.  The\r\nlower the number, the faster the entry is processed\r\nbut accuracy may be reduced.");
        this.voiceWidgets.add(speedVsAccuracyLabel);
        containerComp = this.createWrapperComposite(settingsComposite);
        this.voiceWidgets.add(containerComp);
        this.speedVsAccuracySpinner = this.createValueSpinner(containerComp, 0, 100, 0, 0);
        this.speedVsAccuracySpinner.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                PropertyMediaBinding propertyBinding = OptionSetMediaScreen.this.bindingManager.getPropertyBinding("speed-vs-accuracy");
                PropertyBindingItem pbi = (PropertyBindingItem)propertyBinding.getPropertyItem(OptionSetMediaScreen.this.currentBrand.getName(), OptionSetMediaScreen.this.getInteractionType()).clone();
                pbi.setValue(Integer.toString(OptionSetMediaScreen.this.speedVsAccuracySpinner.getSelection()));
                propertyBinding.putPropertyItem(OptionSetMediaScreen.this.currentBrand.getName(), OptionSetMediaScreen.this.getInteractionType(), pbi);
            }
        });
        this.comp.addControlListener(new ControlListener(){

            public void controlMoved(ControlEvent e) {
            }

            public void controlResized(ControlEvent e) {
                OptionSetMediaScreen.this.comp.removeControlListener((ControlListener)this);
                OptionSetMediaScreen.this.sc.setAlwaysShowScrollBars(true);
                Rectangle clientArea = OptionSetMediaScreen.this.sc.getClientArea();
                OptionSetMediaScreen.this.sc.setAlwaysShowScrollBars(false);
                if (OptionSetMediaScreen.this.sc.getVerticalBar() != null) {
                    OptionSetMediaScreen.this.sc.getVerticalBar().setVisible(false);
                }
                OptionSetMediaScreen.this.sc.setMinSize(new Point(clientArea.width, clientArea.height));
                OptionSetMediaScreen.this.sc.layout(true, true);
                OptionSetMediaScreen.this.sc.redraw();
            }
        });
        this.sc.setMinWidth(this.comp.computeSize((int)-1, (int)-1, (boolean)true).x);
        for (Control control : this.dtmfWidgets) {
            gd2 = (GridData)control.getLayoutData();
            control.setVisible(false);
            gd2.exclude = true;
        }
        for (Control control : this.voiceWidgets) {
            gd2 = (GridData)control.getLayoutData();
            control.setVisible(false);
            gd2.exclude = true;
        }
        int sel = this.inputModeCombo.getSelectionIndex();
        if (sel == 2 || sel == 0) {
            for (Control control : this.dtmfWidgets) {
                gd = (GridData)control.getLayoutData();
                control.setVisible(true);
                gd.exclude = false;
            }
        }
        if (sel == 2 || sel == 1) {
            for (Control control : this.voiceWidgets) {
                gd = (GridData)control.getLayoutData();
                control.setVisible(true);
                gd.exclude = false;
            }
        }
        this.sc.setMinHeight(this.comp.computeSize((int)-1, (int)-1, (boolean)true).y);
        this.sc.setExpandHorizontal(true);
        this.sc.setExpandVertical(true);
        this.setControl((Control)this.sc);
        this.sc.getDisplay().asyncExec(new Runnable(){

            public void run() {
                GridData gd;
                GridData gd2;
                for (Control control : OptionSetMediaScreen.this.dtmfWidgets) {
                    gd2 = (GridData)control.getLayoutData();
                    control.setVisible(false);
                    gd2.exclude = true;
                }
                for (Control control : OptionSetMediaScreen.this.voiceWidgets) {
                    gd2 = (GridData)control.getLayoutData();
                    control.setVisible(false);
                    gd2.exclude = true;
                }
                int sel = OptionSetMediaScreen.this.inputModeCombo.getSelectionIndex();
                if (sel == 2 || sel == 0) {
                    for (Control control : OptionSetMediaScreen.this.dtmfWidgets) {
                        gd = (GridData)control.getLayoutData();
                        control.setVisible(true);
                        gd.exclude = false;
                    }
                }
                if (sel == 2 || sel == 1) {
                    for (Control control : OptionSetMediaScreen.this.voiceWidgets) {
                        gd = (GridData)control.getLayoutData();
                        control.setVisible(true);
                        gd.exclude = false;
                    }
                }
                Point preferred = OptionSetMediaScreen.this.comp.computeSize(OptionSetMediaScreen.this.sc.getMinWidth(), -1, true);
                OptionSetMediaScreen.this.sc.setMinSize(preferred);
                OptionSetMediaScreen.this.comp.layout();
                if (preferred.y > OptionSetMediaScreen.this.sc.getClientArea().height) {
                    preferred = OptionSetMediaScreen.this.comp.computeSize(OptionSetMediaScreen.this.sc.getClientArea().width, -1, true);
                    OptionSetMediaScreen.this.sc.setMinSize(preferred);
                    OptionSetMediaScreen.this.comp.layout();
                }
            }
        });
    }

    public String getInteractionType() {
        return "org.eclipse.vtp.framework.interactions.voice.interaction";
    }

    public void setBrand(Brand brand) {
        this.currentBrand = brand;
        this.updateValues();
    }

    private void updateValues() {
        try {
            GridData gd;
            GridData gd2;
            for (List controls : this.optionControlMap.values()) {
                int c = 0;
                while (c < controls.size()) {
                    Control control = (Control)controls.get(c);
                    control.dispose();
                    this.dtmfWidgets.remove(control);
                    this.voiceWidgets.remove(control);
                    ++c;
                }
            }
            this.moveUpButtons = new HashMap();
            this.moveDownButtons = new HashMap();
            this.optionControlMap = new HashMap();
            this.optionPromptMap = new HashMap();
            this.optionGrammarMap = new HashMap();
            List options = this.info.getChoicesByBrand(this.currentBrand.getName());
            int i = 0;
            while (i < options.size()) {
                MenuChoice mc = (MenuChoice)options.get(i);
                List createOptionControls = this.createOptionControls(this.mediaComposite, mc);
                for (Control control : createOptionControls) {
                    control.moveAbove(this.addOptionComposite);
                }
                this.optionControlMap.put(mc, createOptionControls);
                ++i;
            }
            PropertyMediaBinding inputModePropertyBinding = this.bindingManager.getPropertyBinding("input-mode");
            PropertyBindingItem pbi3 = inputModePropertyBinding.getPropertyItem(this.currentBrand.getName(), this.getInteractionType());
            if ("Voice Only".equals(pbi3.getValue())) {
                this.inputModeCombo.select(1);
            } else if ("Hybrid".equals(pbi3.getValue())) {
                this.inputModeCombo.select(2);
            } else {
                this.inputModeCombo.select(0);
            }
            PropertyMediaBinding bargeinPropertyBinding = this.bindingManager.getPropertyBinding("barge-in");
            PropertyBindingItem pbi = bargeinPropertyBinding.getPropertyItem(this.currentBrand.getName(), this.getInteractionType());
            if ("false".equals(pbi.getValue())) {
                this.barginCombo.select(1);
            } else {
                this.barginCombo.select(0);
            }
            PropertyMediaBinding initialTimeoutPropertyBinding = this.bindingManager.getPropertyBinding("initial-timeout");
            PropertyBindingItem pbi2 = initialTimeoutPropertyBinding.getPropertyItem(this.currentBrand.getName(), this.getInteractionType());
            if (pbi2.getValue() == null) {
                this.initialTimeoutSpinner.setSelection(0);
            } else {
                this.initialTimeoutSpinner.setSelection(Integer.parseInt(pbi2.getValue()));
            }
            PropertyMediaBinding terminationTimeoutPropertyBinding = this.bindingManager.getPropertyBinding("termination-timeout");
            pbi2 = terminationTimeoutPropertyBinding.getPropertyItem(this.currentBrand.getName(), this.getInteractionType());
            if (pbi2.getValue() == null) {
                this.terminationTimeoutSpinner.setSelection(0);
            } else {
                this.terminationTimeoutSpinner.setSelection(Integer.parseInt(pbi2.getValue()));
            }
            PropertyMediaBinding speechIncompleteTimeoutPropertyBinding = this.bindingManager.getPropertyBinding("speech-incomplete-timeout");
            pbi2 = speechIncompleteTimeoutPropertyBinding.getPropertyItem(this.currentBrand.getName(), this.getInteractionType());
            if (pbi2.getValue() == null) {
                this.speechIncompleteTimeoutSpinner.setSelection(0);
            } else {
                this.speechIncompleteTimeoutSpinner.setSelection(Integer.parseInt(pbi2.getValue()));
            }
            PropertyMediaBinding speechCompleteTimeoutPropertyBinding = this.bindingManager.getPropertyBinding("speech-complete-timeout");
            pbi2 = speechCompleteTimeoutPropertyBinding.getPropertyItem(this.currentBrand.getName(), this.getInteractionType());
            if (pbi2.getValue() == null) {
                this.speechCompleteTimeoutSpinner.setSelection(0);
            } else {
                this.speechCompleteTimeoutSpinner.setSelection(Integer.parseInt(pbi2.getValue()));
            }
            PropertyMediaBinding maxSpeechTimeoutPropertyBinding = this.bindingManager.getPropertyBinding("max-speech-timeout");
            pbi2 = maxSpeechTimeoutPropertyBinding.getPropertyItem(this.currentBrand.getName(), this.getInteractionType());
            if (pbi2.getValue() == null) {
                this.maxSpeechTimeoutSpinner.setSelection(0);
            } else {
                this.maxSpeechTimeoutSpinner.setSelection(Integer.parseInt(pbi2.getValue()));
            }
            PropertyMediaBinding confidenceLevelPropertyBinding = this.bindingManager.getPropertyBinding("confidence-level");
            pbi2 = confidenceLevelPropertyBinding.getPropertyItem(this.currentBrand.getName(), this.getInteractionType());
            if (pbi2.getValue() == null) {
                this.confidenceLevelSpinner.setSelection(0);
            } else {
                this.confidenceLevelSpinner.setSelection(Integer.parseInt(pbi2.getValue()));
            }
            PropertyMediaBinding sensitivityLevelPropertyBinding = this.bindingManager.getPropertyBinding("sensitivity-level");
            pbi2 = sensitivityLevelPropertyBinding.getPropertyItem(this.currentBrand.getName(), this.getInteractionType());
            if (pbi2.getValue() == null) {
                this.sensitivitySpinner.setSelection(0);
            } else {
                this.sensitivitySpinner.setSelection(Integer.parseInt(pbi2.getValue()));
            }
            PropertyMediaBinding speedVsAccuracyPropertyBinding = this.bindingManager.getPropertyBinding("speed-vs-accuracy");
            pbi2 = speedVsAccuracyPropertyBinding.getPropertyItem(this.currentBrand.getName(), this.getInteractionType());
            if (pbi2.getValue() == null) {
                this.speedVsAccuracySpinner.setSelection(0);
            } else {
                this.speedVsAccuracySpinner.setSelection(Integer.parseInt(pbi2.getValue()));
            }
            for (PromptBindingViewer viewer : this.optionPromptMap.values()) {
                viewer.setCurrentBrand(this.currentBrand);
            }
            for (PromptBindingViewer viewer : this.optionGrammarMap.values()) {
                viewer.setCurrentBrand(this.currentBrand);
            }
            for (Control control : this.dtmfWidgets) {
                gd2 = (GridData)control.getLayoutData();
                control.setVisible(false);
                gd2.exclude = true;
            }
            for (Control control : this.voiceWidgets) {
                gd2 = (GridData)control.getLayoutData();
                control.setVisible(false);
                gd2.exclude = true;
            }
            int sel = this.inputModeCombo.getSelectionIndex();
            if (sel == 2 || sel == 0) {
                for (Control control : this.dtmfWidgets) {
                    gd = (GridData)control.getLayoutData();
                    control.setVisible(true);
                    gd.exclude = false;
                }
            }
            if (sel == 2 || sel == 1) {
                for (Control control : this.voiceWidgets) {
                    gd = (GridData)control.getLayoutData();
                    control.setVisible(true);
                    gd.exclude = false;
                }
            }
            Point preferred = this.comp.computeSize(this.sc.getMinWidth(), -1, true);
            this.sc.setMinSize(preferred);
            this.comp.layout();
            if (preferred.y > this.sc.getClientArea().height) {
                preferred = this.comp.computeSize(this.sc.getClientArea().width, -1, true);
                this.sc.setMinSize(preferred);
                this.comp.layout();
            }
            this.updateButtons();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setLanguage(String language) {
        this.currentLanguage = language;
        for (PromptBindingViewer viewer : this.optionPromptMap.values()) {
            viewer.setCurrentLanguage(language);
        }
        for (PromptBindingViewer viewer : this.optionGrammarMap.values()) {
            viewer.setCurrentLanguage(language);
        }
    }

    public Composite createWrapperComposite(Composite parent) {
        return this.createWrapperComposite(parent, 20);
    }

    public Composite createWrapperComposite(Composite parent, int indent) {
        Composite containerComp = new Composite(parent, 0);
        containerComp.addMouseListener(this.focusMaster);
        containerComp.setBackground(parent.getBackground());
        GridData gridData = new GridData(802);
        gridData.horizontalIndent = indent;
        gridData.widthHint = 175;
        GridLayout gl = new GridLayout(1, false);
        gl.horizontalSpacing = 0;
        gl.verticalSpacing = 0;
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        containerComp.setLayout((Layout)gl);
        containerComp.setLayoutData((Object)gridData);
        return containerComp;
    }

    public Label createOptionLabel(Composite parent, String text) {
        Label ret = new Label(parent, 0);
        ret.addMouseListener(this.focusMaster);
        ret.setText(text);
        ret.setBackground(parent.getBackground());
        GridData gd = new GridData();
        gd.verticalAlignment = 1024;
        gd.verticalIndent = 4;
        gd.horizontalIndent = 10;
        gd.minimumHeight = 21;
        gd.heightHint = 21;
        ret.setLayoutData((Object)gd);
        return ret;
    }

    public Label createPropertyLabel(Composite parent, String text) {
        Label ret = new Label(parent, 0);
        ret.addMouseListener(this.focusMaster);
        ret.setText(text);
        ret.setBackground(parent.getBackground());
        GridData gd = new GridData();
        gd.verticalAlignment = 1024;
        gd.verticalIndent = 4;
        gd.horizontalIndent = 30;
        gd.minimumHeight = 21;
        gd.heightHint = 21;
        ret.setLayoutData((Object)gd);
        return ret;
    }

    public RowDivider createRowDivider(Composite parent, Color dividerColor) {
        RowDivider rd1 = new RowDivider(parent, 0);
        rd1.setBackground(parent.getBackground());
        rd1.setForeground(dividerColor);
        GridData gd = new GridData(768);
        gd.heightHint = 3;
        gd.horizontalIndent = 20;
        gd.horizontalSpan = 2;
        rd1.setLayoutData(gd);
        return rd1;
    }

    private Combo createValueDropDown(Composite parent) {
        Combo ret = new Combo(parent, 2060);
        GridData gd = new GridData();
        gd.verticalIndent = 1;
        gd.horizontalAlignment = 131072;
        gd.grabExcessHorizontalSpace = true;
        ret.setLayoutData((Object)gd);
        return ret;
    }

    public Spinner createValueSpinner(Composite parent, int min, int max, int digits, int value) {
        Spinner ret = new Spinner(parent, 2048);
        ret.setMinimum(min);
        ret.setMaximum(max);
        ret.setDigits(digits);
        ret.setSelection(value);
        GridData gd = new GridData();
        gd.verticalIndent = 1;
        gd.horizontalAlignment = 131072;
        gd.grabExcessHorizontalSpace = true;
        ret.setLayoutData((Object)gd);
        return ret;
    }

    public List createOptionControls(final Composite canvas, final MenuChoice option) {
        System.out.println("Creating option controls");
        ArrayList<Object> controlList = new ArrayList<Object>();
        Label option1Label = this.createOptionLabel(canvas, option.getOptionName());
        option1Label.setFont(this.boldFont);
        controlList.add(option1Label);
        Composite optHeaderComp = new Composite(canvas, 0);
        FillLayout fl = new FillLayout();
        optHeaderComp.setLayout((Layout)fl);
        optHeaderComp.setBackground(canvas.getBackground());
        if (this.moveUpButtons == null) {
            this.moveUpButtons = new HashMap();
            this.moveDownButtons = new HashMap();
        }
        ToolBar tb = new ToolBar(optHeaderComp, 0x800000);
        tb.setBackground(optHeaderComp.getBackground());
        ToolItem guardScriptButton = new ToolItem(tb, 8);
        guardScriptButton.setImage(Activator.getDefault().getImageRegistry().get("ICON_SCRIPT"));
        guardScriptButton.setToolTipText("Edit Guard Condition");
        guardScriptButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    MenuOptionScriptDialog mosd = new MenuOptionScriptDialog(Display.getCurrent().getActiveShell());
                    mosd.setMenuChoice(option);
                    mosd.open();
                }
                catch (RuntimeException e1) {
                    e1.printStackTrace();
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        ToolItem moveUpButton = new ToolItem(tb, 8);
        moveUpButton.setImage(Activator.getDefault().getImageRegistry().get("ICON_MOVE_UP"));
        moveUpButton.setToolTipText("Move Option Up");
        this.moveUpButtons.put(option, moveUpButton);
        System.out.println(this.moveUpButtons.get(option));
        moveUpButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                List currentOptions = OptionSetMediaScreen.this.info.getChoicesByBrand(OptionSetMediaScreen.this.currentBrand.getName());
                MenuChoice targetOption = null;
                int i = 0;
                while (i < currentOptions.size()) {
                    if (currentOptions.get(i) == option && i != 0) {
                        targetOption = (MenuChoice)currentOptions.get(i - 1);
                    }
                    ++i;
                }
                if (targetOption != null) {
                    List targetControlList = (List)OptionSetMediaScreen.this.optionControlMap.get(targetOption);
                    List mobileControlList = (List)OptionSetMediaScreen.this.optionControlMap.get(option);
                    Control cfr_ignored_0 = (Control)targetControlList.get(0);
                    int i2 = 0;
                    while (i2 < mobileControlList.size()) {
                        ((Control)mobileControlList.get(i2)).moveAbove((Control)targetControlList.get(0));
                        ++i2;
                    }
                    OptionSetMediaScreen.this.info.moveChoiceUp(OptionSetMediaScreen.this.currentBrand.getName(), option);
                    OptionSetMediaScreen.this.updateButtons();
                    canvas.layout(true, true);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        ToolItem moveDownButton = new ToolItem(tb, 8);
        moveDownButton.setImage(Activator.getDefault().getImageRegistry().get("ICON_MOVE_DOWN"));
        moveDownButton.setToolTipText("Move Option Down");
        this.moveDownButtons.put(option, moveDownButton);
        moveDownButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                List currentOptions = OptionSetMediaScreen.this.info.getChoicesByBrand(OptionSetMediaScreen.this.currentBrand.getName());
                MenuChoice targetOption = option;
                MenuChoice mobileOption = null;
                int i = 0;
                while (i < currentOptions.size()) {
                    if (currentOptions.get(i) == option && i < currentOptions.size() - 1) {
                        mobileOption = (MenuChoice)currentOptions.get(i + 1);
                    }
                    ++i;
                }
                if (mobileOption != null) {
                    List targetControlList = (List)OptionSetMediaScreen.this.optionControlMap.get(targetOption);
                    List mobileControlList = (List)OptionSetMediaScreen.this.optionControlMap.get(mobileOption);
                    Control cfr_ignored_0 = (Control)targetControlList.get(0);
                    int i2 = 0;
                    while (i2 < mobileControlList.size()) {
                        ((Control)mobileControlList.get(i2)).moveAbove((Control)targetControlList.get(0));
                        ++i2;
                    }
                    OptionSetMediaScreen.this.info.moveChoiceDown(OptionSetMediaScreen.this.currentBrand.getName(), option);
                    OptionSetMediaScreen.this.updateButtons();
                    canvas.layout(true, true);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        ToolItem deleteButton = new ToolItem(tb, 8);
        deleteButton.setImage(PlatformUI.getWorkbench().getSharedImages().getImage("IMG_TOOL_DELETE"));
        deleteButton.setToolTipText("Remove Option");
        deleteButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                List controlList = (List)OptionSetMediaScreen.this.optionControlMap.get(option);
                OptionSetMediaScreen.this.moveUpButtons.remove(option);
                OptionSetMediaScreen.this.moveDownButtons.remove(option);
                OptionSetMediaScreen.this.optionPromptMap.remove(option);
                OptionSetMediaScreen.this.optionGrammarMap.remove(option);
                int i = 0;
                while (i < controlList.size()) {
                    ((Control)controlList.get(i)).dispose();
                    OptionSetMediaScreen.this.dtmfWidgets.remove(controlList.get(i));
                    OptionSetMediaScreen.this.voiceWidgets.remove(controlList.get(i));
                    ++i;
                }
                OptionSetMediaScreen.this.optionControlMap.remove(option);
                OptionSetMediaScreen.this.info.removeChoice(OptionSetMediaScreen.this.currentBrand.getName(), option);
                OptionSetMediaScreen.this.updateButtons();
                canvas.layout(true, true);
                OptionSetMediaScreen.this.comp.layout();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        GridData gd = new GridData();
        gd.horizontalAlignment = 131072;
        optHeaderComp.setLayoutData((Object)gd);
        controlList.add(optHeaderComp);
        this.dividerColor = new Color((Device)Display.getCurrent(), 231, 233, 240);
        this.comp.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                OptionSetMediaScreen.this.dividerColor.dispose();
                OptionSetMediaScreen.this.boldFont.dispose();
            }
        });
        RowDivider ord1 = this.createRowDivider(canvas, this.dividerColor);
        controlList.add((Object)ord1);
        Label optionPromptLabel = this.createPropertyLabel(canvas, "Prompt");
        controlList.add(optionPromptLabel);
        PromptMediaBinding promptBinding = this.bindingManager.getPromptBinding(String.valueOf(option.getOptionName()) + "-prompt");
        System.out.println(this.currentBrand.getName());
        System.out.println(this.currentLanguage);
        PromptBindingItem pitem = promptBinding.getPromptItem(this.currentBrand.getName(), this.getInteractionType(), this.currentLanguage);
        List pitementries = pitem.getEntries();
        System.out.println(pitementries.size());
        int p = 0;
        while (p < pitementries.size()) {
            PromptBindingItemEntry pbie = (PromptBindingItemEntry)pitementries.get(p);
            Content content = pbie.getContent();
            if (content != null) {
                System.out.println(((TextContent)content).getText());
            } else {
                System.out.println("content is null");
            }
            ++p;
        }
        PromptBindingViewer optionPromptText = new PromptBindingViewer(promptBinding, this.getInteractionType(), this.getElement().getIncomingVariables());
        Composite containerComp = this.createWrapperComposite(canvas, 100);
        optionPromptText.createControls(containerComp);
        optionPromptText.addListener((PromptBindingViewerListener)this);
        gd = new GridData(128);
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        optionPromptText.getControl().setLayoutData((Object)gd);
        this.optionPromptMap.put(option, optionPromptText);
        controlList.add(containerComp);
        ord1 = this.createRowDivider(canvas, this.dividerColor);
        controlList.add((Object)ord1);
        this.voiceWidgets.add(ord1);
        Label optionGrammarLabel = this.createPropertyLabel(canvas, "Grammar");
        controlList.add(optionGrammarLabel);
        this.voiceWidgets.add(optionGrammarLabel);
        GrammarMediaBinding grammarBinding = this.bindingManager.getGrammarBinding(String.valueOf(option.getOptionName()) + "-grammar");
        GrammarBindingViewer grammarPromptText = new GrammarBindingViewer(grammarBinding, this.getInteractionType());
        gd = new GridData(768);
        gd.horizontalAlignment = 131072;
        grammarPromptText.createControls(canvas);
        grammarPromptText.getControl().setLayoutData((Object)gd);
        this.optionGrammarMap.put(option, grammarPromptText);
        controlList.add(grammarPromptText.getControl());
        this.voiceWidgets.add(grammarPromptText.getControl());
        ord1 = this.createRowDivider(canvas, this.dividerColor);
        controlList.add((Object)ord1);
        this.dtmfWidgets.add(ord1);
        Label optionDTMFLabel = this.createPropertyLabel(canvas, "DTMF Value");
        controlList.add(optionDTMFLabel);
        this.dtmfWidgets.add(optionDTMFLabel);
        final Combo dtmfCombo = this.createValueDropDown(canvas);
        dtmfCombo.add("0");
        dtmfCombo.add("1");
        dtmfCombo.add("2");
        dtmfCombo.add("3");
        dtmfCombo.add("4");
        dtmfCombo.add("5");
        dtmfCombo.add("6");
        dtmfCombo.add("7");
        dtmfCombo.add("8");
        dtmfCombo.add("9");
        dtmfCombo.add("*");
        dtmfCombo.add("#");
        PropertyBindingItem pbi = this.bindingManager.getPropertyBinding(String.valueOf(option.getOptionName()) + "-dtmf").getPropertyItem(this.currentBrand.getName(), this.getInteractionType());
        System.out.println("Option: " + option.getOptionName());
        System.out.println("\tdtmf: " + pbi.getValue());
        if (pbi.getValue() == null) {
            dtmfCombo.select(0);
        } else if (pbi.getValue().equals("#")) {
            dtmfCombo.select(11);
        } else if (pbi.getValue().equals("*")) {
            dtmfCombo.select(10);
        } else {
            dtmfCombo.select(Integer.parseInt(pbi.getValue()));
        }
        dtmfCombo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                PropertyMediaBinding propertyBinding = OptionSetMediaScreen.this.bindingManager.getPropertyBinding(String.valueOf(option.getOptionName()) + "-dtmf");
                PropertyBindingItem pbi = (PropertyBindingItem)propertyBinding.getPropertyItem(OptionSetMediaScreen.this.currentBrand.getName(), OptionSetMediaScreen.this.getInteractionType()).clone();
                pbi.setValue(dtmfCombo.getItem(dtmfCombo.getSelectionIndex()));
                propertyBinding.putPropertyItem(OptionSetMediaScreen.this.currentBrand.getName(), OptionSetMediaScreen.this.getInteractionType(), pbi);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        controlList.add(dtmfCombo);
        this.dtmfWidgets.add(dtmfCombo);
        ord1 = this.createRowDivider(canvas, this.dividerColor);
        controlList.add((Object)ord1);
        Label optionSilentLabel = this.createPropertyLabel(canvas, "Option is Silent");
        controlList.add(optionSilentLabel);
        final Combo silentCombo = this.createValueDropDown(canvas);
        silentCombo.add("true");
        silentCombo.add("false");
        pbi = this.bindingManager.getPropertyBinding(String.valueOf(option.getOptionName()) + "-silent").getPropertyItem(this.currentBrand.getName(), this.getInteractionType());
        System.out.println("\tsilent: " + pbi.getValue());
        if (pbi.getValue() == null) {
            silentCombo.select(0);
        } else if (pbi.getValue().equals("true")) {
            silentCombo.select(0);
        } else {
            silentCombo.select(1);
        }
        silentCombo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                PropertyMediaBinding propertyBinding = OptionSetMediaScreen.this.bindingManager.getPropertyBinding(String.valueOf(option.getOptionName()) + "-silent");
                PropertyBindingItem pbi = (PropertyBindingItem)propertyBinding.getPropertyItem(OptionSetMediaScreen.this.currentBrand.getName(), OptionSetMediaScreen.this.getInteractionType()).clone();
                pbi.setValue(silentCombo.getItem(silentCombo.getSelectionIndex()));
                propertyBinding.putPropertyItem(OptionSetMediaScreen.this.currentBrand.getName(), OptionSetMediaScreen.this.getInteractionType(), pbi);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        controlList.add(silentCombo);
        ord1 = this.createRowDivider(canvas, this.dividerColor);
        controlList.add((Object)ord1);
        return controlList;
    }

    public void updateButtons() {
        List currentOptions = this.info.getChoicesByBrand(this.currentBrand.getName());
        int i = 0;
        while (i < currentOptions.size()) {
            MenuChoice lastOption = (MenuChoice)currentOptions.get(i);
            ((ToolItem)this.moveUpButtons.get(lastOption)).setEnabled(i != 0);
            ((ToolItem)this.moveDownButtons.get(lastOption)).setEnabled(i < currentOptions.size() - 1);
            ++i;
        }
    }

    public void valueChanged(PromptBindingViewer viewer) {
        GridData gd;
        GridData gd2;
        Iterator i = null;
        for (Control control : this.dtmfWidgets) {
            gd2 = (GridData)control.getLayoutData();
            control.setVisible(false);
            gd2.exclude = true;
        }
        for (Control control : this.voiceWidgets) {
            gd2 = (GridData)control.getLayoutData();
            control.setVisible(false);
            gd2.exclude = true;
        }
        int sel = this.inputModeCombo.getSelectionIndex();
        if (sel == 2 || sel == 0) {
            for (Control control : this.dtmfWidgets) {
                gd = (GridData)control.getLayoutData();
                control.setVisible(true);
                gd.exclude = false;
            }
        }
        if (sel == 2 || sel == 1) {
            for (Control control : this.voiceWidgets) {
                gd = (GridData)control.getLayoutData();
                control.setVisible(true);
                gd.exclude = false;
            }
        }
        Point preferred = this.comp.computeSize(this.sc.getMinWidth(), -1, true);
        this.sc.setMinSize(preferred);
        this.comp.layout();
        if (preferred.y > this.sc.getClientArea().height) {
            preferred = this.comp.computeSize(this.sc.getClientArea().width, -1, true);
            this.sc.setMinSize(preferred);
            this.comp.layout();
        }
        this.updateButtons();
    }

    public class RowDivider
    extends Canvas
    implements PaintListener {
        public RowDivider(Composite parent, int style) {
            super(parent, style);
            this.addPaintListener(this);
            this.addMouseListener(OptionSetMediaScreen.this.focusMaster);
        }

        public void paintControl(PaintEvent e) {
            Point size = this.getSize();
            e.gc.drawLine(30, 1, size.x - 30, 1);
        }
    }
}

