/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.editors.voice.mediascreens;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Slider;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.vtp.desktop.core.configuration.Brand;
import org.eclipse.vtp.desktop.core.configuration.ConfigurationManager;
import org.eclipse.vtp.desktop.core.configuration.media.GrammarMediaBinding;
import org.eclipse.vtp.desktop.core.configuration.media.MediaBindingManager;
import org.eclipse.vtp.desktop.core.configuration.media.PromptMediaBinding;
import org.eclipse.vtp.desktop.core.configuration.media.PropertyBindingItem;
import org.eclipse.vtp.desktop.core.configuration.media.PropertyMediaBinding;
import org.eclipse.vtp.desktop.media.core.GrammarBindingViewer;
import org.eclipse.vtp.desktop.media.core.MediaConfigurationScreen;
import org.eclipse.vtp.desktop.media.core.PromptBindingViewer;
import org.eclipse.vtp.desktop.media.core.PromptBindingViewerListener;
import org.eclipse.vtp.desktop.model.core.Element;

public class QuestionMediaScreen
extends MediaConfigurationScreen
implements PromptBindingViewerListener {
    PromptBindingViewer promptViewer;
    GrammarBindingViewer dtmfGrammarViewer;
    GrammarBindingViewer voiceGrammarViewer;
    private FormToolkit toolkit;
    MediaBindingManager bindingManager;
    Combo inputModeCombo = null;
    Combo barginCombo = null;
    Spinner initialTimeoutSpinner = null;
    Spinner interdigitTimeoutSpinner = null;
    Spinner terminationTimeoutSpinner = null;
    Combo terminationCharacterCombo = null;
    Spinner speechCompleteTimeoutSpinner = null;
    Spinner speechIncompleteTimeoutSpinner = null;
    Spinner maxSpeechTimeoutSpinner = null;
    Spinner confidenceLevelSpinner = null;
    Spinner sensitivitySpinner = null;
    Spinner speedVsAccuracySpinner = null;
    List dtmfWidgets = new ArrayList();
    List voiceWidgets = new ArrayList();
    Composite comp = null;
    ScrolledComposite sc = null;
    Brand currentBrand = null;
    String currentLanguage = null;

    public QuestionMediaScreen(Element element) {
        super(element);
        this.bindingManager = (MediaBindingManager)element.getConfigurationManager("org.eclipse.vtp.configuration.media");
        PromptMediaBinding promptBinding = this.bindingManager.getPromptBinding("Prompt");
        this.promptViewer = new PromptBindingViewer(promptBinding, this.getInteractionType(), this.getElement().getIncomingVariables());
        GrammarMediaBinding dtmfGrammarBinding = this.bindingManager.getGrammarBinding("Grammar");
        this.dtmfGrammarViewer = new GrammarBindingViewer(dtmfGrammarBinding, this.getInteractionType());
        GrammarMediaBinding voiceGrammarBinding = this.bindingManager.getGrammarBinding("Voice-Grammar");
        this.voiceGrammarViewer = new GrammarBindingViewer(voiceGrammarBinding, this.getInteractionType());
    }

    public void save() {
        this.getElement().commitConfigurationChanges((ConfigurationManager)this.bindingManager);
    }

    public void cancel() {
        this.getElement().rollbackConfigurationChanges((ConfigurationManager)this.bindingManager);
    }

    public void createControls(Composite parent) {
        GridData gd;
        GridData gd2;
        this.toolkit = new FormToolkit(parent.getDisplay());
        this.sc = new ScrolledComposite(parent, 512);
        this.sc.getVerticalBar().setIncrement(4);
        this.comp = new Composite((Composite)this.sc, 0);
        this.sc.setContent((Control)this.comp);
        this.comp.setBackground(parent.getBackground());
        this.comp.setLayout((Layout)new GridLayout(1, false));
        Composite mediaComposite = new Composite(this.comp, 0);
        mediaComposite.setBackground(this.comp.getBackground());
        mediaComposite.setLayoutData((Object)new GridData(768));
        mediaComposite.setLayout((Layout)new GridLayout(2, false));
        Section contentSection = this.toolkit.createSection(mediaComposite, 256);
        GridData gridData = new GridData(770);
        gridData.horizontalSpan = 2;
        contentSection.setLayoutData((Object)gridData);
        contentSection.setText("Media");
        this.createPropertyLabel(mediaComposite, "Prompt:");
        Composite containerComp = this.createWrapperComposite(mediaComposite, 100);
        this.promptViewer.createControls(containerComp);
        this.promptViewer.addListener((PromptBindingViewerListener)this);
        gridData = new GridData(128);
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        this.promptViewer.getControl().setLayoutData((Object)gridData);
        Label grammarLabel = this.createPropertyLabel(mediaComposite, "DTMF Grammar:");
        containerComp = this.createWrapperComposite(mediaComposite, 100);
        this.dtmfGrammarViewer.createControls(containerComp);
        gridData = new GridData(128);
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        this.dtmfGrammarViewer.getControl().setLayoutData((Object)gridData);
        this.dtmfWidgets.add(grammarLabel);
        this.dtmfWidgets.add(containerComp);
        Label voiceGrammarLabel = this.createPropertyLabel(mediaComposite, "Voice Grammar:");
        containerComp = this.createWrapperComposite(mediaComposite, 100);
        this.voiceGrammarViewer.createControls(containerComp);
        gridData = new GridData(128);
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        this.voiceGrammarViewer.getControl().setLayoutData((Object)gridData);
        this.voiceWidgets.add(voiceGrammarLabel);
        this.voiceWidgets.add(containerComp);
        Composite spacerComp = new Composite(mediaComposite, 0);
        spacerComp.setBackground(mediaComposite.getBackground());
        gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        gridData.heightHint = 15;
        spacerComp.setLayoutData((Object)gridData);
        Composite settingsComposite = new Composite(this.comp, 0);
        settingsComposite.setBackground(this.comp.getBackground());
        settingsComposite.setLayoutData((Object)new GridData(768));
        settingsComposite.setLayout((Layout)new GridLayout(2, false));
        Section settingsSection = this.toolkit.createSection(settingsComposite, 256);
        gridData = new GridData(770);
        gridData.horizontalSpan = 2;
        settingsSection.setLayoutData((Object)gridData);
        settingsSection.setText("Settings");
        Label inputModeLabel = this.createPropertyLabel(settingsComposite, "User Input Style");
        inputModeLabel.setToolTipText("This property selects the valid ways\r\na caller can provide input:\r\n\t*DTMF - Touchtone keypad only\t*Voice - Speech recognition only\t*Hybrid - Touchtone or speech accepted");
        containerComp = this.createWrapperComposite(settingsComposite);
        this.inputModeCombo = this.createValueDropDown(containerComp);
        this.inputModeCombo.add("Dtmf Only");
        this.inputModeCombo.add("Voice Only");
        this.inputModeCombo.add("Hybrid");
        this.inputModeCombo.select(0);
        this.inputModeCombo.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                GridData gd;
                GridData gd2;
                PropertyMediaBinding propertyBinding = QuestionMediaScreen.this.bindingManager.getPropertyBinding("input-mode");
                PropertyBindingItem pbi = (PropertyBindingItem)propertyBinding.getPropertyItem(QuestionMediaScreen.this.currentBrand.getName(), QuestionMediaScreen.this.getInteractionType()).clone();
                pbi.setValue(QuestionMediaScreen.this.inputModeCombo.getItem(QuestionMediaScreen.this.inputModeCombo.getSelectionIndex()));
                propertyBinding.putPropertyItem(QuestionMediaScreen.this.currentBrand.getName(), QuestionMediaScreen.this.getInteractionType(), pbi);
                for (Control control : QuestionMediaScreen.this.dtmfWidgets) {
                    gd2 = (GridData)control.getLayoutData();
                    control.setVisible(false);
                    gd2.exclude = true;
                }
                for (Control control : QuestionMediaScreen.this.voiceWidgets) {
                    gd2 = (GridData)control.getLayoutData();
                    control.setVisible(false);
                    gd2.exclude = true;
                }
                int sel = QuestionMediaScreen.this.inputModeCombo.getSelectionIndex();
                if (sel == 2 || sel == 0) {
                    for (Control control : QuestionMediaScreen.this.dtmfWidgets) {
                        gd = (GridData)control.getLayoutData();
                        control.setVisible(true);
                        gd.exclude = false;
                    }
                }
                if (sel == 2 || sel == 1) {
                    for (Control control : QuestionMediaScreen.this.voiceWidgets) {
                        gd = (GridData)control.getLayoutData();
                        control.setVisible(true);
                        gd.exclude = false;
                    }
                }
                Point preferred = QuestionMediaScreen.this.comp.computeSize(QuestionMediaScreen.this.sc.getMinWidth(), -1, true);
                QuestionMediaScreen.this.sc.setMinSize(preferred);
                QuestionMediaScreen.this.comp.layout();
                if (preferred.y > QuestionMediaScreen.this.sc.getClientArea().height) {
                    preferred = QuestionMediaScreen.this.comp.computeSize(QuestionMediaScreen.this.sc.getClientArea().width, -1, true);
                    QuestionMediaScreen.this.sc.setMinSize(preferred);
                    QuestionMediaScreen.this.comp.layout();
                }
                QuestionMediaScreen.this.comp.getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        (this).QuestionMediaScreen.this.comp.layout(true, true);
                    }
                });
            }
        });
        Label bargeLabel = this.createPropertyLabel(settingsComposite, "Barge-in Enabled");
        bargeLabel.setToolTipText("Determines whether the caller can\r\ninterrupt the prompt to begin entry");
        containerComp = this.createWrapperComposite(settingsComposite);
        this.barginCombo = this.createValueDropDown(containerComp);
        this.barginCombo.add("true");
        this.barginCombo.add("false");
        this.barginCombo.select(0);
        this.barginCombo.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                PropertyMediaBinding propertyBinding = QuestionMediaScreen.this.bindingManager.getPropertyBinding("barge-in");
                PropertyBindingItem pbi = (PropertyBindingItem)propertyBinding.getPropertyItem(QuestionMediaScreen.this.currentBrand.getName(), QuestionMediaScreen.this.getInteractionType()).clone();
                pbi.setValue(QuestionMediaScreen.this.barginCombo.getItem(QuestionMediaScreen.this.barginCombo.getSelectionIndex()));
                propertyBinding.putPropertyItem(QuestionMediaScreen.this.currentBrand.getName(), QuestionMediaScreen.this.getInteractionType(), pbi);
            }
        });
        Label initialTimeoutLabel = this.createPropertyLabel(settingsComposite, "Initial Input Timeout (Seconds)");
        initialTimeoutLabel.setToolTipText("The amount of time in seconds to wait\r\nfor the caller to begin input before\r\na NoInput event.");
        containerComp = this.createWrapperComposite(settingsComposite);
        this.initialTimeoutSpinner = this.createValueSpinner(containerComp, 0, 100, 0, 0);
        this.initialTimeoutSpinner.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                PropertyMediaBinding propertyBinding = QuestionMediaScreen.this.bindingManager.getPropertyBinding("initial-timeout");
                PropertyBindingItem pbi = (PropertyBindingItem)propertyBinding.getPropertyItem(QuestionMediaScreen.this.currentBrand.getName(), QuestionMediaScreen.this.getInteractionType()).clone();
                pbi.setValue(Integer.toString(QuestionMediaScreen.this.initialTimeoutSpinner.getSelection()));
                propertyBinding.putPropertyItem(QuestionMediaScreen.this.currentBrand.getName(), QuestionMediaScreen.this.getInteractionType(), pbi);
            }
        });
        Label interdigitTimeoutLabel = this.createPropertyLabel(settingsComposite, "Interdigit Timeout (Seconds)");
        interdigitTimeoutLabel.setToolTipText("The amount of time in seconds to wait\r\nfor additional touchtone if the current\r\ninput does not match the grammar before\r\na NoMatch event.");
        this.dtmfWidgets.add(interdigitTimeoutLabel);
        containerComp = this.createWrapperComposite(settingsComposite);
        this.dtmfWidgets.add(containerComp);
        this.interdigitTimeoutSpinner = this.createValueSpinner(containerComp, 0, 100, 0, 0);
        this.interdigitTimeoutSpinner.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                PropertyMediaBinding propertyBinding = QuestionMediaScreen.this.bindingManager.getPropertyBinding("interdigit-timeout");
                PropertyBindingItem pbi = (PropertyBindingItem)propertyBinding.getPropertyItem(QuestionMediaScreen.this.currentBrand.getName(), QuestionMediaScreen.this.getInteractionType()).clone();
                pbi.setValue(Integer.toString(QuestionMediaScreen.this.interdigitTimeoutSpinner.getSelection()));
                propertyBinding.putPropertyItem(QuestionMediaScreen.this.currentBrand.getName(), QuestionMediaScreen.this.getInteractionType(), pbi);
            }
        });
        Label terminationTimeoutLabel = this.createPropertyLabel(settingsComposite, "Termination Timeout (Seconds)");
        terminationTimeoutLabel.setToolTipText("The amount of time in seconds to wait\r\nfor additional input after a selection\r\nhas been matched.");
        this.dtmfWidgets.add(terminationTimeoutLabel);
        containerComp = this.createWrapperComposite(settingsComposite);
        this.dtmfWidgets.add(containerComp);
        this.terminationTimeoutSpinner = this.createValueSpinner(containerComp, 0, 100, 0, 0);
        this.terminationTimeoutSpinner.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                PropertyMediaBinding propertyBinding = QuestionMediaScreen.this.bindingManager.getPropertyBinding("termination-timeout");
                PropertyBindingItem pbi = (PropertyBindingItem)propertyBinding.getPropertyItem(QuestionMediaScreen.this.currentBrand.getName(), QuestionMediaScreen.this.getInteractionType()).clone();
                pbi.setValue(Integer.toString(QuestionMediaScreen.this.terminationTimeoutSpinner.getSelection()));
                propertyBinding.putPropertyItem(QuestionMediaScreen.this.currentBrand.getName(), QuestionMediaScreen.this.getInteractionType(), pbi);
            }
        });
        Label terminationCharacterLabel = this.createPropertyLabel(settingsComposite, "Termination Character");
        terminationCharacterLabel.setToolTipText("An option touchtone key that can be used\r\nto indicate the caller has reached the end\r\nof their input.");
        this.dtmfWidgets.add(terminationCharacterLabel);
        containerComp = this.createWrapperComposite(settingsComposite);
        this.dtmfWidgets.add(containerComp);
        this.terminationCharacterCombo = this.createValueDropDown(containerComp);
        this.terminationCharacterCombo.add("#");
        this.terminationCharacterCombo.add("0");
        this.terminationCharacterCombo.add("1");
        this.terminationCharacterCombo.add("2");
        this.terminationCharacterCombo.add("3");
        this.terminationCharacterCombo.add("4");
        this.terminationCharacterCombo.add("5");
        this.terminationCharacterCombo.add("6");
        this.terminationCharacterCombo.add("7");
        this.terminationCharacterCombo.add("8");
        this.terminationCharacterCombo.add("9");
        this.terminationCharacterCombo.add("*");
        this.terminationCharacterCombo.add("None");
        this.terminationCharacterCombo.select(0);
        this.terminationCharacterCombo.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                PropertyMediaBinding propertyBinding = QuestionMediaScreen.this.bindingManager.getPropertyBinding("termination-character");
                PropertyBindingItem pbi = (PropertyBindingItem)propertyBinding.getPropertyItem(QuestionMediaScreen.this.currentBrand.getName(), QuestionMediaScreen.this.getInteractionType()).clone();
                pbi.setValue(QuestionMediaScreen.this.terminationCharacterCombo.getItem(QuestionMediaScreen.this.terminationCharacterCombo.getSelectionIndex()));
                propertyBinding.putPropertyItem(QuestionMediaScreen.this.currentBrand.getName(), QuestionMediaScreen.this.getInteractionType(), pbi);
            }
        });
        Label speechIncompleteTimeoutLabel = this.createPropertyLabel(settingsComposite, "Speech Incomplete Timeout (Seconds)");
        speechIncompleteTimeoutLabel.setToolTipText("The amount of time in seconds to wait\r\nfor additional input if the current entry\r\ndoes not match the provided grammar.");
        this.voiceWidgets.add(speechIncompleteTimeoutLabel);
        containerComp = this.createWrapperComposite(settingsComposite);
        this.voiceWidgets.add(containerComp);
        this.speechIncompleteTimeoutSpinner = this.createValueSpinner(containerComp, 0, 100, 0, 0);
        this.speechIncompleteTimeoutSpinner.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                PropertyMediaBinding propertyBinding = QuestionMediaScreen.this.bindingManager.getPropertyBinding("speech-incomplete-timeout");
                PropertyBindingItem pbi = (PropertyBindingItem)propertyBinding.getPropertyItem(QuestionMediaScreen.this.currentBrand.getName(), QuestionMediaScreen.this.getInteractionType()).clone();
                pbi.setValue(Integer.toString(QuestionMediaScreen.this.speechIncompleteTimeoutSpinner.getSelection()));
                propertyBinding.putPropertyItem(QuestionMediaScreen.this.currentBrand.getName(), QuestionMediaScreen.this.getInteractionType(), pbi);
            }
        });
        Label speechCompleteTimeoutLabel = this.createPropertyLabel(settingsComposite, "Speech Completion Timeout (Seconds)");
        speechCompleteTimeoutLabel.setToolTipText("The amount of time in seconds to wait\r\nfor additional input if the current entry\r\nalready matches the provided grammar.");
        this.voiceWidgets.add(speechCompleteTimeoutLabel);
        containerComp = this.createWrapperComposite(settingsComposite);
        this.voiceWidgets.add(containerComp);
        this.speechCompleteTimeoutSpinner = this.createValueSpinner(containerComp, 0, 100, 0, 0);
        this.speechCompleteTimeoutSpinner.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                PropertyMediaBinding propertyBinding = QuestionMediaScreen.this.bindingManager.getPropertyBinding("speech-complete-timeout");
                PropertyBindingItem pbi = (PropertyBindingItem)propertyBinding.getPropertyItem(QuestionMediaScreen.this.currentBrand.getName(), QuestionMediaScreen.this.getInteractionType()).clone();
                pbi.setValue(Integer.toString(QuestionMediaScreen.this.speechCompleteTimeoutSpinner.getSelection()));
                propertyBinding.putPropertyItem(QuestionMediaScreen.this.currentBrand.getName(), QuestionMediaScreen.this.getInteractionType(), pbi);
            }
        });
        Label maxSpeechTimeoutLabel = this.createPropertyLabel(settingsComposite, "Maximum Speech Length (Seconds)");
        maxSpeechTimeoutLabel.setToolTipText("The maximum length of speech input\r\nin seconds that will be accepted.");
        this.voiceWidgets.add(maxSpeechTimeoutLabel);
        containerComp = this.createWrapperComposite(settingsComposite);
        this.voiceWidgets.add(containerComp);
        this.maxSpeechTimeoutSpinner = this.createValueSpinner(containerComp, 10, 300, 0, 0);
        this.maxSpeechTimeoutSpinner.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                PropertyMediaBinding propertyBinding = QuestionMediaScreen.this.bindingManager.getPropertyBinding("max-speech-timeout");
                PropertyBindingItem pbi = (PropertyBindingItem)propertyBinding.getPropertyItem(QuestionMediaScreen.this.currentBrand.getName(), QuestionMediaScreen.this.getInteractionType()).clone();
                pbi.setValue(Integer.toString(QuestionMediaScreen.this.maxSpeechTimeoutSpinner.getSelection()));
                propertyBinding.putPropertyItem(QuestionMediaScreen.this.currentBrand.getName(), QuestionMediaScreen.this.getInteractionType(), pbi);
            }
        });
        Label confidenceLevelLabel = this.createPropertyLabel(settingsComposite, "Minimum Confidence Level Accepted");
        confidenceLevelLabel.setToolTipText("The minimum level of confidence accepted\r\nby the speech recognition provider.");
        this.voiceWidgets.add(confidenceLevelLabel);
        containerComp = this.createWrapperComposite(settingsComposite);
        this.voiceWidgets.add(containerComp);
        this.confidenceLevelSpinner = this.createValueSpinner(containerComp, 0, 100, 0, 0);
        this.confidenceLevelSpinner.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                PropertyMediaBinding propertyBinding = QuestionMediaScreen.this.bindingManager.getPropertyBinding("confidence-level");
                PropertyBindingItem pbi = (PropertyBindingItem)propertyBinding.getPropertyItem(QuestionMediaScreen.this.currentBrand.getName(), QuestionMediaScreen.this.getInteractionType()).clone();
                pbi.setValue(Integer.toString(QuestionMediaScreen.this.confidenceLevelSpinner.getSelection()));
                propertyBinding.putPropertyItem(QuestionMediaScreen.this.currentBrand.getName(), QuestionMediaScreen.this.getInteractionType(), pbi);
            }
        });
        Label sensitivityLabel = this.createPropertyLabel(settingsComposite, "Typical Caller Environment");
        sensitivityLabel.setToolTipText("Determines how sensitive the speech recognition\r\nwill be to background noise.  The lower the number,\r\nthe less senitive the system will be");
        this.voiceWidgets.add(sensitivityLabel);
        containerComp = this.createWrapperComposite(settingsComposite);
        this.voiceWidgets.add(containerComp);
        this.sensitivitySpinner = this.createValueSpinner(containerComp, 0, 100, 0, 0);
        this.sensitivitySpinner.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                PropertyMediaBinding propertyBinding = QuestionMediaScreen.this.bindingManager.getPropertyBinding("sensitivity-level");
                PropertyBindingItem pbi = (PropertyBindingItem)propertyBinding.getPropertyItem(QuestionMediaScreen.this.currentBrand.getName(), QuestionMediaScreen.this.getInteractionType()).clone();
                pbi.setValue(Integer.toString(QuestionMediaScreen.this.sensitivitySpinner.getSelection()));
                propertyBinding.putPropertyItem(QuestionMediaScreen.this.currentBrand.getName(), QuestionMediaScreen.this.getInteractionType(), pbi);
            }
        });
        Label speedVsAccuracyLabel = this.createPropertyLabel(settingsComposite, "Speed Vs Accuracy");
        speedVsAccuracyLabel.setToolTipText("A hint to the speech recognition platform indicating\r\nrelative focus between the speed in which the result\r\nis returned and the accuracy of that result.  The\r\nlower the number, the faster the entry is processed\r\nbut accuracy may be reduced.");
        this.voiceWidgets.add(speedVsAccuracyLabel);
        containerComp = this.createWrapperComposite(settingsComposite);
        this.voiceWidgets.add(containerComp);
        this.speedVsAccuracySpinner = this.createValueSpinner(containerComp, 0, 100, 0, 0);
        this.speedVsAccuracySpinner.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                PropertyMediaBinding propertyBinding = QuestionMediaScreen.this.bindingManager.getPropertyBinding("speed-vs-accuracy");
                PropertyBindingItem pbi = (PropertyBindingItem)propertyBinding.getPropertyItem(QuestionMediaScreen.this.currentBrand.getName(), QuestionMediaScreen.this.getInteractionType()).clone();
                pbi.setValue(Integer.toString(QuestionMediaScreen.this.speedVsAccuracySpinner.getSelection()));
                propertyBinding.putPropertyItem(QuestionMediaScreen.this.currentBrand.getName(), QuestionMediaScreen.this.getInteractionType(), pbi);
            }
        });
        this.comp.addControlListener(new ControlListener(){

            public void controlMoved(ControlEvent e) {
            }

            public void controlResized(ControlEvent e) {
                QuestionMediaScreen.this.comp.removeControlListener((ControlListener)this);
                QuestionMediaScreen.this.sc.setAlwaysShowScrollBars(true);
                Rectangle clientArea = QuestionMediaScreen.this.sc.getClientArea();
                QuestionMediaScreen.this.sc.setAlwaysShowScrollBars(false);
                if (QuestionMediaScreen.this.sc.getVerticalBar() != null) {
                    QuestionMediaScreen.this.sc.getVerticalBar().setVisible(false);
                }
                QuestionMediaScreen.this.sc.setMinSize(new Point(clientArea.width, clientArea.height));
                QuestionMediaScreen.this.sc.layout(true, true);
                QuestionMediaScreen.this.sc.redraw();
            }
        });
        this.sc.setMinWidth(this.comp.computeSize((int)-1, (int)-1, (boolean)true).x);
        for (Control control : this.dtmfWidgets) {
            gd2 = (GridData)control.getLayoutData();
            control.setVisible(false);
            gd2.exclude = true;
        }
        for (Control control : this.voiceWidgets) {
            gd2 = (GridData)control.getLayoutData();
            control.setVisible(false);
            gd2.exclude = true;
        }
        int sel = this.inputModeCombo.getSelectionIndex();
        if (sel == 2 || sel == 0) {
            for (Control control : this.dtmfWidgets) {
                gd = (GridData)control.getLayoutData();
                control.setVisible(true);
                gd.exclude = false;
            }
        }
        if (sel == 2 || sel == 1) {
            for (Control control : this.voiceWidgets) {
                gd = (GridData)control.getLayoutData();
                control.setVisible(true);
                gd.exclude = false;
            }
        }
        this.sc.setMinHeight(this.comp.computeSize((int)-1, (int)-1, (boolean)true).y);
        this.sc.setExpandHorizontal(true);
        this.sc.setExpandVertical(true);
        this.setControl((Control)this.sc);
    }

    public String getInteractionType() {
        return "org.eclipse.vtp.framework.interactions.voice.interaction";
    }

    public void setBrand(Brand brand) {
        PropertyMediaBinding bargeinPropertyBinding;
        PropertyBindingItem pbi;
        GridData gd;
        GridData gd2;
        PropertyMediaBinding inputModePropertyBinding;
        PropertyBindingItem pbi3;
        this.currentBrand = brand;
        if (this.promptViewer != null) {
            this.promptViewer.setCurrentBrand(brand);
        }
        if (this.dtmfGrammarViewer != null) {
            this.dtmfGrammarViewer.setCurrentBrand(brand);
        }
        if (this.voiceGrammarViewer != null) {
            this.voiceGrammarViewer.setCurrentBrand(brand);
        }
        if ("Voice Only".equals((pbi3 = (inputModePropertyBinding = this.bindingManager.getPropertyBinding("input-mode")).getPropertyItem(this.currentBrand.getName(), this.getInteractionType())).getValue())) {
            this.inputModeCombo.select(1);
        } else if ("Hybrid".equals(pbi3.getValue())) {
            this.inputModeCombo.select(2);
        } else {
            this.inputModeCombo.select(0);
        }
        for (Control control : this.dtmfWidgets) {
            gd2 = (GridData)control.getLayoutData();
            control.setVisible(false);
            gd2.exclude = true;
        }
        for (Control control : this.voiceWidgets) {
            gd2 = (GridData)control.getLayoutData();
            control.setVisible(false);
            gd2.exclude = true;
        }
        int sel = this.inputModeCombo.getSelectionIndex();
        if (sel == 2 || sel == 0) {
            for (Control control : this.dtmfWidgets) {
                gd = (GridData)control.getLayoutData();
                control.setVisible(true);
                gd.exclude = false;
            }
        }
        if (sel == 2 || sel == 1) {
            for (Control control : this.voiceWidgets) {
                gd = (GridData)control.getLayoutData();
                control.setVisible(true);
                gd.exclude = false;
            }
        }
        Point preferred = this.comp.computeSize(this.sc.getMinWidth(), -1, true);
        this.sc.setMinSize(preferred);
        this.comp.layout();
        if (preferred.y > this.sc.getClientArea().height) {
            preferred = this.comp.computeSize(this.sc.getClientArea().width, -1, true);
            this.sc.setMinSize(preferred);
            this.comp.layout();
        }
        if ("false".equals((pbi = (bargeinPropertyBinding = this.bindingManager.getPropertyBinding("barge-in")).getPropertyItem(this.currentBrand.getName(), this.getInteractionType())).getValue())) {
            this.barginCombo.select(1);
        } else {
            this.barginCombo.select(0);
        }
        PropertyMediaBinding initialTimeoutPropertyBinding = this.bindingManager.getPropertyBinding("initial-timeout");
        PropertyBindingItem pbi2 = initialTimeoutPropertyBinding.getPropertyItem(this.currentBrand.getName(), this.getInteractionType());
        if (pbi2.getValue() == null) {
            this.initialTimeoutSpinner.setSelection(0);
        } else {
            this.initialTimeoutSpinner.setSelection(Integer.parseInt(pbi2.getValue()));
        }
        PropertyMediaBinding interdigitTimeoutPropertyBinding = this.bindingManager.getPropertyBinding("interdigit-timeout");
        pbi2 = interdigitTimeoutPropertyBinding.getPropertyItem(this.currentBrand.getName(), this.getInteractionType());
        if (pbi2.getValue() == null) {
            this.interdigitTimeoutSpinner.setSelection(0);
        } else {
            this.interdigitTimeoutSpinner.setSelection(Integer.parseInt(pbi2.getValue()));
        }
        PropertyMediaBinding terminationTimeoutPropertyBinding = this.bindingManager.getPropertyBinding("termination-timeout");
        pbi2 = terminationTimeoutPropertyBinding.getPropertyItem(this.currentBrand.getName(), this.getInteractionType());
        if (pbi2.getValue() == null) {
            this.terminationTimeoutSpinner.setSelection(0);
        } else {
            this.terminationTimeoutSpinner.setSelection(Integer.parseInt(pbi2.getValue()));
        }
        PropertyMediaBinding terminationCharacterPropertyBinding = this.bindingManager.getPropertyBinding("termination-character");
        pbi2 = terminationCharacterPropertyBinding.getPropertyItem(this.currentBrand.getName(), this.getInteractionType());
        if (pbi2.getValue() == null) {
            this.terminationCharacterCombo.select(0);
        } else if (pbi2.getValue().equals("#")) {
            this.terminationCharacterCombo.select(0);
        } else if (pbi2.getValue().equals("*")) {
            this.terminationCharacterCombo.select(11);
        } else if (pbi2.getValue().equals("None")) {
            this.terminationCharacterCombo.select(12);
        } else {
            this.terminationCharacterCombo.select(Integer.parseInt(pbi2.getValue()) + 1);
        }
        PropertyMediaBinding speechIncompleteTimeoutPropertyBinding = this.bindingManager.getPropertyBinding("speech-incomplete-timeout");
        pbi2 = speechIncompleteTimeoutPropertyBinding.getPropertyItem(this.currentBrand.getName(), this.getInteractionType());
        if (pbi2.getValue() == null) {
            this.speechIncompleteTimeoutSpinner.setSelection(0);
        } else {
            this.speechIncompleteTimeoutSpinner.setSelection(Integer.parseInt(pbi2.getValue()));
        }
        PropertyMediaBinding speechCompleteTimeoutPropertyBinding = this.bindingManager.getPropertyBinding("speech-complete-timeout");
        pbi2 = speechCompleteTimeoutPropertyBinding.getPropertyItem(this.currentBrand.getName(), this.getInteractionType());
        if (pbi2.getValue() == null) {
            this.speechCompleteTimeoutSpinner.setSelection(0);
        } else {
            this.speechCompleteTimeoutSpinner.setSelection(Integer.parseInt(pbi2.getValue()));
        }
        PropertyMediaBinding maxSpeechTimeoutPropertyBinding = this.bindingManager.getPropertyBinding("max-speech-timeout");
        pbi2 = maxSpeechTimeoutPropertyBinding.getPropertyItem(this.currentBrand.getName(), this.getInteractionType());
        if (pbi2.getValue() == null) {
            this.maxSpeechTimeoutSpinner.setSelection(0);
        } else {
            this.maxSpeechTimeoutSpinner.setSelection(Integer.parseInt(pbi2.getValue()));
        }
        PropertyMediaBinding confidenceLevelPropertyBinding = this.bindingManager.getPropertyBinding("confidence-level");
        pbi2 = confidenceLevelPropertyBinding.getPropertyItem(this.currentBrand.getName(), this.getInteractionType());
        if (pbi2.getValue() == null) {
            this.confidenceLevelSpinner.setSelection(0);
        } else {
            this.confidenceLevelSpinner.setSelection(Integer.parseInt(pbi2.getValue()));
        }
        PropertyMediaBinding sensitivityLevelPropertyBinding = this.bindingManager.getPropertyBinding("sensitivity-level");
        pbi2 = sensitivityLevelPropertyBinding.getPropertyItem(this.currentBrand.getName(), this.getInteractionType());
        if (pbi2.getValue() == null) {
            this.sensitivitySpinner.setSelection(0);
        } else {
            this.sensitivitySpinner.setSelection(Integer.parseInt(pbi2.getValue()));
        }
        PropertyMediaBinding speedVsAccuracyPropertyBinding = this.bindingManager.getPropertyBinding("speed-vs-accuracy");
        pbi2 = speedVsAccuracyPropertyBinding.getPropertyItem(this.currentBrand.getName(), this.getInteractionType());
        if (pbi2.getValue() == null) {
            this.speedVsAccuracySpinner.setSelection(0);
        } else {
            this.speedVsAccuracySpinner.setSelection(Integer.parseInt(pbi2.getValue()));
        }
    }

    public void setLanguage(String language) {
        this.currentLanguage = language;
        if (this.promptViewer != null) {
            this.promptViewer.setCurrentLanguage(language);
        }
        if (this.dtmfGrammarViewer != null) {
            this.dtmfGrammarViewer.setCurrentLanguage(language);
        }
        if (this.voiceGrammarViewer != null) {
            this.voiceGrammarViewer.setCurrentLanguage(language);
        }
    }

    public Composite createWrapperComposite(Composite parent) {
        return this.createWrapperComposite(parent, 20);
    }

    public Composite createWrapperComposite(Composite parent, int indent) {
        Composite containerComp = new Composite(parent, 0);
        containerComp.setBackground(parent.getBackground());
        GridData gridData = new GridData(802);
        gridData.horizontalIndent = indent;
        gridData.widthHint = 150;
        GridLayout gl = new GridLayout(1, false);
        gl.horizontalSpacing = 0;
        gl.verticalSpacing = 0;
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        containerComp.setLayout((Layout)gl);
        containerComp.setLayoutData((Object)gridData);
        return containerComp;
    }

    public Label createPropertyLabel(Composite parent, String text) {
        Label ret = new Label(parent, 0);
        ret.setText(text);
        ret.setBackground(parent.getBackground());
        GridData gd = new GridData();
        gd.verticalAlignment = 128;
        gd.verticalIndent = 4;
        gd.horizontalIndent = 30;
        ret.setLayoutData((Object)gd);
        return ret;
    }

    public RowDivider createRowDivider(Composite parent, Color dividerColor) {
        RowDivider rd1 = new RowDivider(parent, 0);
        rd1.setBackground(parent.getBackground());
        rd1.setForeground(dividerColor);
        GridData gd = new GridData(768);
        gd.heightHint = 3;
        gd.horizontalIndent = 50;
        gd.horizontalSpan = 2;
        rd1.setLayoutData(gd);
        return rd1;
    }

    private Combo createValueDropDown(Composite parent) {
        Combo ret = new Combo(parent, 2060);
        GridData gd = new GridData();
        gd.verticalIndent = 2;
        gd.horizontalAlignment = 131072;
        gd.grabExcessHorizontalSpace = true;
        ret.setLayoutData((Object)gd);
        return ret;
    }

    public Spinner createValueSpinner(Composite parent, int min, int max, int digits, int value) {
        Spinner ret = new Spinner(parent, 2048);
        ret.setMinimum(min);
        ret.setMaximum(max);
        ret.setDigits(digits);
        ret.setSelection(value);
        GridData gd = new GridData();
        gd.verticalIndent = 2;
        gd.horizontalAlignment = 131072;
        gd.grabExcessHorizontalSpace = true;
        ret.setLayoutData((Object)gd);
        return ret;
    }

    public Slider createValueSlider(Composite parent, int min, int max, String leftName, String rightName) {
        Composite sliderComp = new Composite(parent, 0);
        sliderComp.setBackground(parent.getBackground());
        GridData gd = new GridData();
        gd.verticalIndent = 2;
        gd.horizontalAlignment = 131072;
        gd.grabExcessHorizontalSpace = true;
        sliderComp.setLayoutData((Object)gd);
        sliderComp.setLayout((Layout)new FormLayout());
        Label leftLabel = new Label(sliderComp, 0);
        leftLabel.setBackground(sliderComp.getBackground());
        leftLabel.setText(leftName);
        FormData fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.bottom = new FormAttachment(100, 0);
        leftLabel.setLayoutData((Object)fd);
        Label rightLabel = new Label(sliderComp, 0);
        rightLabel.setBackground(sliderComp.getBackground());
        rightLabel.setText(rightName);
        fd = new FormData();
        fd.right = new FormAttachment(100, 0);
        fd.bottom = new FormAttachment(100, 0);
        rightLabel.setLayoutData((Object)fd);
        Slider ret = new Slider(sliderComp, 256);
        ret.setMinimum(min);
        ret.setMaximum(max);
        fd = new FormData();
        fd.left = new FormAttachment((Control)leftLabel, 0, 16384);
        fd.right = new FormAttachment((Control)rightLabel, 0, 131072);
        fd.top = new FormAttachment(0, 0);
        fd.bottom = new FormAttachment((Control)leftLabel, -3);
        fd.width = 150;
        ret.setLayoutData((Object)fd);
        return ret;
    }

    public void valueChanged(PromptBindingViewer viewer) {
        Point preferred = this.comp.computeSize(this.sc.getMinWidth(), -1, true);
        this.sc.setMinSize(preferred);
        this.comp.layout();
        if (preferred.y > this.sc.getClientArea().height) {
            preferred = this.comp.computeSize(this.sc.getClientArea().width, -1, true);
            this.sc.setMinSize(preferred);
            this.comp.layout();
        }
    }

    public class RowDivider
    extends Canvas
    implements PaintListener {
        public RowDivider(Composite parent, int style) {
            super(parent, style);
            this.addPaintListener(this);
        }

        public void paintControl(PaintEvent e) {
            Point size = this.getSize();
            e.gc.drawLine(30, 1, size.x - 30, 1);
        }
    }
}

