/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.editors.voice.mediascreens;

import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Slider;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.vtp.desktop.core.configuration.Brand;
import org.eclipse.vtp.desktop.core.configuration.ConfigurationManager;
import org.eclipse.vtp.desktop.core.configuration.media.MediaBindingManager;
import org.eclipse.vtp.desktop.core.configuration.media.PromptMediaBinding;
import org.eclipse.vtp.desktop.core.configuration.media.PropertyBindingItem;
import org.eclipse.vtp.desktop.core.configuration.media.PropertyMediaBinding;
import org.eclipse.vtp.desktop.media.core.MediaConfigurationScreen;
import org.eclipse.vtp.desktop.media.core.PromptBindingViewer;
import org.eclipse.vtp.desktop.media.core.PromptBindingViewerListener;
import org.eclipse.vtp.desktop.model.core.Element;

public class RecordMediaScreen
extends MediaConfigurationScreen
implements PromptBindingViewerListener {
    PromptBindingViewer promptViewer;
    private FormToolkit toolkit;
    MediaBindingManager bindingManager;
    Combo barginCombo = null;
    Combo beepCombo = null;
    Spinner initialTimeoutSpinner = null;
    Combo terminationCharacterCombo = null;
    Spinner terminationTimeoutSpinner = null;
    Spinner maxSpeechTimeoutSpinner = null;
    Composite comp = null;
    ScrolledComposite sc = null;
    Brand currentBrand = null;
    String currentLanguage = null;

    public RecordMediaScreen(Element element) {
        super(element);
        this.bindingManager = (MediaBindingManager)element.getConfigurationManager("org.eclipse.vtp.configuration.media");
        PromptMediaBinding promptBinding = this.bindingManager.getPromptBinding("Prompt");
        this.promptViewer = new PromptBindingViewer(promptBinding, this.getInteractionType(), this.getElement().getIncomingVariables());
    }

    public void save() {
        this.getElement().commitConfigurationChanges((ConfigurationManager)this.bindingManager);
    }

    public void cancel() {
        this.getElement().rollbackConfigurationChanges((ConfigurationManager)this.bindingManager);
    }

    public void createControls(Composite parent) {
        this.toolkit = new FormToolkit(parent.getDisplay());
        this.sc = new ScrolledComposite(parent, 512);
        this.sc.getVerticalBar().setIncrement(4);
        this.comp = new Composite((Composite)this.sc, 0);
        this.sc.setContent((Control)this.comp);
        this.comp.setBackground(parent.getBackground());
        this.comp.setLayout((Layout)new GridLayout(1, false));
        Composite mediaComposite = new Composite(this.comp, 0);
        mediaComposite.setBackground(this.comp.getBackground());
        mediaComposite.setLayoutData((Object)new GridData(768));
        mediaComposite.setLayout((Layout)new GridLayout(2, false));
        Section contentSection = this.toolkit.createSection(mediaComposite, 256);
        GridData gridData = new GridData(770);
        gridData.horizontalSpan = 2;
        contentSection.setLayoutData((Object)gridData);
        contentSection.setText("Media");
        this.createPropertyLabel(mediaComposite, "Prompt:");
        Composite containerComp = this.createWrapperComposite(mediaComposite, 100);
        this.promptViewer.createControls(containerComp);
        this.promptViewer.addListener((PromptBindingViewerListener)this);
        gridData = new GridData(128);
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        this.promptViewer.getControl().setLayoutData((Object)gridData);
        Composite spacerComp = new Composite(mediaComposite, 0);
        spacerComp.setBackground(mediaComposite.getBackground());
        gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        gridData.heightHint = 15;
        spacerComp.setLayoutData((Object)gridData);
        Composite settingsComposite = new Composite(this.comp, 0);
        settingsComposite.setBackground(this.comp.getBackground());
        settingsComposite.setLayoutData((Object)new GridData(768));
        settingsComposite.setLayout((Layout)new GridLayout(2, false));
        Section settingsSection = this.toolkit.createSection(settingsComposite, 256);
        gridData = new GridData(770);
        gridData.horizontalSpan = 2;
        settingsSection.setLayoutData((Object)gridData);
        settingsSection.setText("Settings");
        Label bargeLabel = this.createPropertyLabel(settingsComposite, "Barge-in Enabled");
        bargeLabel.setToolTipText("Determines whether the caller can\r\ninterrupt the prompt to begin entry");
        containerComp = this.createWrapperComposite(settingsComposite);
        this.barginCombo = this.createValueDropDown(containerComp);
        this.barginCombo.add("true");
        this.barginCombo.add("false");
        this.barginCombo.select(0);
        this.barginCombo.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                PropertyMediaBinding propertyBinding = RecordMediaScreen.this.bindingManager.getPropertyBinding("barge-in");
                PropertyBindingItem pbi = (PropertyBindingItem)propertyBinding.getPropertyItem(RecordMediaScreen.this.currentBrand.getName(), RecordMediaScreen.this.getInteractionType()).clone();
                pbi.setValue(RecordMediaScreen.this.barginCombo.getItem(RecordMediaScreen.this.barginCombo.getSelectionIndex()));
                propertyBinding.putPropertyItem(RecordMediaScreen.this.currentBrand.getName(), RecordMediaScreen.this.getInteractionType(), pbi);
            }
        });
        this.createPropertyLabel(settingsComposite, "Play Beep?");
        containerComp = this.createWrapperComposite(settingsComposite);
        this.beepCombo = this.createValueDropDown(containerComp);
        this.beepCombo.add("true");
        this.beepCombo.add("false");
        this.beepCombo.select(0);
        this.beepCombo.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                PropertyMediaBinding propertyBinding = RecordMediaScreen.this.bindingManager.getPropertyBinding("play-beep");
                PropertyBindingItem pbi = (PropertyBindingItem)propertyBinding.getPropertyItem(RecordMediaScreen.this.currentBrand.getName(), RecordMediaScreen.this.getInteractionType()).clone();
                pbi.setValue(RecordMediaScreen.this.beepCombo.getItem(RecordMediaScreen.this.beepCombo.getSelectionIndex()));
                propertyBinding.putPropertyItem(RecordMediaScreen.this.currentBrand.getName(), RecordMediaScreen.this.getInteractionType(), pbi);
            }
        });
        this.createPropertyLabel(settingsComposite, "Allow DTMF Termination?");
        containerComp = this.createWrapperComposite(settingsComposite);
        this.terminationCharacterCombo = this.createValueDropDown(containerComp);
        this.terminationCharacterCombo.add("true");
        this.terminationCharacterCombo.add("false");
        this.terminationCharacterCombo.select(0);
        this.terminationCharacterCombo.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                PropertyMediaBinding propertyBinding = RecordMediaScreen.this.bindingManager.getPropertyBinding("dtmf-termination");
                PropertyBindingItem pbi = (PropertyBindingItem)propertyBinding.getPropertyItem(RecordMediaScreen.this.currentBrand.getName(), RecordMediaScreen.this.getInteractionType()).clone();
                pbi.setValue(RecordMediaScreen.this.terminationCharacterCombo.getItem(RecordMediaScreen.this.terminationCharacterCombo.getSelectionIndex()));
                propertyBinding.putPropertyItem(RecordMediaScreen.this.currentBrand.getName(), RecordMediaScreen.this.getInteractionType(), pbi);
            }
        });
        Label initialTimeoutLabel = this.createPropertyLabel(settingsComposite, "Initial Input Timeout (Seconds)");
        initialTimeoutLabel.setToolTipText("The amount of time in seconds to wait\r\nfor the caller to begin input before\r\na NoInput event.");
        containerComp = this.createWrapperComposite(settingsComposite);
        this.initialTimeoutSpinner = this.createValueSpinner(containerComp, 0, 100, 0, 0);
        this.initialTimeoutSpinner.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                PropertyMediaBinding propertyBinding = RecordMediaScreen.this.bindingManager.getPropertyBinding("initial-timeout");
                PropertyBindingItem pbi = (PropertyBindingItem)propertyBinding.getPropertyItem(RecordMediaScreen.this.currentBrand.getName(), RecordMediaScreen.this.getInteractionType()).clone();
                pbi.setValue(Integer.toString(RecordMediaScreen.this.initialTimeoutSpinner.getSelection()));
                propertyBinding.putPropertyItem(RecordMediaScreen.this.currentBrand.getName(), RecordMediaScreen.this.getInteractionType(), pbi);
            }
        });
        Label terminationTimeoutLabel = this.createPropertyLabel(settingsComposite, "Termination Timeout (Seconds)");
        terminationTimeoutLabel.setToolTipText("The amount of time in seconds to wait\r\nfor additional input after a selection\r\nhas been matched.");
        containerComp = this.createWrapperComposite(settingsComposite);
        this.terminationTimeoutSpinner = this.createValueSpinner(containerComp, 0, 100, 0, 0);
        this.terminationTimeoutSpinner.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                PropertyMediaBinding propertyBinding = RecordMediaScreen.this.bindingManager.getPropertyBinding("final-silence-timeout");
                PropertyBindingItem pbi = (PropertyBindingItem)propertyBinding.getPropertyItem(RecordMediaScreen.this.currentBrand.getName(), RecordMediaScreen.this.getInteractionType()).clone();
                pbi.setValue(Integer.toString(RecordMediaScreen.this.terminationTimeoutSpinner.getSelection()));
                propertyBinding.putPropertyItem(RecordMediaScreen.this.currentBrand.getName(), RecordMediaScreen.this.getInteractionType(), pbi);
            }
        });
        Label maxSpeechTimeoutLabel = this.createPropertyLabel(settingsComposite, "Maximum Recording Time (Seconds)");
        maxSpeechTimeoutLabel.setToolTipText("The maximum length of speech input\r\nin seconds that will be accepted.");
        containerComp = this.createWrapperComposite(settingsComposite);
        this.maxSpeechTimeoutSpinner = this.createValueSpinner(containerComp, 10, 300, 0, 0);
        this.maxSpeechTimeoutSpinner.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                PropertyMediaBinding propertyBinding = RecordMediaScreen.this.bindingManager.getPropertyBinding("max-record-time");
                PropertyBindingItem pbi = (PropertyBindingItem)propertyBinding.getPropertyItem(RecordMediaScreen.this.currentBrand.getName(), RecordMediaScreen.this.getInteractionType()).clone();
                pbi.setValue(Integer.toString(RecordMediaScreen.this.maxSpeechTimeoutSpinner.getSelection()));
                propertyBinding.putPropertyItem(RecordMediaScreen.this.currentBrand.getName(), RecordMediaScreen.this.getInteractionType(), pbi);
            }
        });
        this.comp.addControlListener(new ControlListener(){

            public void controlMoved(ControlEvent e) {
            }

            public void controlResized(ControlEvent e) {
                RecordMediaScreen.this.comp.removeControlListener((ControlListener)this);
                RecordMediaScreen.this.sc.setAlwaysShowScrollBars(true);
                Rectangle clientArea = RecordMediaScreen.this.sc.getClientArea();
                RecordMediaScreen.this.sc.setAlwaysShowScrollBars(false);
                if (RecordMediaScreen.this.sc.getVerticalBar() != null) {
                    RecordMediaScreen.this.sc.getVerticalBar().setVisible(false);
                }
                RecordMediaScreen.this.sc.setMinSize(new Point(clientArea.width, clientArea.height));
                RecordMediaScreen.this.sc.layout(true, true);
                RecordMediaScreen.this.sc.redraw();
            }
        });
        this.sc.setMinWidth(this.comp.computeSize((int)-1, (int)-1, (boolean)true).x);
        this.sc.setMinHeight(this.comp.computeSize((int)-1, (int)-1, (boolean)true).y);
        this.sc.setExpandHorizontal(true);
        this.sc.setExpandVertical(true);
        this.setControl((Control)this.sc);
    }

    public String getInteractionType() {
        return "org.eclipse.vtp.framework.interactions.voice.interaction";
    }

    public void setBrand(Brand brand) {
        PropertyMediaBinding bargeinPropertyBinding;
        PropertyBindingItem pbi;
        System.out.println("setting brand: " + brand.getName());
        this.currentBrand = brand;
        if (this.promptViewer != null) {
            this.promptViewer.setCurrentBrand(brand);
        }
        if ("false".equals((pbi = (bargeinPropertyBinding = this.bindingManager.getPropertyBinding("barge-in")).getPropertyItem(this.currentBrand.getName(), this.getInteractionType())).getValue())) {
            this.barginCombo.select(1);
        } else {
            this.barginCombo.select(0);
        }
        PropertyMediaBinding beepPropertyBinding = this.bindingManager.getPropertyBinding("play-beep");
        pbi = beepPropertyBinding.getPropertyItem(this.currentBrand.getName(), this.getInteractionType());
        if ("false".equals(pbi.getValue())) {
            this.beepCombo.select(1);
        } else {
            this.beepCombo.select(0);
        }
        PropertyMediaBinding initialTimeoutPropertyBinding = this.bindingManager.getPropertyBinding("initial-timeout");
        PropertyBindingItem pbi2 = initialTimeoutPropertyBinding.getPropertyItem(this.currentBrand.getName(), this.getInteractionType());
        if (pbi2.getValue() == null) {
            this.initialTimeoutSpinner.setSelection(0);
        } else {
            this.initialTimeoutSpinner.setSelection(Integer.parseInt(pbi2.getValue()));
        }
        PropertyMediaBinding terminationTimeoutPropertyBinding = this.bindingManager.getPropertyBinding("final-silence-timeout");
        pbi2 = terminationTimeoutPropertyBinding.getPropertyItem(this.currentBrand.getName(), this.getInteractionType());
        if (pbi2.getValue() == null) {
            this.terminationTimeoutSpinner.setSelection(0);
        } else {
            this.terminationTimeoutSpinner.setSelection(Integer.parseInt(pbi2.getValue()));
        }
        PropertyMediaBinding terminationCharacterPropertyBinding = this.bindingManager.getPropertyBinding("dtmf-termination");
        pbi2 = terminationCharacterPropertyBinding.getPropertyItem(this.currentBrand.getName(), this.getInteractionType());
        if (pbi2.getValue() == null) {
            this.terminationCharacterCombo.select(0);
        } else if ("false".equals(pbi2.getValue())) {
            this.terminationCharacterCombo.select(1);
        } else {
            this.terminationCharacterCombo.select(0);
        }
        PropertyMediaBinding maxSpeechTimeoutPropertyBinding = this.bindingManager.getPropertyBinding("max-record-time");
        pbi2 = maxSpeechTimeoutPropertyBinding.getPropertyItem(this.currentBrand.getName(), this.getInteractionType());
        if (pbi2.getValue() == null) {
            this.maxSpeechTimeoutSpinner.setSelection(0);
        } else {
            this.maxSpeechTimeoutSpinner.setSelection(Integer.parseInt(pbi2.getValue()));
        }
    }

    public void setLanguage(String language) {
        this.currentLanguage = language;
        if (this.promptViewer != null) {
            this.promptViewer.setCurrentLanguage(language);
        }
    }

    public Composite createWrapperComposite(Composite parent) {
        return this.createWrapperComposite(parent, 20);
    }

    public Composite createWrapperComposite(Composite parent, int indent) {
        Composite containerComp = new Composite(parent, 0);
        containerComp.setBackground(parent.getBackground());
        GridData gridData = new GridData(802);
        gridData.horizontalIndent = indent;
        gridData.widthHint = 150;
        GridLayout gl = new GridLayout(1, false);
        gl.horizontalSpacing = 0;
        gl.verticalSpacing = 0;
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        containerComp.setLayout((Layout)gl);
        containerComp.setLayoutData((Object)gridData);
        return containerComp;
    }

    public Label createPropertyLabel(Composite parent, String text) {
        Label ret = new Label(parent, 0);
        ret.setText(text);
        ret.setBackground(parent.getBackground());
        GridData gd = new GridData();
        gd.verticalAlignment = 128;
        gd.verticalIndent = 4;
        gd.horizontalIndent = 30;
        ret.setLayoutData((Object)gd);
        return ret;
    }

    public RowDivider createRowDivider(Composite parent, Color dividerColor) {
        RowDivider rd1 = new RowDivider(parent, 0);
        rd1.setBackground(parent.getBackground());
        rd1.setForeground(dividerColor);
        GridData gd = new GridData(768);
        gd.heightHint = 3;
        gd.horizontalIndent = 50;
        gd.horizontalSpan = 2;
        rd1.setLayoutData(gd);
        return rd1;
    }

    private Combo createValueDropDown(Composite parent) {
        Combo ret = new Combo(parent, 2060);
        GridData gd = new GridData();
        gd.verticalIndent = 2;
        gd.horizontalAlignment = 131072;
        gd.grabExcessHorizontalSpace = true;
        ret.setLayoutData((Object)gd);
        return ret;
    }

    public Spinner createValueSpinner(Composite parent, int min, int max, int digits, int value) {
        Spinner ret = new Spinner(parent, 0);
        ret.setMinimum(min);
        ret.setMaximum(max);
        ret.setDigits(digits);
        ret.setSelection(value);
        GridData gd = new GridData();
        gd.verticalIndent = 2;
        gd.horizontalAlignment = 131072;
        gd.grabExcessHorizontalSpace = true;
        ret.setLayoutData((Object)gd);
        return ret;
    }

    public Slider createValueSlider(Composite parent, int min, int max, String leftName, String rightName) {
        Composite sliderComp = new Composite(parent, 0);
        sliderComp.setBackground(parent.getBackground());
        GridData gd = new GridData();
        gd.verticalIndent = 2;
        gd.horizontalAlignment = 131072;
        gd.grabExcessHorizontalSpace = true;
        sliderComp.setLayoutData((Object)gd);
        sliderComp.setLayout((Layout)new FormLayout());
        Label leftLabel = new Label(sliderComp, 0);
        leftLabel.setBackground(sliderComp.getBackground());
        leftLabel.setText(leftName);
        FormData fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.bottom = new FormAttachment(100, 0);
        leftLabel.setLayoutData((Object)fd);
        Label rightLabel = new Label(sliderComp, 0);
        rightLabel.setBackground(sliderComp.getBackground());
        rightLabel.setText(rightName);
        fd = new FormData();
        fd.right = new FormAttachment(100, 0);
        fd.bottom = new FormAttachment(100, 0);
        rightLabel.setLayoutData((Object)fd);
        Slider ret = new Slider(sliderComp, 256);
        ret.setMinimum(min);
        ret.setMaximum(max);
        fd = new FormData();
        fd.left = new FormAttachment((Control)leftLabel, 0, 16384);
        fd.right = new FormAttachment((Control)rightLabel, 0, 131072);
        fd.top = new FormAttachment(0, 0);
        fd.bottom = new FormAttachment((Control)leftLabel, -3);
        fd.width = 150;
        ret.setLayoutData((Object)fd);
        return ret;
    }

    public void valueChanged(PromptBindingViewer viewer) {
        Point preferred = this.comp.computeSize(this.sc.getMinWidth(), -1, true);
        this.sc.setMinSize(preferred);
        this.comp.layout();
        if (preferred.y > this.sc.getClientArea().height) {
            preferred = this.comp.computeSize(this.sc.getClientArea().width, -1, true);
            this.sc.setMinSize(preferred);
            this.comp.layout();
        }
    }

    public class RowDivider
    extends Canvas
    implements PaintListener {
        public RowDivider(Composite parent, int style) {
            super(parent, style);
            this.addPaintListener(this);
        }

        public void paintControl(PaintEvent e) {
            Point size = this.getSize();
            e.gc.drawLine(30, 1, size.x - 30, 1);
        }
    }
}

