/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.framework.util;

import java.util.Comparator;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.eclipse.vtp.framework.util.SingletonTrackerCustomizer;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;

public class SingletonTracker
extends ServiceTracker
implements SingletonTrackerCustomizer {
    private static final Comparator SERVICE_SORT_BY_ID = new Comparator(){

        public int compare(Object leftService, Object rightService) {
            long difference = (Long)((ServiceReference)leftService).getProperty("service.id") - (Long)((ServiceReference)rightService).getProperty("service.id");
            return difference == 0L ? 0 : (int)(difference / Math.abs(difference));
        }
    };
    private final SingletonTrackerCustomizer customizer;
    private final SortedMap candidates = new TreeMap(SERVICE_SORT_BY_ID);
    private boolean selecting = false;
    private volatile ServiceReference selectedReference = null;
    private volatile Object selectedService = null;

    public SingletonTracker(BundleContext context, ServiceReference reference, SingletonTrackerCustomizer customizer) {
        super(context, reference, null);
        this.customizer = customizer == null ? this : customizer;
    }

    public SingletonTracker(BundleContext context, String clazz, SingletonTrackerCustomizer customizer) {
        super(context, clazz, null);
        this.customizer = customizer == null ? this : customizer;
    }

    public SingletonTracker(BundleContext context, Filter filter, SingletonTrackerCustomizer customizer) {
        super(context, filter, null);
        this.customizer = customizer == null ? this : customizer;
    }

    protected void throwableCaught(Throwable t) {
        t.printStackTrace();
    }

    public ServiceReference getServiceReference() {
        return this.selectedReference;
    }

    public Object getService() {
        return this.selectedService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServiceReference[] getServiceReferences() {
        SortedMap sortedMap = this.candidates;
        synchronized (sortedMap) {
            ServiceReference[] serviceReferenceArray;
            if (this.selectedReference == null) {
                serviceReferenceArray = null;
            } else {
                ServiceReference[] serviceReferenceArray2 = new ServiceReference[1];
                serviceReferenceArray = serviceReferenceArray2;
                serviceReferenceArray2[0] = this.selectedReference;
            }
            return serviceReferenceArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getService(ServiceReference ref) {
        SortedMap sortedMap = this.candidates;
        synchronized (sortedMap) {
            return ref != null && ref.equals(this.selectedReference) ? this.selectedService : null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] getServices() {
        SortedMap sortedMap = this.candidates;
        synchronized (sortedMap) {
            Object[] objectArray;
            if (this.selectedService == null) {
                objectArray = null;
            } else {
                Object[] objectArray2 = new Object[1];
                objectArray = objectArray2;
                objectArray2[0] = this.selectedService;
            }
            return objectArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        SortedMap sortedMap = this.candidates;
        synchronized (sortedMap) {
            return this.selectedService == null ? 0 : 1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object waitForService(long timeout) throws InterruptedException {
        if (timeout < 0L) {
            throw new IllegalArgumentException("timeout");
        }
        SortedMap sortedMap = this.candidates;
        synchronized (sortedMap) {
            while (this.selectedService == null) {
                this.candidates.wait(timeout);
                if (timeout == 0L) continue;
            }
            return this.selectedService;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Object addingService(ServiceReference reference) {
        SortedMap sortedMap = this.candidates;
        synchronized (sortedMap) {
            this.candidates.put(reference, Boolean.FALSE);
            if (this.selecting) {
                return reference;
            }
            this.selecting = true;
        }
        try {
            this.selectSingleton();
        }
        catch (Throwable t) {
            this.throwableCaught(t);
        }
        return reference;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void modifiedService(ServiceReference reference, Object service) {
        SortedMap sortedMap = this.candidates;
        synchronized (sortedMap) {
            if (!Boolean.FALSE.equals(this.candidates.get(reference))) {
                return;
            }
            this.candidates.put(reference, Boolean.TRUE);
            if (this.selecting) {
                return;
            }
            this.selecting = true;
        }
        try {
            this.selectSingleton();
        }
        catch (Throwable t) {
            this.throwableCaught(t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removedService(ServiceReference reference, Object service) {
        SortedMap sortedMap = this.candidates;
        synchronized (sortedMap) {
            if (this.candidates.remove(reference) == null) {
                return;
            }
            if (this.selecting) {
                return;
            }
            this.selecting = true;
        }
        try {
            this.selectSingleton();
        }
        catch (Throwable t) {
            this.throwableCaught(t);
        }
    }

    public Object selectingService(ServiceReference reference) {
        return this.context.getService(reference);
    }

    public Object changingSelectedService(ServiceReference oldReference, Object oldService, ServiceReference newReference) {
        Object newService = null;
        try {
            newService = this.context.getService(newReference);
        }
        finally {
            if (newService != null) {
                this.context.ungetService(oldReference);
            }
        }
        return newService;
    }

    public void selectedServiceModified(ServiceReference reference, Object service) {
    }

    public void releasedSelectedService(ServiceReference reference, Object service) {
        this.context.ungetService(reference);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void selectSingleton() {
        RuntimeException re = null;
        while (true) {
            ServiceReference bestReference = null;
            int bestRanking = 0;
            boolean bestModified = false;
            SortedMap sortedMap = this.candidates;
            synchronized (sortedMap) {
                for (Map.Entry entry : this.candidates.entrySet()) {
                    int ranking;
                    ServiceReference reference = (ServiceReference)entry.getKey();
                    Object rankingObj = reference.getProperty("service.ranking");
                    int n = ranking = rankingObj instanceof Integer ? (Integer)rankingObj : 0;
                    if (bestReference == null || ranking > bestRanking) {
                        bestReference = reference;
                        bestRanking = ranking;
                        bestModified = Boolean.TRUE.equals(entry.getValue());
                    }
                    entry.setValue(Boolean.FALSE);
                }
                if (this.selectedReference == null && bestReference == null || this.selectedReference != null && this.selectedReference.equals(bestReference)) {
                    if (!bestModified) {
                        this.selecting = false;
                        if (re != null) {
                            throw re;
                        }
                        return;
                    }
                } else {
                    bestModified = false;
                }
            }
            try {
                if (bestModified) {
                    this.customizer.selectedServiceModified(this.selectedReference, this.selectedService);
                    continue;
                }
                if (this.selectedReference == null) {
                    Object service2 = null;
                    try {
                        service2 = this.customizer.selectingService(bestReference);
                    }
                    catch (Throwable throwable) {
                        SortedMap sortedMap2 = this.candidates;
                        synchronized (sortedMap2) {
                            if (service2 == null) {
                                this.candidates.remove(bestReference);
                            } else {
                                this.selectedReference = bestReference;
                                this.selectedService = service2;
                                this.candidates.notifyAll();
                            }
                        }
                        throw throwable;
                    }
                    SortedMap sortedMap3 = this.candidates;
                    synchronized (sortedMap3) {
                        if (service2 == null) {
                            this.candidates.remove(bestReference);
                        } else {
                            this.selectedReference = bestReference;
                            this.selectedService = service2;
                            this.candidates.notifyAll();
                        }
                        continue;
                    }
                }
                if (bestReference == null) {
                    SortedMap sortedMap3;
                    try {
                        this.customizer.releasedSelectedService(this.selectedReference, this.selectedService);
                    }
                    catch (Throwable service2) {
                        sortedMap3 = this.candidates;
                        synchronized (sortedMap3) {
                            this.selectedReference = null;
                            this.selectedService = null;
                        }
                        throw service2;
                    }
                    sortedMap3 = this.candidates;
                    synchronized (sortedMap3) {
                        this.selectedReference = null;
                        this.selectedService = null;
                        continue;
                    }
                }
                Object service = null;
                try {
                    service = this.customizer.changingSelectedService(this.selectedReference, this.selectedService, bestReference);
                }
                catch (Throwable throwable) {
                    SortedMap sortedMap4 = this.candidates;
                    synchronized (sortedMap4) {
                        if (service == null) {
                            this.candidates.remove(bestReference);
                        } else {
                            this.selectedReference = bestReference;
                            this.selectedService = service;
                        }
                    }
                    throw throwable;
                }
                SortedMap sortedMap5 = this.candidates;
                synchronized (sortedMap5) {
                    if (service == null) {
                        this.candidates.remove(bestReference);
                    } else {
                        this.selectedReference = bestReference;
                        this.selectedService = service;
                    }
                    continue;
                }
            }
            catch (RuntimeException e) {
                if (re != null) continue;
                re = e;
                continue;
            }
            break;
        }
    }
}

