/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.framework.util;

import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import javax.xml.transform.Result;
import javax.xml.transform.sax.SAXResult;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public class XMLWriter
implements ContentHandler {
    private PrintWriter output = null;
    private char indentCharacter = (char)32;
    private int indentSize = 2;
    private int deepIndentSize = 4;
    private int elementDepth = 0;
    private final Map namespaceURIsByPrefix = new HashMap();
    private final Map prefixesByNamespaceURI = new HashMap();
    private final Set newPrefixes = new LinkedHashSet();
    private boolean parentElementIncomplete = false;
    private boolean afterCDATA = false;

    public XMLWriter() {
    }

    public XMLWriter(PrintWriter output) {
        this.setOutput(output);
    }

    public void setOutput(PrintWriter output) {
        this.output = output;
    }

    public void setIndentCharacter(char indentCharacter) {
        this.indentCharacter = indentCharacter;
    }

    public void setIndentSize(int indentSize) {
        this.indentSize = indentSize < 0 ? 0 : indentSize;
    }

    public void setDeepIndentSize(int deepIndentSize) {
        this.deepIndentSize = deepIndentSize < 0 ? 0 : deepIndentSize;
    }

    public Result toXMLResult() {
        return new SAXResult(this);
    }

    public void setDocumentLocator(Locator locator) {
    }

    public void startDocument() throws SAXException {
        this.elementDepth = 0;
        this.namespaceURIsByPrefix.clear();
        this.prefixesByNamespaceURI.clear();
        this.newPrefixes.clear();
        this.parentElementIncomplete = false;
        this.afterCDATA = false;
        this.output.println("<?xml version=\"1.0\" ?>");
    }

    public void endDocument() throws SAXException {
        this.output.print('\r');
        this.output.print('\n');
        this.afterCDATA = false;
        this.parentElementIncomplete = false;
        this.newPrefixes.clear();
        this.prefixesByNamespaceURI.clear();
        this.namespaceURIsByPrefix.clear();
        this.elementDepth = 0;
    }

    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        this.stackedIndexPush(this.namespaceURIsByPrefix, prefix, uri);
        this.stackedIndexPush(this.prefixesByNamespaceURI, uri, prefix);
        this.newPrefixes.remove(prefix);
        this.newPrefixes.add(prefix);
    }

    public void endPrefixMapping(String prefix) throws SAXException {
        String uri = this.stackedIndexPop(this.namespaceURIsByPrefix, prefix);
        this.stackedIndexRemove(this.prefixesByNamespaceURI, uri, prefix);
    }

    public void startElement(String uri, String localName, String name, Attributes atts) throws SAXException {
        this.ensureParentElementIsComplete();
        this.output.print('\r');
        this.output.print('\n');
        this.indent();
        this.output.print('<');
        this.writeName(uri, localName, name);
        Iterator i = this.newPrefixes.iterator();
        while (i.hasNext()) {
            this.output.print('\r');
            this.output.print('\n');
            this.deepIndent();
            String prefix = (String)i.next();
            String xmlns = this.stackedIndexPeek(this.namespaceURIsByPrefix, prefix);
            if (prefix.length() == 0) {
                this.writeNameValuePair(null, null, "xmlns", xmlns);
                continue;
            }
            this.writeNameValuePair(null, null, "xmlns:" + prefix, xmlns);
        }
        this.newPrefixes.clear();
        int i2 = 0;
        while (i2 < atts.getLength()) {
            if (!"http://www.w3.org/2000/xmlns/".equals(atts.getURI(i2))) {
                this.output.print('\r');
                this.output.print('\n');
                this.deepIndent();
                this.writeNameValuePair(atts.getURI(i2), atts.getLocalName(i2), atts.getQName(i2), atts.getValue(i2));
            }
            ++i2;
        }
        this.parentElementIncomplete = true;
        this.afterCDATA = false;
        ++this.elementDepth;
    }

    public void endElement(String uri, String localName, String name) throws SAXException {
        --this.elementDepth;
        if (this.parentElementIncomplete) {
            this.output.print(" />");
            this.parentElementIncomplete = false;
        } else {
            this.output.print('\r');
            this.output.print('\n');
            this.indent();
            this.output.print("</");
            this.writeName(uri, localName, name);
            this.output.print('>');
        }
        this.afterCDATA = false;
    }

    public void processingInstruction(String target, String data) throws SAXException {
        this.ensureParentElementIsComplete();
        this.output.print('\r');
        this.output.print('\n');
        this.indent();
        this.output.print("<?");
        this.output.print(target);
        this.output.print(' ');
        this.output.print(data);
        this.output.print(" ?>");
        this.afterCDATA = false;
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        if (!this.afterCDATA) {
            this.ensureParentElementIsComplete();
            this.output.print('\r');
            this.output.print('\n');
            this.indent();
        }
        boolean hadCR = false;
        int i = 0;
        while (i < length) {
            char c = ch[start + i];
            if (c == '\n' || hadCR) {
                hadCR = false;
                this.output.print('\r');
                this.output.print('\n');
                this.indent();
                if (c != '\n') {
                    this.output.print(c);
                }
            } else {
                switch (c) {
                    case '\r': {
                        hadCR = true;
                        break;
                    }
                    case '\'': {
                        this.output.print("&apos;");
                        break;
                    }
                    case '\"': {
                        this.output.print("&quot;");
                        break;
                    }
                    case '&': {
                        this.output.print("&amp;");
                        break;
                    }
                    case '<': {
                        this.output.print("&lt;");
                        break;
                    }
                    case '>': {
                        this.output.print("&gt;");
                        break;
                    }
                    default: {
                        this.output.print(c);
                    }
                }
            }
            ++i;
        }
        if (hadCR) {
            this.output.print('\r');
            this.output.print('\n');
        }
        this.afterCDATA = true;
    }

    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
    }

    public void skippedEntity(String name) throws SAXException {
    }

    private void ensureParentElementIsComplete() {
        if (this.parentElementIncomplete) {
            this.output.append('>');
            this.parentElementIncomplete = false;
        }
    }

    private void indent() {
        int i = 0;
        while (i < this.elementDepth) {
            int j = 0;
            while (j < this.indentSize) {
                this.output.print(this.indentCharacter);
                ++j;
            }
            ++i;
        }
    }

    private void deepIndent() {
        this.indent();
        int i = 0;
        while (i < this.deepIndentSize) {
            this.output.print(this.indentCharacter);
            ++i;
        }
    }

    private void writeName(String uri, String localName, String qualifiedName) {
        if (uri == null || uri.length() == 0) {
            if (qualifiedName == null || qualifiedName.length() == 0) {
                this.output.print(localName);
            } else {
                this.output.print(qualifiedName);
            }
        } else if (localName == null || localName.length() == 0) {
            this.output.print(qualifiedName);
        } else {
            String prefix = this.stackedIndexPeek(this.prefixesByNamespaceURI, uri);
            if (prefix == null || prefix.length() == 0) {
                this.output.print(localName);
            } else {
                this.output.print(prefix);
                this.output.print(':');
                this.output.print(localName);
            }
        }
    }

    private void writeNameValuePair(String uri, String localName, String qualifiedName, String value) {
        this.writeName(uri, localName, qualifiedName);
        this.output.print('=');
        this.output.print('\"');
        if (value != null) {
            int i = 0;
            while (i < value.length()) {
                switch (value.charAt(i)) {
                    case '\'': {
                        this.output.print("&apos;");
                        break;
                    }
                    case '\"': {
                        this.output.print("&quot;");
                        break;
                    }
                    case '&': {
                        this.output.print("&amp;");
                        break;
                    }
                    case '<': {
                        this.output.print("&lt;");
                        break;
                    }
                    case '>': {
                        this.output.print("&gt;");
                        break;
                    }
                    default: {
                        this.output.print(value.charAt(i));
                    }
                }
                ++i;
            }
        }
        this.output.print('\"');
    }

    private void stackedIndexPush(Map index, String key, String value) {
        Object stack = index.get(key);
        if (stack == null) {
            index.put(key, value);
        } else {
            LinkedList<Object> values = null;
            if (stack instanceof String) {
                values = new LinkedList<Object>();
                values.addFirst(stack);
                index.put(key, values);
            } else {
                values = (LinkedList<Object>)stack;
            }
            values.addFirst(value);
        }
    }

    private String stackedIndexPeek(Map index, String key) {
        Object stack = index.get(key);
        if (stack == null) {
            return null;
        }
        if (stack instanceof String) {
            return (String)stack;
        }
        return (String)((LinkedList)stack).getFirst();
    }

    private String stackedIndexPop(Map index, String key) {
        Object stack = index.get(key);
        if (stack == null) {
            return null;
        }
        if (stack instanceof String) {
            index.remove(key);
            return (String)stack;
        }
        LinkedList values = (LinkedList)stack;
        String value = (String)values.removeFirst();
        if (values.isEmpty()) {
            index.remove(key);
        }
        return value;
    }

    private void stackedIndexRemove(Map index, String key, String value) {
        Object stack = index.get(key);
        if (stack == null) {
            return;
        }
        if (stack instanceof String) {
            if (stack.equals(value)) {
                index.remove(key);
            }
        } else {
            LinkedList values = (LinkedList)stack;
            values.remove(value);
            if (values.isEmpty()) {
                index.remove(key);
            }
        }
    }
}

