/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.framework.engine;

import org.eclipse.vtp.framework.core.IAction;
import org.eclipse.vtp.framework.engine.DescriptorUtils;

public final class ActionDescriptor {
    private final String id;
    private final String name;
    private final Class type;
    private final boolean blocking;

    public ActionDescriptor(String id, String name, Class type, boolean blocking) throws IllegalArgumentException, NullPointerException {
        if (id == null) {
            throw new NullPointerException("id");
        }
        if (id.length() == 0) {
            throw new IllegalArgumentException("id");
        }
        if (name == null) {
            throw new NullPointerException("name");
        }
        if (name.length() == 0) {
            throw new IllegalArgumentException("name");
        }
        if (type == null) {
            throw new NullPointerException("type");
        }
        if (!DescriptorUtils.isValidImplementation(type, IAction.class)) {
            throw new IllegalArgumentException("type=" + type.getName());
        }
        this.id = id;
        this.name = name;
        this.type = type;
        this.blocking = blocking;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public Class getType() {
        return this.type;
    }

    public boolean isBlocking() {
        return this.blocking;
    }

    public String toString() {
        return new StringBuffer(this.getClass().getName().substring(this.getClass().getName().lastIndexOf(46) + 1)).append('[').append(this.id).append(';').append(this.name).append(';').append(this.type.getName()).append(']').toString();
    }
}

