/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.framework.engine;

import org.eclipse.vtp.framework.core.IConfiguration;
import org.eclipse.vtp.framework.engine.DescriptorUtils;

public final class ConfigurationDescriptor {
    private final String id;
    private final String name;
    private final String xmlNamespace;
    private final String xmlTag;
    private final Class type;

    public ConfigurationDescriptor(String id, String name, String xmlNamespace, String xmlTag, Class type) throws IllegalArgumentException, NullPointerException {
        if (id == null) {
            throw new NullPointerException("id");
        }
        if (id.length() == 0) {
            throw new IllegalArgumentException("id");
        }
        if (name == null) {
            throw new NullPointerException("name");
        }
        if (name.length() == 0) {
            throw new IllegalArgumentException("name");
        }
        if (xmlNamespace == null) {
            throw new NullPointerException("xmlNamespace");
        }
        if (xmlNamespace.length() == 0) {
            throw new IllegalArgumentException("xmlNamespace");
        }
        if (xmlTag == null) {
            throw new NullPointerException("xmlTag");
        }
        if (xmlTag.length() == 0) {
            throw new IllegalArgumentException("xmlTag");
        }
        if (type == null) {
            throw new NullPointerException("type");
        }
        if (!DescriptorUtils.isValidImplementation(type, IConfiguration.class)) {
            throw new IllegalArgumentException("type: " + type);
        }
        this.id = id;
        this.name = name;
        this.xmlNamespace = xmlNamespace;
        this.xmlTag = xmlTag;
        this.type = type;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getXmlNamespace() {
        return this.xmlNamespace;
    }

    public String getXmlTag() {
        return this.xmlTag;
    }

    public Class getType() {
        return this.type;
    }

    public String toString() {
        return new StringBuffer(this.getClass().getName().substring(this.getClass().getName().lastIndexOf(46) + 1)).append('[').append(this.id).append(';').append(this.name).append(';').append(this.xmlNamespace).append(';').append(this.xmlTag).append(';').append(this.type).append(']').toString();
    }
}

