/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.framework.engine;

import java.util.LinkedHashMap;
import org.eclipse.vtp.framework.engine.FieldDescriptor;

public final class DataTypeDescriptor {
    private final String name;
    private final FieldDescriptor[] fields;

    public DataTypeDescriptor(String name, FieldDescriptor[] fields) {
        if (name == null) {
            throw new NullPointerException("name");
        }
        if (name.length() == 0) {
            throw new IllegalArgumentException("name");
        }
        if (fields == null) {
            throw new NullPointerException("fields");
        }
        this.name = name;
        LinkedHashMap<String, FieldDescriptor> map = new LinkedHashMap<String, FieldDescriptor>();
        int i = 0;
        while (i < fields.length) {
            if (fields[i] == null) {
                throw new NullPointerException("fields[" + i + "]");
            }
            if (map.containsKey(fields[i].getName())) {
                throw new IllegalArgumentException("fields[" + i + "]");
            }
            map.put(fields[i].getName(), fields[i]);
            ++i;
        }
        this.fields = map.values().toArray(new FieldDescriptor[map.size()]);
    }

    public String getName() {
        return this.name;
    }

    public int getFieldCount() {
        return this.fields.length;
    }

    public FieldDescriptor getField(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this.fields.length) {
            throw new IndexOutOfBoundsException(String.valueOf(index));
        }
        return this.fields[index];
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(this.getClass().getName().substring(this.getClass().getName().lastIndexOf(46) + 1)).append('[').append(this.name).append(';');
        int i = 0;
        while (i < this.fields.length) {
            buffer.append(this.fields[i].getName()).append(',');
            ++i;
        }
        buffer.setLength(buffer.length() - 1);
        return buffer.append(']').toString();
    }
}

