/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.framework.engine;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.vtp.framework.spi.IProcessDefinition;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ProcessDefinition
implements IProcessDefinition {
    private static final String URI = "http://eclipse.org/vtp/xml/framework/engine/process-definition";
    private final Map serviceConfigurations = new HashMap();
    private final Map actionNames = new HashMap();
    private final Map sequenceDefinitions = new HashMap();
    private final Map observerDescriptorIDs = new HashMap();
    private final Map observerConfigurations = new HashMap();
    private final String startActionInstanceID;

    public ProcessDefinition(Document document) throws IllegalArgumentException, NullPointerException {
        if (document == null) {
            throw new NullPointerException("document");
        }
        Element definition = document.getDocumentElement();
        if (definition == null) {
            throw new IllegalArgumentException();
        }
        if (!URI.equals(definition.getNamespaceURI())) {
            throw new IllegalArgumentException();
        }
        if (!"definition".equals(definition.getLocalName())) {
            throw new IllegalArgumentException();
        }
        Element services = null;
        NodeList list = definition.getElementsByTagNameNS(URI, "services");
        if (list.getLength() != 1) {
            throw new IllegalArgumentException();
        }
        services = (Element)list.item(0);
        list = services.getElementsByTagNameNS(URI, "service");
        int i = 0;
        while (i < list.getLength()) {
            Element service = (Element)list.item(i);
            String id = service.getAttribute("id");
            NodeList elements = service.getChildNodes();
            ArrayList<Node> configs = new ArrayList<Node>(elements.getLength());
            int j = 0;
            while (j < elements.getLength()) {
                if (elements.item(j) instanceof Element) {
                    configs.add(elements.item(j));
                }
                ++j;
            }
            this.serviceConfigurations.put(id, configs);
            ++i;
        }
        Element actions = null;
        list = definition.getElementsByTagNameNS(URI, "actions");
        if (list.getLength() != 1) {
            throw new IllegalArgumentException();
        }
        actions = (Element)list.item(0);
        list = actions.getElementsByTagNameNS(URI, "action");
        int i2 = 0;
        while (i2 < list.getLength()) {
            Element action = (Element)list.item(i2);
            String id = action.getAttribute("id");
            this.actionNames.put(id, action.getAttribute("name"));
            SequenceDefinition sequence = new SequenceDefinition(id, action.getAttribute("descriptor-id"), action.getChildNodes());
            this.sequenceDefinitions.put(sequence.actionInstanceID, sequence);
            ++i2;
        }
        Element observers = null;
        list = definition.getElementsByTagNameNS(URI, "observers");
        if (list.getLength() != 1) {
            throw new IllegalArgumentException();
        }
        observers = (Element)list.item(0);
        list = observers.getElementsByTagNameNS(URI, "observer");
        int i3 = 0;
        while (i3 < list.getLength()) {
            Element observer = (Element)list.item(i3);
            String id = observer.getAttribute("id");
            this.observerDescriptorIDs.put(id, observer.getAttribute("descriptor-id"));
            NodeList elements = observer.getChildNodes();
            ArrayList<Node> configurations = new ArrayList<Node>(elements.getLength());
            int j = 0;
            while (j < elements.getLength()) {
                if (elements.item(j) instanceof Element) {
                    configurations.add(elements.item(j));
                }
                ++j;
            }
            this.observerConfigurations.put(id, configurations);
            ++i3;
        }
        Element transitions = null;
        list = definition.getElementsByTagNameNS(URI, "transitions");
        if (list.getLength() != 1) {
            throw new IllegalArgumentException();
        }
        transitions = (Element)list.item(0);
        list = transitions.getElementsByTagNameNS(URI, "before");
        int i4 = 0;
        while (i4 < list.getLength()) {
            Element before = (Element)list.item(i4);
            String action = before.getAttribute("action");
            SequenceDefinition sequence = (SequenceDefinition)this.sequenceDefinitions.get(action);
            if (sequence == null) {
                throw new IllegalArgumentException();
            }
            if (sequence.beforeObservers != null) {
                throw new IllegalArgumentException();
            }
            NodeList notify = before.getElementsByTagNameNS(URI, "notify");
            sequence.beforeObservers = new ArrayList(notify.getLength());
            int j = 0;
            while (j < notify.getLength()) {
                String observer = ((Element)notify.item(j)).getAttribute("observer");
                if (!this.observerDescriptorIDs.containsKey(observer)) {
                    throw new IllegalArgumentException();
                }
                sequence.beforeObservers.add(observer);
                ++j;
            }
            ++i4;
        }
        list = transitions.getElementsByTagNameNS(URI, "after");
        i4 = 0;
        while (i4 < list.getLength()) {
            Element after = (Element)list.item(i4);
            String action = after.getAttribute("action");
            String path = after.getAttribute("path");
            String target = after.getAttribute("target");
            SequenceDefinition sequence = (SequenceDefinition)this.sequenceDefinitions.get(action);
            if (sequence == null) {
                throw new IllegalArgumentException();
            }
            if (sequence.targets.containsKey(path)) {
                throw new IllegalArgumentException();
            }
            SequenceDefinition targetSequence = (SequenceDefinition)this.sequenceDefinitions.get(target);
            if (targetSequence == null) {
                throw new IllegalArgumentException();
            }
            sequence.targets.put(path, target);
            NodeList notify = after.getElementsByTagNameNS(URI, "notify");
            ArrayList<String> afterObservers = new ArrayList<String>(notify.getLength());
            sequence.afterObservers.put(path, afterObservers);
            int j = 0;
            while (j < notify.getLength()) {
                String observer = ((Element)notify.item(j)).getAttribute("observer");
                if (!this.observerDescriptorIDs.containsKey(observer)) {
                    throw new IllegalArgumentException();
                }
                afterObservers.add(observer);
                ++j;
            }
            ++i4;
        }
        this.startActionInstanceID = definition.getAttribute("start");
        if (!this.sequenceDefinitions.containsKey(this.startActionInstanceID)) {
            throw new IllegalArgumentException();
        }
    }

    public Element[] getServiceConfiguration(String serviceDescriptorID) {
        List list = (List)this.serviceConfigurations.get(serviceDescriptorID);
        if (list == null) {
            return new Element[0];
        }
        return list.toArray(new Element[list.size()]);
    }

    public String getStartActionInstanceID() {
        return this.startActionInstanceID;
    }

    public String[] getActionInstanceIDs() {
        return this.sequenceDefinitions.keySet().toArray(new String[this.sequenceDefinitions.size()]);
    }

    public String getActionName(String actionInstanceID) {
        return (String)this.actionNames.get(actionInstanceID);
    }

    public String getActionDescriptorID(String actionInstanceID) {
        SequenceDefinition sequence = (SequenceDefinition)this.sequenceDefinitions.get(actionInstanceID);
        if (sequence == null) {
            return null;
        }
        return sequence.actionDescriptorID;
    }

    public Element[] getActionConfiguration(String actionInstanceID) {
        SequenceDefinition sequence = (SequenceDefinition)this.sequenceDefinitions.get(actionInstanceID);
        if (sequence == null) {
            return new Element[0];
        }
        return sequence.configurations.toArray(new Element[sequence.configurations.size()]);
    }

    public String[] getActionResultIDs(String actionInstanceID) {
        SequenceDefinition sequence = (SequenceDefinition)this.sequenceDefinitions.get(actionInstanceID);
        if (sequence == null) {
            return new String[0];
        }
        return sequence.targets.keySet().toArray(new String[sequence.targets.size()]);
    }

    public String getActionResultTargetInstanceID(String actionInstanceID, String actionResultID) {
        SequenceDefinition sequence = (SequenceDefinition)this.sequenceDefinitions.get(actionInstanceID);
        if (sequence == null) {
            return null;
        }
        return (String)sequence.targets.get(actionResultID);
    }

    public String[] getBeforeObserverInstanceIDs(String actionInstanceID) {
        SequenceDefinition sequence = (SequenceDefinition)this.sequenceDefinitions.get(actionInstanceID);
        if (sequence == null) {
            return new String[0];
        }
        if (sequence.beforeObservers == null) {
            return new String[0];
        }
        return sequence.beforeObservers.toArray(new String[sequence.beforeObservers.size()]);
    }

    public String[] getAfterObserverInstanceIDs(String actionInstanceID, String actionResultID) {
        SequenceDefinition sequence = (SequenceDefinition)this.sequenceDefinitions.get(actionInstanceID);
        if (sequence == null) {
            return new String[0];
        }
        List afterObservers = (List)sequence.afterObservers.get(actionResultID);
        if (afterObservers == null) {
            return new String[0];
        }
        return afterObservers.toArray(new String[afterObservers.size()]);
    }

    public String getObserverDescriptorID(String observerInstanceID) {
        return (String)this.observerDescriptorIDs.get(observerInstanceID);
    }

    public Element[] getObserverConfiguration(String observerInstanceID) {
        List elements = (List)this.observerConfigurations.get(observerInstanceID);
        if (elements == null) {
            return new Element[0];
        }
        return elements.toArray(new Element[elements.size()]);
    }

    private final class SequenceDefinition {
        final String actionInstanceID;
        final String actionDescriptorID;
        final List configurations;
        final Map targets = new HashMap();
        final Map afterObservers = new HashMap();
        List beforeObservers = null;

        SequenceDefinition(String actionInstanceID, String actionDescriptorID, NodeList configurations) {
            this.actionInstanceID = actionInstanceID;
            this.actionDescriptorID = actionDescriptorID;
            this.configurations = new ArrayList(configurations.getLength());
            int j = 0;
            while (j < configurations.getLength()) {
                if (configurations.item(j) instanceof Element) {
                    this.configurations.add(configurations.item(j));
                }
                ++j;
            }
        }
    }
}

