/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.framework.engine;

import java.net.URL;
import java.util.Enumeration;
import java.util.LinkedList;
import org.eclipse.vtp.framework.interactions.core.media.IResourceManager;
import org.osgi.framework.Bundle;

public class ResourceGroup
implements IResourceManager {
    private final Bundle bundle;
    private final String path;

    public ResourceGroup(Bundle bundle, String path) {
        this.bundle = bundle;
        if (!path.startsWith("/")) {
            path = "/" + path;
        }
        if (!path.endsWith("/")) {
            path = String.valueOf(path) + "/";
        }
        this.path = path;
    }

    public URL getResource(String fullResourcePath) {
        return this.bundle.getEntry(String.valueOf(this.path) + fullResourcePath);
    }

    public String[] listResources(String fullDirectoryPath) {
        LinkedList list = new LinkedList();
        Enumeration e = this.bundle.getEntryPaths(String.valueOf(this.path) + fullDirectoryPath);
        while (e != null && e.hasMoreElements()) {
            list.add(e.nextElement());
        }
        return list.toArray(new String[list.size()]);
    }

    public boolean isDirectoryResource(String fullDirectoryPath) {
        return fullDirectoryPath.endsWith("/");
    }

    public boolean isFileResource(String fullFilePath) {
        return !this.isDirectoryResource(fullFilePath) && this.getResource(fullFilePath) != null;
    }
}

