/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.framework.engine.http;

import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.eclipse.vtp.framework.core.IReporter;
import org.eclipse.vtp.framework.engine.http.DeploymentSession;
import org.eclipse.vtp.framework.engine.http.HttpUtils;
import org.eclipse.vtp.framework.interactions.core.media.IResourceManager;
import org.eclipse.vtp.framework.interactions.core.media.IResourceManagerRegistry;
import org.eclipse.vtp.framework.interactions.core.platforms.IDocument;
import org.eclipse.vtp.framework.spi.IProcess;
import org.eclipse.vtp.framework.spi.IProcessDefinition;
import org.eclipse.vtp.framework.spi.IProcessDescriptor;
import org.eclipse.vtp.framework.spi.IProcessEngine;
import org.osgi.framework.Bundle;

public class Deployment
implements IProcessDescriptor,
IResourceManagerRegistry {
    private final IProcess process;
    private final Dictionary properties;
    private final Bundle contributor;
    private final IReporter reporter;
    private final Map sessions = new HashMap();
    private final Map resources = new HashMap();

    public Deployment(IProcessEngine engine, IProcessDefinition definition, Dictionary properties, Bundle contributor, IReporter reporter) {
        this.process = engine.createProcess(definition, (IProcessDescriptor)this);
        this.properties = properties;
        String[] resourceManagerIDs = (String[])properties.get("resources");
        if (resourceManagerIDs != null) {
            int i = 0;
            while (i < resourceManagerIDs.length) {
                this.resources.put(resourceManagerIDs[i], null);
                ++i;
            }
        }
        this.contributor = contributor;
        this.reporter = reporter;
        Hashtable<String, String> report = new Hashtable<String, String>();
        ((Dictionary)report).put("event", "process.started");
        ((IReporter)this.process.lookupService(IReporter.class.getName())).report(3, "Process \"" + this.getID() + "\" Started", report);
    }

    public String getID() {
        String id = (String)this.properties.get("process.id");
        if (id == null) {
            id = (String)this.properties.get("deployment.id");
        }
        return id;
    }

    public String getPath() {
        return HttpUtils.normalizePath((String)this.properties.get("path"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setResourceManager(String resourceManagerID, IResourceManager resourceManager) {
        Map map = this.resources;
        synchronized (map) {
            if (!this.resources.containsKey(resourceManagerID)) {
                this.resources.put(resourceManagerID, resourceManager);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IDocument start(HttpSession httpSession, HttpServletRequest httpRequest, HttpServletResponse httpReesponse, String prefix, Map variableValues, Map parameterValues, String brand) {
        String sessionID = httpSession.getId();
        DeploymentSession session = null;
        Map map = this.sessions;
        synchronized (map) {
            session = (DeploymentSession)this.sessions.get(sessionID);
            if (session == null) {
                session = new DeploymentSession(sessionID, this.process);
                this.sessions.put(sessionID, session);
            }
        }
        IDocument document = session.start(httpSession, httpRequest, httpReesponse, prefix, variableValues, parameterValues, brand);
        if (document == null) {
            return this.abort(httpSession, httpRequest, httpReesponse, prefix, variableValues, parameterValues);
        }
        return document;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IDocument next(HttpSession httpSession, HttpServletRequest httpRequest, HttpServletResponse httpReesponse, String prefix, Map variableValues, Map parameterValues) {
        String sessionID = httpSession.getId();
        DeploymentSession session = null;
        Map map = this.sessions;
        synchronized (map) {
            session = (DeploymentSession)this.sessions.get(sessionID);
            if (session == null) {
                session = new DeploymentSession(sessionID, this.process);
                this.sessions.put(sessionID, session);
            }
        }
        IDocument document = session.next(httpSession, httpRequest, httpReesponse, prefix, variableValues, parameterValues);
        if (document == null) {
            return this.abort(httpSession, httpRequest, httpReesponse, prefix, variableValues, parameterValues);
        }
        return document;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IDocument abort(HttpSession httpSession, HttpServletRequest httpRequest, HttpServletResponse httpReesponse, String prefix, Map variableValues, Map parameterValues) {
        String sessionID = httpSession.getId();
        DeploymentSession session = null;
        Map map = this.sessions;
        synchronized (map) {
            session = (DeploymentSession)this.sessions.remove(sessionID);
            if (session == null) {
                session = new DeploymentSession(sessionID, this.process);
            }
        }
        return session.abort(httpSession, httpRequest, httpReesponse, prefix, variableValues, parameterValues);
    }

    public void dispose() {
        Hashtable<String, String> report = new Hashtable<String, String>();
        ((Dictionary)report).put("event", "process.stopped");
        ((IReporter)this.process.lookupService(IReporter.class.getName())).report(3, "Process \"" + this.getID() + "\" Stopped", report);
    }

    public String getProcessID() {
        return this.getID();
    }

    public Object getProperty(String propertyName) throws NullPointerException {
        return this.properties.get(propertyName);
    }

    public String[] getServiceIdentifiers() {
        return new String[]{IResourceManagerRegistry.class.getName()};
    }

    public Object getService(String identifier) throws NullPointerException {
        return IResourceManagerRegistry.class.getName().equals(identifier) ? this : null;
    }

    public Class loadClass(String className) throws ClassNotFoundException, NullPointerException {
        return this.contributor.loadClass(className);
    }

    public boolean isSeverityEnabled(int severity) {
        return this.reporter.isSeverityEnabled(severity);
    }

    public void report(int severity, String[] categories, String message, Dictionary properties) {
        this.reporter.report(severity, categories, message, properties);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getResourceManagerIDs() {
        Map map = this.resources;
        synchronized (map) {
            return this.resources.keySet().toArray(new String[this.resources.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IResourceManager getResourceManager(String resourceManagerID) {
        Map map = this.resources;
        synchronized (map) {
            return (IResourceManager)this.resources.get(resourceManagerID);
        }
    }
}

