/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.framework.engine.http;

import java.io.File;
import java.net.URLEncoder;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.RequestContext;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.fileupload.servlet.ServletRequestContext;
import org.eclipse.vtp.framework.common.IArrayObject;
import org.eclipse.vtp.framework.common.IBooleanObject;
import org.eclipse.vtp.framework.common.IDataObject;
import org.eclipse.vtp.framework.common.IDateObject;
import org.eclipse.vtp.framework.common.IDecimalObject;
import org.eclipse.vtp.framework.common.INumberObject;
import org.eclipse.vtp.framework.common.IStringObject;
import org.eclipse.vtp.framework.common.IVariableRegistry;
import org.eclipse.vtp.framework.common.commands.ExitCommand;
import org.eclipse.vtp.framework.common.commands.ForwardCommand;
import org.eclipse.vtp.framework.common.commands.IControllerCommandVisitor;
import org.eclipse.vtp.framework.common.commands.IncludeCommand;
import org.eclipse.vtp.framework.core.IReporter;
import org.eclipse.vtp.framework.engine.http.ControllerDocument;
import org.eclipse.vtp.framework.engine.http.DeploymentSession;
import org.eclipse.vtp.framework.engine.http.HttpUtils;
import org.eclipse.vtp.framework.interactions.core.IInteractionType;
import org.eclipse.vtp.framework.interactions.core.IInteractionTypeRegistry;
import org.eclipse.vtp.framework.interactions.core.IInteractionTypeSelection;
import org.eclipse.vtp.framework.interactions.core.commands.ConversationCommand;
import org.eclipse.vtp.framework.interactions.core.commands.EndMessageCommand;
import org.eclipse.vtp.framework.interactions.core.platforms.IDocument;
import org.eclipse.vtp.framework.interactions.core.platforms.ILink;
import org.eclipse.vtp.framework.interactions.core.platforms.ILinkFactory;
import org.eclipse.vtp.framework.interactions.core.platforms.IPlatform;
import org.eclipse.vtp.framework.interactions.core.platforms.IPlatformSelector;
import org.eclipse.vtp.framework.interactions.core.platforms.IRenderingQueue;
import org.eclipse.vtp.framework.spi.ICommand;
import org.eclipse.vtp.framework.spi.ICommandVisitor;
import org.eclipse.vtp.framework.spi.IExecution;
import org.eclipse.vtp.framework.spi.IExecutionDescriptor;
import org.eclipse.vtp.framework.spi.IRunnableCommand;
import org.eclipse.vtp.framework.spi.IRunnableCommandVisitor;
import org.eclipse.vtp.framework.util.Guid;

public class DeploymentExecution
implements IExecutionDescriptor,
ILinkFactory,
IRenderingQueue,
IRunnableCommandVisitor,
IControllerCommandVisitor,
IInteractionTypeSelection {
    private final String id;
    private final DeploymentSession session;
    private final HttpServletRequest httpRequest;
    private final HttpServletResponse httpResponse;
    private final Map parameters;
    private IInteractionTypeRegistry interactionTypeRegistry = null;
    private IVariableRegistry variableRegistry = null;
    private IPlatform platform = null;
    private ICommand command = null;
    private boolean urlEncoded = true;

    public DeploymentExecution(String id, DeploymentSession session, HttpServletRequest httpRequest, HttpServletResponse httpResponse, Map parameterValues) {
        this.id = id;
        this.session = session;
        this.httpRequest = httpRequest;
        this.httpResponse = httpResponse;
        this.parameters = new HashMap();
        for (Map.Entry entry : parameterValues.entrySet()) {
            this.parameters.put(entry.getKey(), entry.getValue());
        }
        ServletFileUpload upload = new ServletFileUpload((FileItemFactory)new DiskFileItemFactory());
        if (ServletFileUpload.isMultipartContent((RequestContext)new ServletRequestContext(httpRequest))) {
            try {
                List items = upload.parseRequest(httpRequest);
                int i = 0;
                while (i < items.size()) {
                    FileItem fui = (FileItem)items.get(i);
                    if (fui.isFormField()) {
                        this.parameters.put(fui.getFieldName(), new String[]{fui.getString()});
                    } else {
                        File temp = File.createTempFile(Guid.createGUID(), ".tmp");
                        fui.write(temp);
                        this.parameters.put(fui.getFieldName(), new String[]{temp.getAbsolutePath()});
                    }
                    ++i;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            Enumeration e = httpRequest.getParameterNames();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                this.parameters.put(key, httpRequest.getParameterValues(key));
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IDocument doNext() {
        IExecution execution = this.session.getSession().createExecution((IExecutionDescriptor)this);
        Hashtable<String, String> report = new Hashtable<String, String>();
        ((Dictionary)report).put("event", "execution.started");
        ((IReporter)execution.lookupService(IReporter.class.getName())).report(3, "Execution \"" + this.id + "\" Started", report);
        try {
            IDocument document;
            this.interactionTypeRegistry = (IInteractionTypeRegistry)execution.lookupService(IInteractionTypeRegistry.class.getName());
            this.variableRegistry = (IVariableRegistry)execution.lookupService(IVariableRegistry.class.getName());
            IPlatformSelector selector = (IPlatformSelector)execution.lookupService(IPlatformSelector.class.getName());
            if (selector == null) {
                return null;
            }
            this.platform = selector.selectPlatform();
            if (this.platform == null) {
                return null;
            }
            do {
                if (!execution.hasNextStep()) {
                    return null;
                }
                this.command = execution.nextStep();
                document = null;
                if (this.command instanceof ConversationCommand) {
                    this.urlEncoded = true;
                    document = this.platform.createDocument((ILinkFactory)this, (IRenderingQueue)this);
                    continue;
                }
                document = (IDocument)this.command.accept((ICommandVisitor)this);
            } while (document == null);
            IDocument iDocument = document;
            return iDocument;
        }
        finally {
            this.platform = null;
            this.variableRegistry = null;
            this.interactionTypeRegistry = null;
            report = new Hashtable();
            ((Dictionary)report).put("event", "execution.ended");
            ((IReporter)execution.lookupService(IReporter.class.getName())).report(3, "Execution \"" + this.id + "\" Ended", report);
            execution.dispose();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IDocument doAbort() {
        IExecution execution = this.session.getSession().createExecution((IExecutionDescriptor)this);
        try {
            if (!"true".equals(this.session.getAttribute("vtp.ended"))) {
                Hashtable<String, String> report = new Hashtable<String, String>();
                report.put("event", "terminated");
                ((IReporter)execution.lookupService(IReporter.class.getName())).report(3, "Session \"" + this.session.getSessionID() + "\" Terminated", report);
            }
            this.interactionTypeRegistry = (IInteractionTypeRegistry)execution.lookupService(IInteractionTypeRegistry.class.getName());
            IPlatformSelector selector = (IPlatformSelector)execution.lookupService(IPlatformSelector.class.getName());
            if (selector == null) {
                return null;
            }
            this.platform = selector.selectPlatform();
            if (this.platform == null) {
                return null;
            }
            this.command = new EndMessageCommand();
            this.urlEncoded = true;
            IDocument iDocument = this.platform.createDocument((ILinkFactory)this, (IRenderingQueue)this);
            return iDocument;
        }
        finally {
            this.platform = null;
            this.interactionTypeRegistry = null;
            execution.dispose();
        }
    }

    public String getExecutionID() {
        return this.id;
    }

    public String[] getParameterNames() {
        return this.parameters.keySet().toArray(new String[this.parameters.size()]);
    }

    public String getParameter(String parameterName) throws NullPointerException {
        String[] values = this.getParameters(parameterName);
        return values == null || values.length == 0 ? null : values[0];
    }

    public String[] getParameters(String parameterName) throws NullPointerException {
        String[] values = (String[])this.parameters.get(parameterName);
        if (values == null || values.length == 0) {
            return null;
        }
        String[] copy = new String[values.length];
        System.arraycopy(values, 0, copy, 0, values.length);
        return copy;
    }

    public void setParameter(String parameterName, String value) throws NullPointerException {
        String[] stringArray;
        if (value == null) {
            stringArray = null;
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = value;
        }
        this.setParameters(parameterName, stringArray);
    }

    public void setParameters(String parameterName, String[] values) throws NullPointerException {
        if (values == null || values.length == 0) {
            this.clearParameter(parameterName);
        } else {
            String[] copy = new String[values.length];
            System.arraycopy(values, 0, copy, 0, values.length);
            this.parameters.put(parameterName, copy);
        }
    }

    public void clearParameter(String parameterName) throws NullPointerException {
        this.parameters.remove(parameterName);
    }

    public String[] getServiceIdentifiers() {
        return new String[]{IInteractionTypeSelection.class.getName()};
    }

    public Object getService(String identifier) throws NullPointerException {
        return IInteractionTypeSelection.class.getName().equals(identifier) ? this : null;
    }

    public void setUrlEncoded(boolean urlEncoded) {
        this.urlEncoded = urlEncoded;
    }

    public ILink createAbortLink() {
        return new Link("/-/abort");
    }

    public ILink createNextLink() {
        return new Link("/-/next");
    }

    public ILink createResourceLink(String path) {
        if (path == null) {
            return null;
        }
        if (path.startsWith("/")) {
            return new Link("/-/resources" + path);
        }
        return new Link("/-/resources/" + path);
    }

    public boolean isEmpty() {
        return this.command == null || !(this.command instanceof ConversationCommand);
    }

    public ConversationCommand peek() {
        if (this.isEmpty()) {
            return null;
        }
        return (ConversationCommand)this.command;
    }

    public ConversationCommand next() {
        if (this.isEmpty()) {
            return null;
        }
        ConversationCommand command = (ConversationCommand)this.command;
        this.command = null;
        return command;
    }

    public Object visitRunnable(IRunnableCommand runnableCommand) throws NullPointerException {
        runnableCommand.run();
        return null;
    }

    public Object visitInclude(IncludeCommand includeCommand) {
        ControllerDocument doc = new ControllerDocument();
        doc.setTarget(includeCommand.getTargetProcessURI());
        String[] targetNames = includeCommand.getVariableNames();
        int i = 0;
        while (i < targetNames.length) {
            doc.setVariableValue(targetNames[i], this.exportVariable(this.variableRegistry.getVariable(includeCommand.getVariableValue(targetNames[i]))));
            ++i;
        }
        String[] outgoing = includeCommand.getOutgoingPaths();
        int i2 = 0;
        while (i2 < outgoing.length) {
            String[] names = includeCommand.getOutgoingDataNames(outgoing[i2]);
            int j = 0;
            while (j < names.length) {
                doc.setOutgoingDataValue(outgoing[i2], names[j], includeCommand.getOutgoingDataValue(outgoing[i2], names[j]));
                ++j;
            }
            ++i2;
        }
        String[] paramNames = includeCommand.getParameterNames();
        int i3 = 0;
        while (i3 < paramNames.length) {
            doc.setParameterValues(paramNames[i3], includeCommand.getParameterValues(paramNames[i3]));
            ++i3;
        }
        return doc;
    }

    public Object visitExit(ExitCommand exitCommand) {
        ControllerDocument doc = new ControllerDocument();
        doc.setParameterValues("exit", new String[]{exitCommand.getExitValue()});
        String[] vars = exitCommand.getVariableNames();
        int i = 0;
        while (i < vars.length) {
            doc.setVariableValue(vars[i], this.exportVariable(this.variableRegistry.getVariable(vars[i])));
            ++i;
        }
        return doc;
    }

    public Object visitForward(ForwardCommand forwardCommand) {
        return null;
    }

    public Object visitUnknown(ICommand unknownCommand) throws NullPointerException {
        return null;
    }

    public IInteractionType getSelectedInteractionType() {
        if (this.interactionTypeRegistry == null) {
            return null;
        }
        if (this.platform == null) {
            return null;
        }
        return this.interactionTypeRegistry.getInteractionType(this.platform.getInteractionTypeID());
    }

    private Map exportVariable(IDataObject variable) {
        if (variable == null) {
            return null;
        }
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put(null, variable.getType().getName());
        if (variable instanceof IArrayObject) {
            IArrayObject array = (IArrayObject)variable;
            Object[] elements = new Object[array.getLength().getValue().intValue()];
            int i = 0;
            while (i < elements.length) {
                elements[i] = this.exportVariable(array.getElement(i));
                ++i;
            }
            data.put("elements", elements);
        } else if (variable instanceof IBooleanObject) {
            data.put("value", ((IBooleanObject)variable).getValue());
        } else if (variable instanceof IDateObject) {
            data.put("value", ((IDateObject)variable).getValue());
        } else if (variable instanceof IDecimalObject) {
            data.put("value", ((IDecimalObject)variable).getValue());
        } else if (variable instanceof INumberObject) {
            data.put("value", ((INumberObject)variable).getValue());
        } else if (variable instanceof IStringObject) {
            data.put("value", ((IStringObject)variable).getValue());
        } else {
            String[] fields = variable.getType().getFieldNames();
            int i = 0;
            while (i < fields.length) {
                data.put(fields[i], this.exportVariable(variable.getField(fields[i])));
                ++i;
            }
        }
        return data;
    }

    private final class Link
    implements ILink {
        private final String path;
        private final Map parameters = new HashMap();

        Link(String path) {
            String servletPath;
            StringBuffer buffer = new StringBuffer();
            String contextPath = HttpUtils.normalizePath(DeploymentExecution.this.httpRequest.getContextPath());
            if (!contextPath.equals("/")) {
                buffer.append(contextPath);
            }
            if (!(servletPath = HttpUtils.normalizePath(DeploymentExecution.this.httpRequest.getServletPath())).equals("/")) {
                buffer.append(servletPath);
            }
            StringTokenizer st = new StringTokenizer(HttpUtils.normalizePath(path), "/");
            while (st.hasMoreTokens()) {
                try {
                    String token = URLEncoder.encode(st.nextToken(), "UTF-8");
                    StringBuffer b = new StringBuffer();
                    int i = 0;
                    while (i < token.length()) {
                        if (token.charAt(i) == '+') {
                            b.append("%20");
                        } else {
                            b.append(token.charAt(i));
                        }
                        ++i;
                    }
                    buffer.append('/').append(b.toString());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            this.path = buffer.toString();
            String[] mode = DeploymentExecution.this.getParameters("MODE");
            if (mode != null && mode.length > 0) {
                this.setParameters("MODE", mode);
            }
        }

        private String encode(String url) {
            String encoded = null;
            encoded = DeploymentExecution.this.urlEncoded ? DeploymentExecution.this.httpResponse.encodeURL(url) : (url.startsWith("/") && !url.startsWith(String.valueOf(DeploymentExecution.this.httpRequest.getContextPath()) + "/") ? String.valueOf(DeploymentExecution.this.httpRequest.getContextPath()) + url : url);
            return encoded;
        }

        public void setParameter(String parameterName, String parameterValue) {
            String[] stringArray;
            if (parameterValue == null) {
                stringArray = null;
            } else {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = parameterValue;
            }
            this.setParameters(parameterName, stringArray);
        }

        public void setParameters(String parameterName, String[] parameterValue) {
            if (parameterName == null) {
                return;
            }
            if (parameterValue == null) {
                this.parameters.remove(parameterName);
            } else {
                this.parameters.put(parameterName, parameterValue);
            }
        }

        public String toString() {
            if (this.parameters.isEmpty()) {
                return this.encode(this.path);
            }
            StringBuffer buffer = new StringBuffer(this.path).append('?');
            for (Map.Entry entry : this.parameters.entrySet()) {
                String name = (String)entry.getKey();
                String[] values = (String[])entry.getValue();
                if (values.length == 0) continue;
                try {
                    buffer.append(URLEncoder.encode(name, "UTF-8"));
                    buffer.append('=');
                    int j = 0;
                    while (j < values.length) {
                        if (j > 0) {
                            buffer.append(',');
                        }
                        buffer.append(URLEncoder.encode(values[j], "UTF-8"));
                        ++j;
                    }
                    buffer.append('&');
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            buffer.setLength(buffer.length() - 1);
            return this.encode(buffer.toString());
        }
    }
}

