/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.framework.engine.http;

import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.eclipse.vtp.framework.common.IArrayObject;
import org.eclipse.vtp.framework.common.IBooleanObject;
import org.eclipse.vtp.framework.common.IBrand;
import org.eclipse.vtp.framework.common.IBrandRegistry;
import org.eclipse.vtp.framework.common.IBrandSelection;
import org.eclipse.vtp.framework.common.IDataObject;
import org.eclipse.vtp.framework.common.IDateObject;
import org.eclipse.vtp.framework.common.IDecimalObject;
import org.eclipse.vtp.framework.common.INumberObject;
import org.eclipse.vtp.framework.common.IStringObject;
import org.eclipse.vtp.framework.common.IVariableRegistry;
import org.eclipse.vtp.framework.core.IReporter;
import org.eclipse.vtp.framework.engine.http.DeploymentExecution;
import org.eclipse.vtp.framework.interactions.core.platforms.IDocument;
import org.eclipse.vtp.framework.spi.IProcess;
import org.eclipse.vtp.framework.spi.ISession;
import org.eclipse.vtp.framework.spi.ISessionDescriptor;

public class DeploymentSession
implements ISessionDescriptor {
    private static final String EXECUTION_ID = "execution.id";
    private final String id;
    private final ISession session;
    private HttpSession httpSession = null;
    private String qualifier = null;

    private static void assignVariables(IVariableRegistry variableRegistry, Map variables) {
        for (Map.Entry entry : variables.entrySet()) {
            IDataObject variable = DeploymentSession.importVariable(variableRegistry, (Map)entry.getValue());
            if (variable == null) continue;
            variableRegistry.setVariable((String)entry.getKey(), variable);
        }
    }

    private static IDataObject importVariable(IVariableRegistry variableRegistry, Map data) {
        if (data == null) {
            return null;
        }
        String typeName = (String)data.get(null);
        if (typeName == null) {
            return null;
        }
        IDataObject variable = variableRegistry.createVariable(typeName);
        if (variable == null) {
            return null;
        }
        if (variable instanceof IArrayObject) {
            IArrayObject array = (IArrayObject)variable;
            Object[] elements = (Object[])data.get("elements");
            int i = 0;
            while (i < elements.length) {
                array.addElement(DeploymentSession.importVariable(variableRegistry, (Map)elements[i]));
                ++i;
            }
        } else if (variable instanceof IBooleanObject) {
            ((IBooleanObject)variable).setValue(data.get("value"));
        } else if (variable instanceof IDateObject) {
            ((IDateObject)variable).setValue(data.get("value"));
        } else if (variable instanceof IDecimalObject) {
            ((IDecimalObject)variable).setValue(data.get("value"));
        } else if (variable instanceof INumberObject) {
            ((INumberObject)variable).setValue(data.get("value"));
        } else if (variable instanceof IStringObject) {
            ((IStringObject)variable).setValue(data.get("value"));
        } else {
            String[] fields = variable.getType().getFieldNames();
            int i = 0;
            while (i < fields.length) {
                variable.setField(fields[i], DeploymentSession.importVariable(variableRegistry, (Map)data.get(fields[i])));
                ++i;
            }
        }
        return variable;
    }

    DeploymentSession(String id, IProcess process) {
        this.id = id;
        this.session = process.createSession((ISessionDescriptor)this);
    }

    public ISession getSession() {
        return this.session;
    }

    public IDocument start(HttpSession httpSession, HttpServletRequest httpRequest, HttpServletResponse httpReesponse, String prefix, Map variableValues, Map parameterValues, String brand) {
        this.httpSession = httpSession;
        this.qualifier = prefix;
        try {
            DeploymentSession.assignVariables((IVariableRegistry)this.session.lookupService(IVariableRegistry.class.getName()), variableValues);
            IBrandRegistry brands = (IBrandRegistry)this.session.lookupService(IBrandRegistry.class.getName());
            IBrand selectedBrand = brands.getBrand(brand);
            if (selectedBrand != null) {
                ((IBrandSelection)this.session.lookupService(IBrandSelection.class.getName())).setSelectedBrand(selectedBrand);
            } else {
                selectedBrand = brands.getDefaultBrand();
            }
            IVariableRegistry variables = (IVariableRegistry)this.session.lookupService(IVariableRegistry.class.getName());
            IDataObject platform = variables.createVariable("Platform");
            ((IStringObject)platform.getField("Brand")).setValue((Object)selectedBrand.getName());
            if (httpRequest.getParameter("ANI") != null) {
                ((IStringObject)platform.getField("ANI")).setValue((Object)httpRequest.getParameter("ANI"));
            }
            if (httpRequest.getParameter("DNIS") != null) {
                ((IStringObject)platform.getField("DNIS")).setValue((Object)httpRequest.getParameter("DNIS"));
            }
            variables.setVariable("Platform", platform);
            Hashtable<String, String> report = new Hashtable<String, String>();
            ((Dictionary)report).put("event", "session.created");
            ((IReporter)this.session.lookupService(IReporter.class.getName())).report(3, "Session \"" + this.id + "\" created.", report);
            IDocument iDocument = new DeploymentExecution(this.getNextExecutionID(), this, httpRequest, httpReesponse, parameterValues).doNext();
            return iDocument;
        }
        finally {
            this.qualifier = null;
            this.httpSession = null;
        }
    }

    public IDocument next(HttpSession httpSession, HttpServletRequest httpRequest, HttpServletResponse httpReesponse, String prefix, Map variableValues, Map parameterValues) {
        this.httpSession = httpSession;
        this.qualifier = prefix;
        try {
            DeploymentSession.assignVariables((IVariableRegistry)this.session.lookupService(IVariableRegistry.class.getName()), variableValues);
            IDocument iDocument = new DeploymentExecution(this.getNextExecutionID(), this, httpRequest, httpReesponse, parameterValues).doNext();
            return iDocument;
        }
        finally {
            this.qualifier = null;
            this.httpSession = null;
        }
    }

    public IDocument abort(HttpSession httpSession, HttpServletRequest httpRequest, HttpServletResponse httpReesponse, String prefix, Map variableValues, Map parameterValues) {
        this.httpSession = httpSession;
        this.qualifier = prefix;
        try {
            DeploymentSession.assignVariables((IVariableRegistry)this.session.lookupService(IVariableRegistry.class.getName()), variableValues);
            IDocument iDocument = new DeploymentExecution(this.getNextExecutionID(), this, httpRequest, httpReesponse, parameterValues).doAbort();
            return iDocument;
        }
        finally {
            Hashtable<String, String> report = new Hashtable<String, String>();
            ((Dictionary)report).put("event", "session.disposed");
            ((IReporter)this.session.lookupService(IReporter.class.getName())).report(3, "Session \"" + this.id + "\" disposed.", report);
            this.qualifier = null;
            this.httpSession = null;
            httpSession.invalidate();
        }
    }

    private String getNextExecutionID() {
        Object executionID = this.httpSession.getAttribute(String.valueOf(this.qualifier) + EXECUTION_ID);
        if (!(executionID instanceof Integer)) {
            executionID = new Integer(0);
        }
        executionID = new Integer((Integer)executionID + 1);
        this.httpSession.setAttribute(String.valueOf(this.qualifier) + EXECUTION_ID, executionID);
        return executionID.toString();
    }

    public String getSessionID() {
        return this.id;
    }

    public String[] getServiceIdentifiers() {
        return new String[0];
    }

    public Object getService(String identifier) throws NullPointerException {
        return null;
    }

    public String[] getAttributeNames() {
        LinkedList<String> list = new LinkedList<String>();
        if (this.httpSession != null) {
            Enumeration e = this.httpSession.getAttributeNames();
            while (e.hasMoreElements()) {
                String name = (String)e.nextElement();
                if (!name.startsWith(this.qualifier)) continue;
                list.add(name.substring(this.qualifier.length()));
            }
        }
        return list.toArray(new String[list.size()]);
    }

    public Object getAttribute(String attributeName) throws NullPointerException {
        return this.httpSession == null ? null : this.httpSession.getAttribute(String.valueOf(this.qualifier) + attributeName);
    }

    public void setAttribute(String attributeName, Object attributeValue) throws NullPointerException {
        if (this.httpSession != null) {
            this.httpSession.setAttribute(String.valueOf(this.qualifier) + attributeName, attributeValue);
        }
    }

    public void clearAttribute(String attributeName) throws NullPointerException {
        if (this.httpSession != null) {
            this.httpSession.removeAttribute(String.valueOf(this.qualifier) + attributeName);
        }
    }
}

