/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.framework.engine.http;

import java.io.IOException;
import java.io.PrintWriter;
import java.net.URL;
import java.util.Collections;
import java.util.Comparator;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import org.eclipse.vtp.framework.core.IReporter;
import org.eclipse.vtp.framework.engine.ResourceGroup;
import org.eclipse.vtp.framework.engine.http.ControllerDocument;
import org.eclipse.vtp.framework.engine.http.Deployment;
import org.eclipse.vtp.framework.engine.http.HttpConnectorContext;
import org.eclipse.vtp.framework.engine.http.HttpConnectorServlet;
import org.eclipse.vtp.framework.engine.http.HttpUtils;
import org.eclipse.vtp.framework.interactions.core.media.IResourceManager;
import org.eclipse.vtp.framework.interactions.core.platforms.IDocument;
import org.eclipse.vtp.framework.spi.IProcessDefinition;
import org.eclipse.vtp.framework.spi.IProcessEngine;
import org.eclipse.vtp.framework.util.XMLWriter;
import org.osgi.framework.Bundle;
import org.osgi.service.http.HttpContext;
import org.osgi.service.http.HttpService;
import org.osgi.service.http.NamespaceException;
import org.osgi.service.log.LogService;

public class HttpConnector {
    public static final String PATH_PREFIX = "/-/";
    public static final String ABORT_PATH = "/-/abort";
    public static final String INDEX_PATH = "/-/index";
    public static final String NEXT_PATH = "/-/next";
    public static final String RESOURCES_PATH = "/-/resources";
    private static final String MIME_TYPE_PREFIX = "mime.type.";
    private static final String DEPLOYMENT_ID = "deployment.id";
    private static final Comparator PATH_SORT = new Comparator(){

        public int compare(Object left, Object right) {
            String leftStr = (String)left;
            String rightStr = (String)right;
            int difference = rightStr.length() - leftStr.length();
            if (difference == 0) {
                difference = leftStr.compareTo(rightStr);
            }
            return difference;
        }
    };
    private final IProcessEngine engine;
    private final HttpService httpService;
    private final IReporter reporter;
    private final Transformer transformer;
    private final Map definitionsByID = new HashMap();
    private final Map definitionContributors = new HashMap();
    private final Map resourcesByID = new HashMap();
    private Dictionary properties = null;
    private String servletPath = null;
    private String resourcesPath = null;
    private boolean open = false;
    private final Map deploymentsByKey = new HashMap();
    private final Map deploymentsByID = new HashMap();
    private final Map deploymentsByPath = new TreeMap(PATH_SORT);

    public HttpConnector(LogService log, IProcessEngine engine, HttpService httpService, IReporter reporter) {
        this.engine = engine;
        this.httpService = httpService;
        this.reporter = reporter;
        try {
            this.transformer = TransformerFactory.newInstance().newTransformer();
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerDefinition(String definitionID, IProcessDefinition definition, Bundle contributor) {
        Map map = this.definitionsByID;
        synchronized (map) {
            this.definitionsByID.put(definitionID, definition);
            this.definitionContributors.put(definitionID, contributor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseDefinition(String definitionID) {
        Map map = this.definitionsByID;
        synchronized (map) {
            this.definitionContributors.remove(definitionID);
            this.definitionsByID.remove(definitionID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerResouces(String resourcesID, ResourceGroup resources) {
        Map map = this.resourcesByID;
        synchronized (map) {
            this.resourcesByID.put(resourcesID, resources);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseResouces(String resourcesID) {
        Map map = this.resourcesByID;
        synchronized (map) {
            this.resourcesByID.remove(resourcesID);
        }
    }

    public synchronized void configure(Dictionary properties) {
        this.close();
        this.properties = properties;
        this.open();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void deploy(String key, Dictionary properties) {
        Deployment deployment = (Deployment)this.deploymentsByKey.remove(key);
        if (deployment != null) {
            this.deploymentsByPath.remove(deployment.getPath());
        }
        String definitionID = (String)properties.get("definition.id");
        String deploymentID = (String)properties.get(DEPLOYMENT_ID);
        String path = (String)properties.get("path");
        IProcessDefinition definition = null;
        Bundle contributor = null;
        Map map = this.definitionsByID;
        synchronized (map) {
            definition = (IProcessDefinition)this.definitionsByID.get(definitionID);
            contributor = (Bundle)this.definitionContributors.get(definitionID);
        }
        if (definition == null || contributor == null) {
            return;
        }
        try {
            deployment = new Deployment(this.engine, definition, properties, contributor, this.reporter);
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
        map = this.resourcesByID;
        synchronized (map) {
            for (Map.Entry entry : this.resourcesByID.entrySet()) {
                deployment.setResourceManager((String)entry.getKey(), (IResourceManager)entry.getValue());
            }
        }
        if (deploymentID == null) {
            return;
        }
        if (this.deploymentsByID.containsKey(deploymentID)) {
            return;
        }
        this.deploymentsByKey.put(key, deployment);
        this.deploymentsByID.put(deploymentID, deployment);
        if (path == null) {
            return;
        }
        if (this.deploymentsByPath.containsKey(path)) {
            return;
        }
        this.deploymentsByPath.put(path, deployment);
    }

    public synchronized void undeploy(String key) {
        Deployment deployment = (Deployment)this.deploymentsByKey.remove(key);
        if (deployment == null) {
            return;
        }
        this.deploymentsByPath.remove(deployment.getPath());
        deployment.dispose();
    }

    public void process(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        try {
            this.invokeProcessEngine(req, res, req.getSession(), HttpUtils.normalizePath(req.getPathInfo()), Collections.EMPTY_MAP, Collections.EMPTY_MAP, false);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invokeProcessEngine(HttpServletRequest req, HttpServletResponse res, HttpSession httpSession, String pathInfo, Map variableValues, Map parameterValues, boolean fragment) throws IOException, ServletException {
        boolean newSession = false;
        Integer depth = (Integer)httpSession.getAttribute("connector.depth");
        if (depth == null) {
            depth = new Integer(0);
        }
        String prefix = "connector.attributes." + depth + ".";
        if (!fragment) {
            httpSession.setAttribute(String.valueOf(prefix) + "fragment", (Object)"false");
        }
        Deployment deployment = null;
        String brand = null;
        if (!pathInfo.startsWith(PATH_PREFIX)) {
            newSession = true;
            HttpConnector httpConnector = this;
            synchronized (httpConnector) {
                for (String path : this.deploymentsByPath.keySet()) {
                    if (!pathInfo.equals(path) && (!pathInfo.startsWith(path) || pathInfo.length() <= path.length() || pathInfo.charAt(path.length()) != '/')) continue;
                    deployment = (Deployment)this.deploymentsByPath.get(path);
                    if (pathInfo.length() <= path.length() + 1) break;
                    brand = pathInfo.substring(path.length() + 1);
                    break;
                }
            }
            if (deployment == null) {
                res.sendError(404);
                return;
            }
            pathInfo = NEXT_PATH;
            httpSession.setAttribute(String.valueOf(prefix) + DEPLOYMENT_ID, (Object)deployment.getProcessID());
        } else {
            String deploymentID = (String)httpSession.getAttribute(String.valueOf(prefix) + DEPLOYMENT_ID);
            HttpConnector i = this;
            synchronized (i) {
                deployment = (Deployment)this.deploymentsByID.get(deploymentID);
            }
            if (deployment == null) {
                res.sendError(403);
                return;
            }
        }
        if (pathInfo.equals(INDEX_PATH)) {
            this.writeIndex(res, deployment);
            return;
        }
        IDocument document = null;
        if (pathInfo.equals(ABORT_PATH)) {
            document = deployment.abort(httpSession, req, res, prefix, variableValues, parameterValues);
        } else if (pathInfo.equals(NEXT_PATH)) {
            document = brand == null && !newSession ? deployment.next(httpSession, req, res, prefix, variableValues, parameterValues) : deployment.start(httpSession, req, res, prefix, variableValues, parameterValues, brand);
        } else {
            res.sendError(404);
            return;
        }
        if (document == null) {
            res.setStatus(204);
            return;
        }
        if (document instanceof ControllerDocument) {
            ControllerDocument cd = (ControllerDocument)document;
            if (cd.getTarget() == null) {
                Map map;
                Map outgoing = (Map)httpSession.getAttribute(String.valueOf(prefix) + "outgoing-data");
                if (depth == 1) {
                    httpSession.removeAttribute("connector.depth");
                } else {
                    httpSession.setAttribute("connector.depth", (Object)new Integer(depth - 1));
                }
                String oldPrefix = prefix;
                prefix = "connector.attributes." + (depth - 1) + ".";
                Object[] params = (Object[])httpSession.getAttribute(String.valueOf(prefix) + "exitparams");
                HashMap<Object, Object> parameters = new HashMap<Object, Object>();
                if (params != null) {
                    int i = 0;
                    while (i < params.length) {
                        parameters.put(params[i], params[i + 1]);
                        i += 2;
                    }
                }
                String[] paramNames = cd.getParameterNames();
                int i = 0;
                while (i < paramNames.length) {
                    parameters.put(paramNames[i], cd.getParameterValues(paramNames[i]));
                    ++i;
                }
                String[] variableNames = cd.getVariableNames();
                HashMap variables = new HashMap(variableNames.length);
                if (outgoing != null && (map = (Map)outgoing.get(cd.getParameterValues("exit")[0])) != null) {
                    int i2 = 0;
                    while (i2 < variableNames.length) {
                        Object mapping = map.get(variableNames[i2]);
                        if (mapping != null) {
                            variables.put(mapping, cd.getVariableValue(variableNames[i2]));
                        }
                        ++i2;
                    }
                }
                Enumeration e = httpSession.getAttributeNames();
                while (e.hasMoreElements()) {
                    String name = (String)e.nextElement();
                    if (!name.startsWith(oldPrefix)) continue;
                    httpSession.removeAttribute(name);
                }
                this.invokeProcessEngine(req, res, httpSession, NEXT_PATH, variables, parameters, true);
                return;
            }
            String[] paramNames = cd.getParameterNames();
            Object[] params = new Object[paramNames.length * 2];
            int i = 0;
            while (i < params.length) {
                params[i] = paramNames[i / 2];
                params[i + 1] = cd.getParameterValues(paramNames[i / 2]);
                i += 2;
            }
            httpSession.setAttribute(String.valueOf(prefix) + "exitparams", (Object)params);
            String[] variableNames = cd.getVariableNames();
            HashMap<String, Object> variables = new HashMap<String, Object>(variableNames.length);
            int i3 = 0;
            while (i3 < variableNames.length) {
                variables.put(variableNames[i3], cd.getVariableValue(variableNames[i3]));
                ++i3;
            }
            httpSession.setAttribute("connector.depth", (Object)new Integer(depth + 1));
            prefix = "connector.attributes." + (depth + 1) + ".";
            httpSession.setAttribute(String.valueOf(prefix) + DEPLOYMENT_ID, (Object)cd.getTarget());
            HashMap outgoing = new HashMap();
            String[] outPaths = cd.getOutgoingPaths();
            int i4 = 0;
            while (i4 < outPaths.length) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                String[] names = cd.getOutgoingDataNames(outPaths[i4]);
                int j = 0;
                while (j < names.length) {
                    map.put(names[j], cd.getOutgoingDataValue(outPaths[i4], names[j]));
                    ++j;
                }
                outgoing.put(outPaths[i4], map);
                ++i4;
            }
            httpSession.setAttribute(String.valueOf(prefix) + "outgoing-data", outgoing);
            this.invokeProcessEngine(req, res, httpSession, NEXT_PATH, variables, Collections.EMPTY_MAP, fragment);
            return;
        }
        res.setStatus(200);
        res.setContentType(document.getContentType());
        PrintWriter writer = res.getWriter();
        try {
            this.transformer.transform(document.toXMLSource(), new XMLWriter(writer).toXMLResult());
        }
        catch (TransformerException e) {
            throw new ServletException((Throwable)e);
        }
        writer.flush();
        writer.close();
    }

    public String getMimeType(String resourcePath) {
        Dictionary properties = this.properties;
        if (properties == null) {
            return null;
        }
        if (resourcePath == null || properties.isEmpty()) {
            return null;
        }
        int lastSlash = resourcePath.lastIndexOf(47);
        if (lastSlash >= 0) {
            resourcePath = resourcePath.substring(lastSlash + 1);
        }
        if (resourcePath.length() == 0) {
            return null;
        }
        Object mimeType = properties.get(MIME_TYPE_PREFIX + resourcePath);
        while (!(mimeType instanceof String)) {
            int firstDot = resourcePath.indexOf(46);
            if (firstDot < 0) {
                return null;
            }
            resourcePath = resourcePath.substring(firstDot + 1);
            mimeType = properties.get(MIME_TYPE_PREFIX + resourcePath);
        }
        return (String)mimeType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public URL getResource(String resourcePath) {
        String normal = HttpUtils.normalizePath(resourcePath).substring(1);
        int firstSlash = normal.indexOf(47);
        if (firstSlash < 0) {
            return null;
        }
        String resourcesID = normal.substring(0, firstSlash);
        ResourceGroup resources = null;
        Map map = this.resourcesByID;
        synchronized (map) {
            resources = (ResourceGroup)this.resourcesByID.get(resourcesID);
        }
        if (resources == null) {
            return null;
        }
        return resources.getResource(normal.substring(firstSlash + 1));
    }

    private void open() {
        if (this.open) {
            return;
        }
        try {
            try {
                String servletPath = null;
                String resourcesPath = null;
                Object path = this.properties == null ? null : this.properties.get("path");
                servletPath = path instanceof String ? HttpUtils.normalizePath(path) : "/";
                resourcesPath = "/".equals(servletPath) ? RESOURCES_PATH : String.valueOf(servletPath) + RESOURCES_PATH;
                HttpConnectorContext context = new HttpConnectorContext(this.httpService.createDefaultHttpContext(), this);
                this.httpService.registerResources(resourcesPath, "/", (HttpContext)context);
                this.resourcesPath = resourcesPath;
                this.httpService.registerServlet(servletPath, (Servlet)new HttpConnectorServlet(this), null, (HttpContext)context);
                this.servletPath = servletPath;
                this.open = true;
            }
            catch (NamespaceException e) {
                throw new IllegalArgumentException(e);
            }
            catch (ServletException e) {
                throw new IllegalArgumentException(e);
            }
        }
        finally {
            if (!this.open && this.resourcesPath != null) {
                String resourcesPath = this.resourcesPath;
                this.resourcesPath = null;
                this.httpService.unregister(resourcesPath);
            }
        }
    }

    private void close() {
        if (!this.open) {
            return;
        }
        this.open = false;
        try {
            if (this.servletPath != null) {
                this.httpService.unregister(this.servletPath);
            }
        }
        finally {
            this.servletPath = null;
            try {
                if (this.resourcesPath != null) {
                    this.httpService.unregister(this.resourcesPath);
                }
            }
            finally {
                this.resourcesPath = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeIndex(HttpServletResponse res, Deployment deployment) throws IOException {
        String deploymentID = deployment.getID();
        res.setStatus(200);
        res.setContentType("text/html");
        PrintWriter writer = res.getWriter();
        writer.println("<html>");
        writer.println("<head><title>Deployments</title></head>");
        writer.println("<body>");
        if (deploymentID != null) {
            writer.print("<p>CURRENT: ");
            writer.print(deploymentID);
            writer.println("</p>");
        }
        HttpConnector httpConnector = this;
        synchronized (httpConnector) {
            for (Map.Entry entry : this.deploymentsByPath.entrySet()) {
                writer.print("<p><a href=\"");
                writer.print(res.encodeURL((String)entry.getKey()));
                writer.print("\">");
                writer.print(((Deployment)entry.getValue()).getProcessID());
                writer.println("</a></p>");
            }
        }
        writer.println("</body>");
        writer.println("</html>");
        writer.flush();
        writer.close();
    }
}

